/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.SdkConstants;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2DaemonManagerMaintainer;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.builder.internal.aapt.v2.Aapt2DaemonImpl;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.utils.ILogger;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Ljava/lang/AutoCloseable;", "()V", "closer", "Lcom/google/common/io/Closer;", "kotlin.jvm.PlatformType", "registeredServices", "", "Lcom/android/build/gradle/internal/services/Aapt2DaemonServiceKey;", "close", "", "registerAaptService", "aapt2FromMaven", "Ljava/io/File;", "logger", "Lcom/android/utils/ILogger;", "serviceRegistry", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry;", "RegistrationAction", "gradle"})
public abstract class Aapt2DaemonBuildService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    private final Set<Aapt2DaemonServiceKey> registeredServices;
    private final Closer closer;

    @JvmOverloads
    @NotNull
    public final synchronized Aapt2DaemonServiceKey registerAaptService(@NotNull File aapt2FromMaven, @NotNull ILogger logger, @NotNull WorkerActionServiceRegistry serviceRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2FromMaven, (String)"aapt2FromMaven");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)serviceRegistry, (String)"serviceRegistry");
        Aapt2DaemonServiceKey key = new Aapt2DaemonServiceKey(aapt2FromMaven);
        Path aaptExecutablePath = aapt2FromMaven.toPath().resolve(SdkConstants.FN_AAPT2);
        if (!Files.exists(aaptExecutablePath, new LinkOption[0])) {
            throw (Throwable)new InvalidUserDataException("Specified AAPT2 executable does not exist: " + aaptExecutablePath + ". " + "Must supply one of aapt2 from maven or custom location.");
        }
        if (this.registeredServices.add(key)) {
            Aapt2DaemonManager manager2 = new Aapt2DaemonManager(logger, (Function1)new Function1<Integer, Aapt2DaemonImpl>(aaptExecutablePath, logger){
                final /* synthetic */ Path $aaptExecutablePath;
                final /* synthetic */ ILogger $logger;

                @NotNull
                public final Aapt2DaemonImpl invoke(int displayId) {
                    String string = "" + '#' + displayId;
                    Path path = this.$aaptExecutablePath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"aaptExecutablePath");
                    return new Aapt2DaemonImpl(string, path, Aapt2Daemon.access$getDaemonTimeouts$p(), this.$logger);
                }
                {
                    this.$aaptExecutablePath = path;
                    this.$logger = iLogger;
                    super(1);
                }
            }, Aapt2Daemon.access$getDaemonExpiryTimeSeconds$p(), TimeUnit.SECONDS, (Aapt2DaemonManager.Listener)new Aapt2DaemonManagerMaintainer(), null, 32, null);
            this.closer.register(new Closeable(manager2){
                final /* synthetic */ Aapt2DaemonManager $manager;

                public final void close() {
                    this.$manager.shutdown();
                }
                {
                    this.$manager = aapt2DaemonManager;
                }
            });
            this.closer.register(serviceRegistry.registerServiceAsCloseable(key, manager2));
        }
        return key;
    }

    public static /* synthetic */ Aapt2DaemonServiceKey registerAaptService$default(Aapt2DaemonBuildService aapt2DaemonBuildService, File file, ILogger iLogger, WorkerActionServiceRegistry workerActionServiceRegistry, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerAaptService");
        }
        if ((n & 4) != 0) {
            workerActionServiceRegistry = Aapt2Daemon.getAapt2DaemonServiceRegistry();
        }
        return aapt2DaemonBuildService.registerAaptService(file, iLogger, workerActionServiceRegistry);
    }

    @JvmOverloads
    @NotNull
    public final Aapt2DaemonServiceKey registerAaptService(@NotNull File aapt2FromMaven, @NotNull ILogger logger) {
        return Aapt2DaemonBuildService.registerAaptService$default(this, aapt2FromMaven, logger, null, 4, null);
    }

    @Override
    public void close() {
        this.closer.close();
    }

    public Aapt2DaemonBuildService() {
        Set set;
        Aapt2DaemonBuildService aapt2DaemonBuildService = this;
        boolean bl = false;
        aapt2DaemonBuildService.registeredServices = set = (Set)new LinkedHashSet();
        this.closer = Closer.create();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<Aapt2DaemonBuildService, BuildServiceParameters.None> {
        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        }

        public RegistrationAction(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, Aapt2DaemonBuildService.class);
        }
    }
}

