/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.VariantOutputConfigurationImplKt;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;

public abstract class BaseVariantOutputImpl
implements BaseVariantOutput {
    protected final TaskContainer taskContainer;
    protected final BaseServices services;
    protected final VariantOutputImpl variantOutput;

    protected BaseVariantOutputImpl(TaskContainer taskContainer, BaseServices services2, VariantOutputImpl variantOutput) {
        this.taskContainer = taskContainer;
        this.services = services2;
        this.variantOutput = variantOutput;
    }

    public OutputFile getMainOutputFile() {
        throw new UnsupportedOperationException("getMainOutputFile is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public File getOutputFile() {
        throw new UnsupportedOperationException("getOutputFile is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public ImmutableList<OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    @Override
    public ProcessAndroidResources getProcessResources() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getProcessResourcesProvider()", "variantOutput.getProcessResources()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (ProcessAndroidResources)this.taskContainer.getProcessAndroidResTask().getOrNull();
    }

    @Override
    public TaskProvider<ProcessAndroidResources> getProcessResourcesProvider() {
        return this.taskContainer.getProcessAndroidResTask();
    }

    @Override
    public ManifestProcessorTask getProcessManifest() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getProcessManifestProvider()", "variantOutput.getProcessManifest()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (ManifestProcessorTask)this.taskContainer.getProcessManifestTask().get();
    }

    @Override
    public TaskProvider<ManifestProcessorTask> getProcessManifestProvider() {
        return this.taskContainer.getProcessManifestTask();
    }

    @Override
    public Task getAssemble() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getAssembleProvider()", "variantOutput.getAssemble()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.taskContainer.getAssembleTask().get();
    }

    @Override
    public String getName() {
        return this.variantOutput.getBaseName();
    }

    @Override
    public String getBaseName() {
        return this.variantOutput.getBaseName();
    }

    @Override
    public String getDirName() {
        return VariantOutputConfigurationImplKt.dirName(this.variantOutput.getVariantOutputConfiguration());
    }

    public String getOutputType() {
        if (this.variantOutput.getOutputType() == VariantOutputConfiguration.OutputType.SINGLE) {
            return VariantOutput.OutputType.MAIN.name();
        }
        return VariantOutput.OutputType.FULL_SPLIT.name();
    }

    public Collection<String> getFilterTypes() {
        return this.variantOutput.getVariantOutputConfiguration().getFilters().stream().map(FilterConfiguration::getFilterType).map(Enum::name).collect(Collectors.toList());
    }

    public Collection<FilterData> getFilters() {
        return this.variantOutput.getVariantOutputConfiguration().getFilters().stream().map(filter2 -> new FilterDataImpl(filter2.getFilterType().name(), filter2.getIdentifier())).collect(Collectors.toList());
    }

    public String getFilter(String filterType2) {
        FilterConfiguration filter2 = this.variantOutput.getFilter(FilterConfiguration.FilterType.valueOf((String)filterType2));
        return filter2 != null ? filter2.getIdentifier() : null;
    }

    public String getOutputFileName() {
        return (String)this.variantOutput.getOutputFileName().get();
    }

    public void setOutputFileName(String outputFileName) {
        if (new File(outputFileName).isAbsolute()) {
            throw new GradleException("Absolute path are not supported when setting an output file name");
        }
        this.variantOutput.getOutputFileName().set((Object)outputFileName);
    }
}

