/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.DataInputOutputUtils;
import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.tensorflow.lite.schema.Metadata;
import org.tensorflow.lite.schema.Model;
import org.tensorflow.lite.schema.QuantizationParameters;
import org.tensorflow.lite.schema.SubGraph;
import org.tensorflow.lite.schema.Tensor;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;

public class MetadataExtractor {
    private final Model bufferModel;

    public MetadataExtractor(ByteBuffer buffer) {
        this.bufferModel = Model.getRootAsModel((ByteBuffer)buffer);
        if (this.bufferModel.subgraphsLength() != 1) {
            throw new IllegalArgumentException("Only model with one subgraph is supported.");
        }
    }

    public int getInputTensorCount() {
        return this.bufferModel.subgraphs(0).inputsLength();
    }

    public int getOutputTensorCount() {
        return this.bufferModel.subgraphs(0).outputsLength();
    }

    public int[] getInputTensorShape(int inputIndex) {
        Tensor tensor = this.getInputTensor(inputIndex);
        return MetadataExtractor.getShape(tensor);
    }

    public byte getInputTensorType(int inputIndex) {
        Tensor tensor = this.getInputTensor(inputIndex);
        return tensor.type();
    }

    public int[] getOutputTensorShape(int outputIndex) {
        Tensor tensor = this.getOutputTensor(outputIndex);
        return MetadataExtractor.getShape(tensor);
    }

    public byte getOutputTensorType(int outputIndex) {
        Tensor tensor = this.getOutputTensor(outputIndex);
        return tensor.type();
    }

    public String getMinParserVersion() {
        ModelMetadata modelMetadata = this.getModelMetaData();
        if (modelMetadata == null) {
            return "";
        }
        return Strings.nullToEmpty((String)modelMetadata.minParserVersion());
    }

    public Tensor getInputTensor(int inputIndex) {
        return this.getTensor(inputIndex, true);
    }

    public Tensor getOutputTensor(int outputIndex) {
        return this.getTensor(outputIndex, false);
    }

    private Tensor getTensor(int tensorIndex, boolean isInput) {
        SubGraph subgraph = this.bufferModel.subgraphs(0);
        if (isInput) {
            return subgraph.tensors(subgraph.inputs(tensorIndex));
        }
        return subgraph.tensors(subgraph.outputs(tensorIndex));
    }

    private static int[] getShape(Tensor tensor) {
        int shapeDim = tensor.shapeLength();
        int[] tensorShape = new int[shapeDim];
        for (int i2 = 0; i2 < shapeDim; ++i2) {
            tensorShape[i2] = tensor.shape(i2);
        }
        return tensorShape;
    }

    public ModelMetadata getModelMetaData() {
        int length = this.bufferModel.metadataLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Metadata metadata = this.bufferModel.metadata(i2);
            if (!"TFLITE_METADATA".equals(metadata.name())) continue;
            long bufferIndex = metadata.buffer();
            return ModelMetadata.getRootAsModelMetadata((ByteBuffer)this.bufferModel.buffers((int)bufferIndex).dataAsByteBuffer());
        }
        return null;
    }

    public static QuantizationParams getQuantizationParams(Tensor tensor) {
        long zeroPoint;
        float scale;
        byte tensorType = tensor.type();
        if (tensorType == 2 || tensorType == 4 || tensorType == 3) {
            QuantizationParameters quantization = tensor.quantization();
            scale = quantization.scale(0) == 0.0f ? 1.0f : quantization.scale(0);
            zeroPoint = quantization.zeroPoint(0);
        } else {
            scale = 1.0f;
            zeroPoint = 0L;
        }
        return new QuantizationParams(scale, zeroPoint);
    }

    static int compareVersions(String version1, String version2) {
        String[] levels1 = version1.split("\\.", 0);
        String[] levels2 = version2.split("\\.", 0);
        int length = Math.max(levels1.length, levels2.length);
        for (int i2 = 0; i2 < length; ++i2) {
            Integer v2;
            Integer v1 = i2 < levels1.length ? Integer.parseInt(levels1[i2]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i2 < levels2.length ? Integer.parseInt(levels2[i2]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static class NormalizationParams {
        private final float[] mean;
        private final float[] std;
        private final float[] min;
        private final float[] max;

        public NormalizationParams(FloatBuffer meanBuffer, FloatBuffer stdBuffer, FloatBuffer minBuffer, FloatBuffer maxBuffer) {
            this.mean = new float[meanBuffer.limit()];
            meanBuffer.get(this.mean);
            this.std = new float[stdBuffer.limit()];
            stdBuffer.get(this.std);
            this.min = new float[minBuffer.limit()];
            minBuffer.get(this.min);
            this.max = new float[maxBuffer.limit()];
            maxBuffer.get(this.max);
        }

        public NormalizationParams(DataInput in) throws IOException {
            this.mean = DataInputOutputUtils.readFloatArray(in);
            this.std = DataInputOutputUtils.readFloatArray(in);
            this.min = DataInputOutputUtils.readFloatArray(in);
            this.max = DataInputOutputUtils.readFloatArray(in);
        }

        public void save(DataOutput out) throws IOException {
            DataInputOutputUtils.writeFloatArray(out, this.mean);
            DataInputOutputUtils.writeFloatArray(out, this.std);
            DataInputOutputUtils.writeFloatArray(out, this.min);
            DataInputOutputUtils.writeFloatArray(out, this.max);
        }

        public float[] getMean() {
            return this.mean;
        }

        public float[] getStd() {
            return this.std;
        }

        public float[] getMin() {
            return this.min;
        }

        public float[] getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NormalizationParams that = (NormalizationParams)o;
            return Arrays.equals(this.mean, that.mean) && Arrays.equals(this.std, that.std) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.mean);
            result = 31 * result + Arrays.hashCode(this.std);
            result = 31 * result + Arrays.hashCode(this.min);
            result = 31 * result + Arrays.hashCode(this.max);
            return result;
        }
    }

    public static class QuantizationParams {
        private final float scale;
        private final long zeroPoint;

        public QuantizationParams(float scale, long zeroPoint) {
            this.scale = scale;
            this.zeroPoint = zeroPoint;
        }

        public QuantizationParams(DataInput in) throws IOException {
            this.scale = in.readFloat();
            this.zeroPoint = in.readLong();
        }

        public void save(DataOutput out) throws IOException {
            out.writeFloat(this.scale);
            out.writeLong(this.zeroPoint);
        }

        public float getScale() {
            return this.scale;
        }

        public long getZeroPoint() {
            return this.zeroPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuantizationParams that = (QuantizationParams)o;
            return Float.compare(this.scale, that.scale) == 0 && this.zeroPoint == that.zeroPoint;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.scale), this.zeroPoint);
        }
    }
}

