/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.api.variant.impl.TestVariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.builder.model.CodeShrinker;
import com.android.builder.profile.Recorder;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class TestApplicationTaskManager
extends AbstractAppTaskManager<TestVariantImpl, TestVariantPropertiesImpl> {
    public TestApplicationTaskManager(List<ComponentInfo<TestVariantImpl, TestVariantPropertiesImpl>> variants, List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents, boolean hasFlavors, GlobalScope globalScope, BaseExtension extension, Recorder recorder) {
        super(variants, testComponents, hasFlavors, globalScope, extension, recorder);
    }

    @Override
    protected void doCreateTasksForVariant(ComponentInfo<TestVariantImpl, TestVariantPropertiesImpl> variant2, List<ComponentInfo<TestVariantImpl, TestVariantPropertiesImpl>> allVariants) {
        this.createCommonTasks(variant2, allVariants);
        TestVariantPropertiesImpl testVariantProperties = variant2.getProperties();
        Provider<Directory> testingApk = testVariantProperties.getArtifacts().get(InternalArtifactType.APK.INSTANCE);
        FileCollection testedApks = testVariantProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK);
        TestApplicationTestData testData = new TestApplicationTestData(testVariantProperties, testingApk, testedApks);
        this.configureTestData(testVariantProperties, testData);
        TaskProvider<DeviceProviderInstrumentTestTask> instrumentTestTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantProperties, new ConnectedDeviceProvider((Provider<RegularFile>)this.globalScope.getSdkComponents().flatMap(SdkComponentsBuildService::getAdbExecutableProvider), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), DeviceProviderInstrumentTestTask.CreationAction.Type.INTERNAL_CONNECTED_DEVICE_PROVIDER, testData){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        Task connectedAndroidTest = this.taskFactory.findByName("connectedAndroidTest");
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected void postJavacCreation(ComponentPropertiesImpl componentProperties) {
    }

    @Override
    public void createLintTasks(TestVariantPropertiesImpl variantProperties, List<ComponentInfo<TestVariantImpl, TestVariantPropertiesImpl>> allVariants) {
    }

    @Override
    public void maybeCreateLintVitalTask(TestVariantPropertiesImpl variant2, List<ComponentInfo<TestVariantImpl, TestVariantPropertiesImpl>> allVariants) {
    }

    @Override
    protected void configureGlobalLintTask() {
    }

    @Override
    protected void maybeCreateJavaCodeShrinkerTask(ComponentPropertiesImpl componentProperties) {
        CodeShrinker codeShrinker = componentProperties.getVariantScope().getCodeShrinker();
        if (codeShrinker != null) {
            this.doCreateJavaCodeShrinkerTask(componentProperties, Objects.requireNonNull(codeShrinker), true);
        } else {
            TaskProvider<CheckTestedAppObfuscation> checkObfuscation = this.taskFactory.register(new CheckTestedAppObfuscation.CreationAction(componentProperties));
            Preconditions.checkNotNull(componentProperties.getTaskContainer().getJavacTask());
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getJavacTask(), checkObfuscation);
        }
    }

    @Override
    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTasks(ApkCreationConfig creationConfig) {
        return this.taskFactory.register(new ProcessTestManifest.CreationAction((TestCreationConfig)((Object)creationConfig)));
    }

    @Override
    protected void createVariantPreBuildTask(ComponentPropertiesImpl componentProperties) {
        this.createDefaultPreBuildTask(componentProperties);
    }
}

