/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.Version;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public abstract class JacocoReportTask
extends NonIncrementalTask {
    private FileCollection jacocoClasspath;
    private FileCollection classFileCollection;
    private FileCollection sourceFolders;
    private File reportDir;
    private String reportName;
    private int tabWidth = 4;

    @Deprecated
    public void setCoverageFile(File coverageFile) {
        this.getLogger().info("JacocoReportTask.setCoverageDir is deprecated and has no effect.");
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract DirectoryProperty getCoverageDirectories();

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @Classpath
    public FileCollection getClassFileCollection() {
        return this.classFileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSourceFolders() {
        return this.sourceFolders;
    }

    @Input
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Classpath
    public FileCollection getJacocoClasspath() {
        return this.jacocoClasspath;
    }

    public void setJacocoClasspath(FileCollection jacocoClasspath) {
        this.jacocoClasspath = jacocoClasspath;
    }

    @Input
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    protected void doTaskAction() throws IOException {
        Set coverageFiles = ((Directory)this.getCoverageDirectories().get()).getAsFileTree().getFiles().stream().filter(File::isFile).collect(Collectors.toSet());
        if (coverageFiles.isEmpty()) {
            throw new IOException(String.format("No coverage data to process in directories [%1$s]", ((Directory)this.getCoverageDirectories().get()).getAsFile().getAbsolutePath()));
        }
        this.getWorkerExecutor().classLoaderIsolation(classpath -> classpath.getClasspath().from(new Object[]{this.jacocoClasspath.getFiles()})).submit(JacocoReportWorkerAction.class, params -> {
            params.getCoverageFiles().set((Iterable)coverageFiles);
            params.getReportDir().set(this.getReportDir());
            params.getClassFolders().set((Iterable)this.getClassFileCollection().getFiles());
            params.getSourceFolders().set((Iterable)this.getSourceFolders().getFiles());
            params.getTabWidth().set((Object)this.getTabWidth());
            params.getReportName().set((Object)this.getReportName());
        });
    }

    static abstract class JacocoReportWorkerAction
    implements WorkAction<JacocoWorkParameters> {
        private static final Logger logger = Logging.getLogger(JacocoReportWorkerAction.class);

        @Inject
        public JacocoReportWorkerAction() {
        }

        public void execute() {
            try {
                JacocoReportWorkerAction.generateReport((Collection)((JacocoWorkParameters)this.getParameters()).getCoverageFiles().get(), (File)((JacocoWorkParameters)this.getParameters()).getReportDir().getAsFile().get(), (Collection)((JacocoWorkParameters)this.getParameters()).getClassFolders().get(), (Collection)((JacocoWorkParameters)this.getParameters()).getSourceFolders().get(), (Integer)((JacocoWorkParameters)this.getParameters()).getTabWidth().get(), (String)((JacocoWorkParameters)this.getParameters()).getReportName().get());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to generate Jacoco report", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        static void generateReport(Collection<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) throws IOException {
            ExecFileLoader loader = new ExecFileLoader();
            for (File coverageFile : coverageFiles) {
                loader.load(coverageFile);
            }
            SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
            ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding("UTF-8");
            htmlFormatter.setLocale(Locale.US);
            htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
            FileMultiReportOutput output2 = new FileMultiReportOutput(reportDir);
            IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output2);
            XMLFormatter xmlFormatter = new XMLFormatter();
            xmlFormatter.setOutputEncoding("UTF-8");
            OutputStream xmlReportOutput = output2.createFile("report.xml");
            try {
                IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
                MultiReportVisitor visitor2 = new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
                visitor2.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
                CoverageBuilder builder = new CoverageBuilder();
                Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
                JacocoReportWorkerAction.analyzeAll(analyzer, classFolders);
                MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
                for (File folder : sourceFolders) {
                    locator.add((ISourceFileLocator)new DirectorySourceFileLocator(folder, "UTF-8", tabWidth));
                }
                IBundleCoverage bundle = builder.getBundle(reportName);
                visitor2.visitBundle(bundle, (ISourceFileLocator)locator);
                visitor2.visitEnd();
            }
            finally {
                try {
                    xmlReportOutput.close();
                }
                catch (IOException e) {
                    logger.error("Could not close xml report file", (Throwable)e);
                }
            }
        }

        private static void analyzeAll(Analyzer analyzer, Collection<File> classFolders) throws IOException {
            for (File folder : classFolders) {
                JacocoReportWorkerAction.analyze(analyzer, folder, classFolders);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void analyze(Analyzer analyzer, File file, Collection<File> originalClassFolders) throws IOException {
            block6: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    File[] files2 = file.listFiles();
                    if (files2 == null) break block6;
                    for (File f : files2) {
                        if (originalClassFolders.contains(f)) continue;
                        JacocoReportWorkerAction.analyze(analyzer, f, originalClassFolders);
                    }
                    break block6;
                }
                String name2 = file.getName();
                if (!name2.endsWith(".class") || name2.equals("R.class") || name2.startsWith("R$") || name2.equals("Manifest.class") || name2.startsWith("Manifest$") || name2.equals("BuildConfig.class")) {
                    return;
                }
                FileInputStream in = new FileInputStream(file);
                try {
                    analyzer.analyzeClass((InputStream)in, file.getAbsolutePath());
                }
                finally {
                    Closeables.closeQuietly((InputStream)in);
                }
            }
        }
    }

    static interface JacocoWorkParameters
    extends WorkParameters {
        public SetProperty<File> getCoverageFiles();

        public DirectoryProperty getReportDir();

        public SetProperty<File> getClassFolders();

        public SetProperty<File> getSourceFolders();

        public Property<Integer> getTabWidth();

        public Property<String> getReportName();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoReportTask, TestComponentPropertiesImpl> {
        private final Configuration jacocoAntConfiguration;

        public CreationAction(TestComponentPropertiesImpl testComponentProperties, Configuration jacocoAntConfiguration) {
            super(testComponentProperties);
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        public String getName() {
            return this.computeTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<JacocoReportTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((TestComponentPropertiesImpl)this.creationConfig).getTaskContainer().setCoverageReportTask(taskProvider);
        }

        @Override
        public void configure(JacocoReportTask task) {
            super.configure(task);
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(((TestComponentPropertiesImpl)this.creationConfig).getName());
            VariantPropertiesImpl testedVariant = ((TestComponentPropertiesImpl)this.creationConfig).getTestedVariant();
            task.jacocoClasspath = (FileCollection)this.jacocoAntConfiguration;
            ((TestComponentPropertiesImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.CODE_COVERAGE.INSTANCE, task.getCoverageDirectories());
            task.classFileCollection = testedVariant.getArtifacts().getAllClasses();
            Object[] objectArray = new Object[1];
            objectArray[0] = testedVariant::getJavaSources;
            task.sourceFolders = (FileCollection)((TestComponentPropertiesImpl)this.creationConfig).getServices().fileCollection(objectArray);
            task.setReportDir(testedVariant.getPaths().getCoverageReportDir());
        }
    }
}

