/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarTransformUtil;
import com.android.build.gradle.internal.dependency.LibraryDependencySourcesTransformKt;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.utils.XmlUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a8\u0006\r"}, d2={"getClassesFromExplodedAar", "", "", "explodedAar", "Ljava/io/File;", "getClassesInJar", "jarFile", "Ljava/nio/file/Path;", "getResourcesFromExplodedAarToFile", "writePathsToFile", "outputFile", "paths", "", "gradle"})
public final class LibraryDependencySourcesTransformKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getResourcesFromExplodedAarToFile(@NotNull File explodedAar) {
        void $this$mapTo$iv$iv;
        Object document;
        File resourceDir;
        block9: {
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)explodedAar, (String)"explodedAar");
                resourceDir = FilesKt.resolve((File)explodedAar, (String)"res");
                if (resourceDir.list() == null) break block8;
                Object[] objectArray = resourceDir.listFiles();
                if (objectArray == null) {
                    Intrinsics.throwNpe();
                }
                if (!ArraysKt.none((Object[])objectArray)) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ResourceUsageModel resourceUsageModel = new ResourceUsageModel();
        Sequence $this$forEach$iv = SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)resourceDir)), (Function1)getResourcesFromExplodedAarToFile.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
            ResourceFolderType resFolderType = ResourceFolderType.getTypeByName((String)file2.getName());
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                String string2 = FilesKt.readText((File)file, (Charset)charset);
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String resourceString = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                document = XmlUtils.parseDocument((String)resourceString, (boolean)false);
                resourceUsageModel.visitXmlDocument(file, resFolderType, (Document)document);
                continue;
            }
            resourceUsageModel.visitBinaryResource(resFolderType, file);
        }
        List list = resourceUsageModel.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"resourceUsageModel.resources");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            document = (ResourceUsageModel.Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getClassesFromExplodedAar(@NotNull File explodedAar) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)explodedAar, (String)"explodedAar");
        List<File> list = AarTransformUtil.getJars(explodedAar);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"AarTransformUtil.getJars(explodedAar)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
            Iterable list$iv$iv = LibraryDependencySourcesTransformKt.getClassesInJar(path);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<String> getClassesInJar(@NotNull Path jarFile) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        boolean bl = false;
        List classes2 = new ArrayList();
        File file = jarFile.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarFile.toFile()");
        Object object = file;
        boolean bl2 = false;
        FileInputStream fileInputStream = new FileInputStream((File)object);
        InputStream inputStream = fileInputStream;
        object = new ZipInputStream(inputStream);
        bl2 = false;
        Throwable throwable = null;
        try {
            ZipInputStream zipEntry = (ZipInputStream)object;
            boolean bl3 = false;
            while (zipEntry.getNextEntry() != null) {
                ZipEntry entry;
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                String string2 = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                classes2.add(string2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return classes2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File writePathsToFile(@NotNull File outputFile, @NotNull Collection<String> paths) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        if (!outputFile.exists()) {
            Files.createFile(outputFile.toPath(), new FileAttribute[0]);
        }
        Object object = outputFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl5 = false;
            Iterable $this$forEach$iv = paths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String classPath = (String)element$iv;
                boolean bl6 = false;
                writer.append(classPath);
                writer.newLine();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return outputFile;
    }
}

