/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.incremental.CapturingChangesApkCreator;
import com.android.build.gradle.internal.incremental.FolderBasedApkCreator;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public class IncrementalPackagerBuilder {
    private static int NO_V1_SDK = 24;
    private ApkCreatorFactory.CreationData.Builder creationDataBuilder = ApkCreatorFactory.CreationData.builder();
    private ApkFormat apkFormat;
    private NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
    private Predicate<String> noCompressPredicate;
    private File intermediateDir;
    private boolean debuggableBuild;
    private boolean jniDebuggableBuild;
    private Set<String> abiFilters;
    private File manifestFile;
    private boolean isManifestFileRequired;
    private Collection<String> aaptOptionsNoCompress;
    private BuildType buildType;
    private ApkCreatorType apkCreatorType = ApkCreatorType.APK_Z_FILE_CREATOR;
    private Map<RelativeFile, FileStatus> changedDexFiles = new HashMap<RelativeFile, FileStatus>();
    private Map<RelativeFile, FileStatus> changedJavaResources = new HashMap<RelativeFile, FileStatus>();
    private List<SerializableChange> changedAssets = new ArrayList<SerializableChange>();
    private Map<RelativeFile, FileStatus> changedAndroidResources = new HashMap<RelativeFile, FileStatus>();
    private Map<RelativeFile, FileStatus> changedNativeLibs = new HashMap<RelativeFile, FileStatus>();

    public IncrementalPackagerBuilder(ApkFormat apkFormat, BuildType buildType) {
        this.abiFilters = new HashSet<String>();
        this.apkFormat = apkFormat;
        this.buildType = buildType;
        this.creationDataBuilder.setIncremental(buildType == BuildType.INCREMENTAL);
    }

    public IncrementalPackagerBuilder(ApkFormat apkFormat) {
        this(apkFormat, BuildType.UNKNOWN);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfigData signingConfig) {
        return this.withSigning(signingConfig, 1);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfigData signingConfig, int minSdk) {
        return this.withSigning(signingConfig, minSdk, null, null);
    }

    @VisibleForTesting
    static boolean enableV1Signing(boolean v1Enabled, boolean v1Configured, int minSdk, Integer targetApi) {
        if (!v1Enabled) {
            return false;
        }
        return v1Configured || (targetApi == null || targetApi < NO_V1_SDK) && minSdk < NO_V1_SDK;
    }

    @VisibleForTesting
    static boolean enableV2Signing(boolean v2Enabled, boolean v2Configured, Integer targetApi) {
        if (!v2Enabled) {
            return false;
        }
        return v2Configured || targetApi == null || targetApi >= NO_V1_SDK;
    }

    public IncrementalPackagerBuilder withSigning(SigningConfigData signingConfig, int minSdk, Integer targetApi, byte[] sdkDependencyData) {
        if (signingConfig == null) {
            return this;
        }
        try {
            String error2 = "SigningConfig \"" + signingConfig.getName() + "\" is missing required property \"%s\".";
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile(), (String)error2, (Object)"storeFile")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword(), (String)error2, (Object)"storePassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword(), (String)error2, (Object)"keyPassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias(), (String)error2, (Object)"keyAlias")));
            boolean enableV1Signing = IncrementalPackagerBuilder.enableV1Signing(signingConfig.getV1SigningEnabled(), signingConfig.getV1SigningConfigured(), minSdk, targetApi);
            boolean enableV2Signing = IncrementalPackagerBuilder.enableV2Signing(signingConfig.getV2SigningEnabled(), signingConfig.getV2SigningConfigured(), targetApi);
            this.creationDataBuilder.setSigningOptions(SigningOptions.builder().setKey(certificateInfo.getKey()).setCertificates(new X509Certificate[]{certificateInfo.getCertificate()}).setV1SigningEnabled(enableV1Signing).setV2SigningEnabled(enableV2Signing).setMinSdkVersion(minSdk).setValidation(this.computeValidation()).setSdkDependencyData(sdkDependencyData).setExecutor(provider2 -> {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                try {
                    int jobCount = forkJoinPool.getParallelism();
                    ArrayList<Future> jobs = new ArrayList<Future>(jobCount);
                    for (int i2 = 0; i2 < jobCount; ++i2) {
                        jobs.add(forkJoinPool.submit(provider2.createRunnable()));
                    }
                    for (Future future : jobs) {
                        future.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).build());
        }
        catch (KeytoolException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private SigningOptions.Validation computeValidation() {
        switch (this.buildType) {
            case INCREMENTAL: {
                return SigningOptions.Validation.ASSUME_VALID;
            }
            case CLEAN: {
                return SigningOptions.Validation.ASSUME_INVALID;
            }
            case UNKNOWN: {
                return SigningOptions.Validation.ALWAYS_VALIDATE;
            }
        }
        throw new RuntimeException("Unknown IncrementalPackagerBuilder build type " + (Object)((Object)this.buildType));
    }

    public IncrementalPackagerBuilder withOutputFile(File f) {
        this.creationDataBuilder.setApkPath(f);
        return this;
    }

    public IncrementalPackagerBuilder withNativeLibraryPackagingMode(NativeLibrariesPackagingMode packagingMode) {
        this.nativeLibrariesPackagingMode = packagingMode;
        return this;
    }

    public IncrementalPackagerBuilder withManifest(File manifest, boolean isManifestFileRequired) {
        this.manifestFile = manifest;
        this.isManifestFileRequired = isManifestFileRequired;
        return this;
    }

    public IncrementalPackagerBuilder withNoCompressPredicate(Predicate<String> noCompressPredicate) {
        this.noCompressPredicate = noCompressPredicate;
        return this;
    }

    public IncrementalPackagerBuilder withAaptOptionsNoCompress(Collection<String> aaptOptionsNoCompress) {
        this.aaptOptionsNoCompress = aaptOptionsNoCompress;
        return this;
    }

    public IncrementalPackagerBuilder withIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
        return this;
    }

    public IncrementalPackagerBuilder withCreatedBy(String createdBy) {
        this.creationDataBuilder.setCreatedBy(createdBy);
        return this;
    }

    public IncrementalPackagerBuilder withDebuggableBuild(boolean debuggableBuild) {
        this.debuggableBuild = debuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withJniDebuggableBuild(boolean jniDebuggableBuild) {
        this.jniDebuggableBuild = jniDebuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withAcceptedAbis(Set<String> acceptedAbis) {
        this.abiFilters = ImmutableSet.copyOf(acceptedAbis);
        return this;
    }

    public IncrementalPackagerBuilder withApkCreatorType(ApkCreatorType apkCreatorType) {
        this.apkCreatorType = apkCreatorType;
        return this;
    }

    public IncrementalPackagerBuilder withChangedDexFiles(Map<RelativeFile, FileStatus> changedDexFiles) {
        this.changedDexFiles = ImmutableMap.copyOf(changedDexFiles);
        return this;
    }

    public IncrementalPackagerBuilder withChangedJavaResources(Map<RelativeFile, FileStatus> changedJavaResources) {
        this.changedJavaResources = ImmutableMap.copyOf(changedJavaResources);
        return this;
    }

    public IncrementalPackagerBuilder withChangedAssets(Collection<SerializableChange> changedAssets) {
        this.changedAssets = ImmutableList.copyOf(changedAssets);
        return this;
    }

    public IncrementalPackagerBuilder withChangedAndroidResources(Map<RelativeFile, FileStatus> changedAndroidResources) {
        this.changedAndroidResources = ImmutableMap.copyOf(changedAndroidResources);
        return this;
    }

    public IncrementalPackagerBuilder withChangedNativeLibs(Map<RelativeFile, FileStatus> changedNativeLibs) {
        this.changedNativeLibs = ImmutableMap.copyOf(changedNativeLibs);
        return this;
    }

    public IncrementalPackager build() {
        DefaultManifestParser manifest;
        Preconditions.checkState((this.intermediateDir != null ? 1 : 0) != 0, (Object)"intermediateDir == null");
        DefaultManifestParser defaultManifestParser = manifest = this.manifestFile != null ? new DefaultManifestParser(this.manifestFile, () -> true, this.isManifestFileRequired, null) : null;
        if (this.noCompressPredicate == null) {
            this.noCompressPredicate = manifest != null ? PackagingUtils.getNoCompressPredicate(this.aaptOptionsNoCompress, (ManifestAttributeSupplier)manifest) : path -> false;
        }
        if (this.nativeLibrariesPackagingMode == null) {
            this.nativeLibrariesPackagingMode = manifest != null ? PackagingUtils.getNativeLibrariesLibrariesPackagingMode((ManifestAttributeSupplier)manifest) : NativeLibrariesPackagingMode.COMPRESSED;
        }
        this.creationDataBuilder.setNativeLibrariesPackagingMode(this.nativeLibrariesPackagingMode).setNoCompressPredicate(this.noCompressPredicate::test);
        try {
            return new IncrementalPackager(this.creationDataBuilder.build(), this.intermediateDir, this.apkFormat.factory(this.debuggableBuild), ApkFormat.FILE.name().equals(this.apkFormat.name()), this.abiFilters, this.jniDebuggableBuild, this.debuggableBuild, this.apkCreatorType, this.changedDexFiles, this.changedJavaResources, this.changedAssets, this.changedAndroidResources, this.changedNativeLibs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum BuildType {
        UNKNOWN,
        CLEAN,
        INCREMENTAL;

    }

    public static enum ApkFormat {
        FILE{

            @Override
            ApkCreatorFactory factory(boolean debuggableBuild) {
                return ApkCreatorFactories.fromProjectProperties(debuggableBuild);
            }
        }
        ,
        FILE_WITH_LIST_OF_CHANGES{

            @Override
            ApkCreatorFactory factory(boolean debuggableBuild) {
                ApkCreatorFactory apk = ApkCreatorFactories.fromProjectProperties(debuggableBuild);
                return creationData -> new CapturingChangesApkCreator(creationData, apk.make(creationData));
            }
        }
        ,
        DIRECTORY{

            @Override
            ApkCreatorFactory factory(boolean debuggableBuild) {
                return creationData -> new CapturingChangesApkCreator(creationData, new FolderBasedApkCreator(creationData));
            }
        };


        abstract ApkCreatorFactory factory(boolean var1);
    }
}

