/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModelKt;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxMetadataGenerator;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.DetermineUsedStlResult;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidAbiMetadata;
import com.android.build.gradle.internal.tasks.JsonSerializer;
import com.android.build.gradle.internal.tasks.ModuleMetadataV1;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageMetadataV1;
import com.android.build.gradle.internal.tasks.PrefabAbiData;
import com.android.build.gradle.internal.tasks.PrefabModuleTaskData;
import com.android.build.gradle.internal.tasks.PrefabPackageTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0006H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020!H\u0002J&\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0007H\u0002J\b\u0010-\u001a\u00020#H\u0014J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!H\u0002J\u0018\u00101\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0007H\u0002J&\u00102\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u0010+\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00158G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00158G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/tasks/PrefabPackageTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "configurationModel", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "jsonFiles", "", "Ljava/io/File;", "getJsonFiles", "()Ljava/util/List;", "<set-?>", "Lcom/android/build/gradle/internal/tasks/PrefabModuleTaskData;", "modules", "getModules", "ndkAbiFilters", "Lcom/android/build/gradle/internal/core/Abi;", "getNdkAbiFilters", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "", "packageName", "getPackageName", "()Ljava/lang/String;", "packageVersion", "getPackageVersion", "sdkComponents", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkComponents", "()Lorg/gradle/api/provider/Property;", "createAbiData", "Lcom/android/build/gradle/internal/tasks/PrefabAbiData;", "createLibraryMetadata", "", "libDir", "abi", "createModule", "module", "abis", "packageDir", "createModuleMetadata", "installDir", "createPackageMetadata", "doTaskAction", "findLibraryForAbi", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "moduleName", "installHeaders", "installLibs", "CreationAction", "gradle-core"})
public abstract class PrefabPackageTask
extends NonIncrementalTask {
    private CxxConfigurationModel configurationModel;
    private String packageName;
    private String packageVersion;
    private List<PrefabModuleTaskData> modules;

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkComponents();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        return string;
    }

    @Input
    @NotNull
    public final String getPackageVersion() {
        String string = this.packageVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        return string;
    }

    @Nested
    @NotNull
    public final List<PrefabModuleTaskData> getModules() {
        List<PrefabModuleTaskData> list = this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final List<File> getJsonFiles() {
        void $this$mapTo$iv$iv;
        CxxConfigurationModel cxxConfigurationModel = this.configurationModel;
        if (cxxConfigurationModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
        }
        Iterable $this$map$iv = cxxConfigurationModel.getActiveAbis();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CxxAbiModel cxxAbiModel = (CxxAbiModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = CxxAbiModelKt.getJsonFile((CxxAbiModel)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    @Input
    @NotNull
    public final List<Abi> getNdkAbiFilters() {
        CxxConfigurationModel cxxConfigurationModel = this.configurationModel;
        if (cxxConfigurationModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
        }
        return cxxConfigurationModel.getVariant().getValidAbiList();
    }

    @Override
    protected void doTaskAction() {
        File installDir;
        Object object = this.getOutputDirectory().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.get()");
        File file = ((Directory)object).getAsFile();
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        File file2 = installDir = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"installDir");
        this.createPackageMetadata(file2);
        List<PrefabAbiData> abis = this.createAbiData();
        List<PrefabModuleTaskData> list = this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        for (PrefabModuleTaskData module : list) {
            this.createModule(module, abis, installDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PrefabAbiData> createAbiData() {
        void $this$mapTo$iv$iv;
        CxxConfigurationModel cxxConfigurationModel = this.configurationModel;
        if (cxxConfigurationModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
        }
        Object object = this.getAnalyticsService().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"analyticsService.get()");
        CxxMetadataGenerator generator = CxxConfigurationModelKt.createCxxMetadataGenerator(cxxConfigurationModel, (AnalyticsService)object);
        CxxVariantModel variantModel = generator.getVariant();
        List<CxxAbiModel> abiModels = generator.getAbis();
        DetermineUsedStlResult result2 = CxxVariantModelKt.determineUsedStl(variantModel);
        if (!(result2 instanceof DetermineUsedStlResult.Success)) {
            if (result2 instanceof DetermineUsedStlResult.Failure) {
                LoggingEnvironmentKt.errorln(((DetermineUsedStlResult.Failure)result2).getError(), new Object[0]);
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            throw new NoWhenBranchMatchedException();
        }
        Stl stl = ((DetermineUsedStlResult.Success)result2).getStl();
        Iterable $this$map$iv = abiModels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            void it;
            CxxAbiModel cxxAbiModel = (CxxAbiModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int ndkVersion = it.getVariant().getModule().getNdkVersion().getMajor();
            NdkMetaPlatforms metaPlatforms = it.getVariant().getModule().getNdkMetaPlatforms();
            if (it.getAbi().supports64Bits()) {
                AndroidVersion androidVersion = AndroidVersion.SUPPORTS_64_BIT;
                Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"AndroidVersion.SUPPORTS_64_BIT");
                n = androidVersion.getApiLevel();
            } else {
                n = 1;
            }
            int minVersionForAbi = n;
            int minVersionForNdk = metaPlatforms != null ? metaPlatforms.getMin() : (ndkVersion < 12 ? 1 : (ndkVersion < 15 ? 9 : (ndkVersion < 18 ? 14 : 16)));
            int n2 = it.getAbiPlatformVersion();
            int n3 = 0;
            n3 = Math.max(minVersionForAbi, minVersionForNdk);
            boolean bl2 = false;
            PrefabAbiData prefabAbiData = new PrefabAbiData(it.getAbi(), Math.max(n2, n3), ndkVersion, stl.getArgumentName(), CxxAbiModelKt.getJsonFile((CxxAbiModel)it));
            collection.add(prefabAbiData);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPackageMetadata(File installDir) {
        String string;
        void it;
        File file = FilesKt.resolve((File)installDir, (String)"prefab.json");
        JsonSerializer jsonSerializer = new JsonSerializer();
        String string2 = this.packageName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        String string3 = this.packageVersion;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        Object object = string3;
        boolean bl = false;
        boolean bl2 = false;
        String string4 = object;
        int n = 1;
        String string5 = string2;
        JsonSerializer jsonSerializer2 = jsonSerializer;
        File file2 = file;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)it, (Object)"unspecified") ^ true;
        Object object2 = bl4 ? object : null;
        object = CollectionsKt.emptyList();
        String string6 = string = object2;
        Object object3 = object;
        int n2 = n;
        String string7 = string5;
        FilesKt.writeText$default((File)file2, (String)jsonSerializer2.toJson(new PackageMetadataV1(string7, n2, (List<String>)object3, string6)), null, (int)2, null);
    }

    private final void createModule(PrefabModuleTaskData module, List<PrefabAbiData> abis, File packageDir) {
        File file = FilesKt.resolve((File)packageDir, (String)("modules/" + module.getName()));
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        File installDir = file;
        this.createModuleMetadata(module, installDir);
        this.installHeaders(module, installDir);
        this.installLibs(module, abis, installDir);
    }

    private final void createModuleMetadata(PrefabModuleTaskData module, File installDir) {
        FilesKt.writeText$default((File)FilesKt.resolve((File)installDir, (String)"module.json"), (String)new JsonSerializer().toJson(new ModuleMetadataV1(CollectionsKt.emptyList(), module.getLibraryName(), null, 4, null)), null, (int)2, null);
    }

    private final void installHeaders(PrefabModuleTaskData module, File installDir) {
        block0: {
            File file = FilesKt.resolve((File)installDir, (String)"include");
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            FilesKt.deleteRecursively((File)$this$apply);
            File includeDir = file;
            File file2 = module.getHeaders();
            if (file2 == null) break block0;
            file = file2;
            bl = false;
            bl2 = false;
            File it = file;
            boolean bl4 = false;
            FilesKt.copyRecursively$default((File)it, (File)includeDir, (boolean)false, null, (int)6, null);
            LoggingEnvironmentKt.infoln("Installing " + it + " to " + includeDir, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final NativeLibraryValueMini findLibraryForAbi(String moduleName, PrefabAbiData abi) {
        void $this$filterKeys$iv;
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi.getNativeBuildJson(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeBuildConfigValueMini, (String)"AndroidBuildGradleJsons.\u2026bi.nativeBuildJson, null)");
        NativeBuildConfigValueMini config2 = nativeBuildConfigValueMini;
        Map<String, NativeLibraryValueMini> map2 = config2.libraries;
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"config\n                .libraries");
        Map<String, NativeLibraryValueMini> map3 = map2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        void var8_7 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : var8_7.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (!(StringsKt.startsWith$default((String)string, (String)(moduleName + '-'), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)(moduleName + "::"), (boolean)false, (int)2, null))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Collection matchingLibs = ((Map)result$iv).values();
        if (matchingLibs.isEmpty()) {
            LoggingEnvironmentKt.errorln("No libraries found for " + moduleName, new Object[0]);
        }
        Object object = CollectionsKt.single((Iterable)matchingLibs);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"matchingLibs.single()");
        return (NativeLibraryValueMini)object;
    }

    private final void installLibs(PrefabModuleTaskData module, List<PrefabAbiData> abis, File installDir) {
        File file = FilesKt.resolve((File)installDir, (String)"libs");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        FilesKt.deleteRecursively((File)$this$apply);
        File libsDir = file;
        for (PrefabAbiData abiData : abis) {
            File srcLibrary = this.findLibraryForAbi((String)module.getName(), (PrefabAbiData)abiData).output;
            if (srcLibrary != null) {
                File libDir = FilesKt.resolve((File)libsDir, (String)("android." + abiData.getAbi().getTag()));
                String string = srcLibrary.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"srcLibrary.name");
                File dest = FilesKt.resolve((File)libDir, (String)string);
                LoggingEnvironmentKt.infoln("Installing " + srcLibrary + " to " + dest, new Object[0]);
                FilesKt.copyTo$default((File)srcLibrary, (File)dest, (boolean)false, (int)0, (int)6, null);
                this.createLibraryMetadata(libDir, abiData);
                continue;
            }
            LoggingEnvironmentKt.warnln(module.getName() + "} has no library output", new Object[0]);
        }
    }

    private final void createLibraryMetadata(File libDir, PrefabAbiData abi) {
        File file = FilesKt.resolve((File)libDir, (String)"abi.json");
        JsonSerializer jsonSerializer = new JsonSerializer();
        String string = abi.getAbi().getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.abi.tag");
        FilesKt.writeText$default((File)file, (String)jsonSerializer.toJson(new AndroidAbiMetadata(string, abi.getMinSdkVersion(), abi.getNdkMajorVersion(), abi.getStl())), null, (int)2, null);
    }

    public static final /* synthetic */ String access$getPackageName$p(PrefabPackageTask $this) {
        String string = $this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        return string;
    }

    public static final /* synthetic */ String access$getPackageVersion$p(PrefabPackageTask $this) {
        String string = $this.packageVersion;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageVersion");
        }
        return string;
    }

    public static final /* synthetic */ List access$getModules$p(PrefabPackageTask $this) {
        List<PrefabModuleTaskData> list = $this.modules;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        return list;
    }

    public static final /* synthetic */ CxxConfigurationModel access$getConfigurationModel$p(PrefabPackageTask $this) {
        CxxConfigurationModel cxxConfigurationModel = $this.configurationModel;
        if (cxxConfigurationModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
        }
        return cxxConfigurationModel;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/tasks/PrefabPackageTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PrefabPackageTask;", "Lcom/android/build/api/variant/impl/LibraryVariantImpl;", "modules", "", "Lcom/android/build/gradle/internal/tasks/PrefabModuleTaskData;", "sdkComponentsBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "config", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "componentProperties", "(Ljava/util/List;Lcom/android/build/gradle/internal/SdkComponentsBuildService;Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;Lcom/android/build/api/variant/impl/LibraryVariantImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PrefabPackageTask, LibraryVariantImpl> {
        private final List<PrefabModuleTaskData> modules;
        private final SdkComponentsBuildService sdkComponentsBuildService;
        private final CxxConfigurationModel config;

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("prefab", "Package");
        }

        @Override
        @NotNull
        public Class<PrefabPackageTask> getType() {
            return PrefabPackageTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PrefabPackageTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((LibraryVariantImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)PrefabPackageTask$CreationAction$handleProvider$1.INSTANCE).withName("prefab").on(InternalArtifactType.PREFAB_PACKAGE.INSTANCE);
        }

        @Override
        public void configure(@NotNull PrefabPackageTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Creates a Prefab package for inclusion in an AAR");
            Project project = ((LibraryVariantImpl)this.creationConfig).getGlobalScope().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"creationConfig.globalScope.project");
            Project project2 = project;
            String string = project2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            task.packageName = string;
            task.packageVersion = project2.getVersion().toString();
            task.modules = this.modules;
            task.configurationModel = this.config;
            Property<SdkComponentsBuildService> property = task.getSdkComponents();
            BuildServiceRegistry buildServiceRegistry$iv = ((LibraryVariantImpl)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        }

        public CreationAction(@NotNull List<PrefabModuleTaskData> modules, @NotNull SdkComponentsBuildService sdkComponentsBuildService, @NotNull CxxConfigurationModel config2, @NotNull LibraryVariantImpl componentProperties) {
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            Intrinsics.checkParameterIsNotNull((Object)sdkComponentsBuildService, (String)"sdkComponentsBuildService");
            Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)componentProperties, (String)"componentProperties");
            super((ComponentCreationConfig)componentProperties);
            this.modules = modules;
            this.sdkComponentsBuildService = sdkComponentsBuildService;
            this.config = config2;
        }
    }
}

