/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestBuilderImpl;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.UnitTestBuilderImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantOutputConfigurationImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.services.BaseServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.Project;

public abstract class BaseVariantFactory<VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
implements VariantFactory<VariantBuilderT, VariantT> {
    private static final String ANDROID_APT_PLUGIN_NAME = "com.neenbedankt.android-apt";
    protected final ProjectServices projectServices;
    protected final GlobalScope globalScope;
    @Deprecated
    private final BaseServices servicesForOldVariantObjectsOnly;

    public BaseVariantFactory(ProjectServices projectServices, GlobalScope globalScope) {
        this.projectServices = projectServices;
        this.globalScope = globalScope;
        this.servicesForOldVariantObjectsOnly = new BaseServicesImpl(projectServices);
    }

    @Override
    public UnitTestBuilderImpl createUnitTestBuilder(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (UnitTestBuilderImpl)this.projectServices.getObjectFactory().newInstance(UnitTestBuilderImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public AndroidTestBuilderImpl createAndroidTestBuilder(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (AndroidTestBuilderImpl)this.projectServices.getObjectFactory().newInstance(AndroidTestBuilderImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public UnitTestImpl createUnitTest(UnitTestBuilderImpl unitTestBuilder, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        UnitTestImpl unitTestProperties = (UnitTestImpl)this.projectServices.getObjectFactory().newInstance(UnitTestImpl.class, new Object[]{unitTestBuilder, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariant, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        unitTestProperties.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfiguration>)ImmutableList.of()), null);
        return unitTestProperties;
    }

    @Override
    public AndroidTestImpl createAndroidTest(AndroidTestBuilderImpl androidTestBuilder, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        AndroidTestImpl androidTestProperties = (AndroidTestImpl)this.projectServices.getObjectFactory().newInstance(AndroidTestImpl.class, new Object[]{androidTestBuilder, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariant, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        androidTestProperties.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfiguration>)ImmutableList.of()), null);
        return androidTestProperties;
    }

    @Override
    public BaseVariantImpl createVariantApi(GlobalScope globalScope, ComponentImpl component2, BaseVariantData variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        Class<BaseVariantImpl> implementationClass = this.getVariantImplementationClass();
        return (BaseVariantImpl)this.projectServices.getObjectFactory().newInstance(implementationClass, new Object[]{variantData, component2, this.servicesForOldVariantObjectsOnly, readOnlyObjectProvider, globalScope.getProject().container(VariantOutput.class)});
    }

    @Override
    @Deprecated
    public BaseServices getServicesForOldVariantObjectsOnly() {
        return this.servicesForOldVariantObjectsOnly;
    }

    @Override
    public void preVariantWork(Project project) {
        if (project.getPluginManager().hasPlugin(ANDROID_APT_PLUGIN_NAME)) {
            this.projectServices.getIssueReporter().reportError(IssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
    }

    @Override
    public void validateModel(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        this.validateBuildConfig(model);
        this.validateResValues(model);
    }

    void validateBuildConfig(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        Boolean buildConfig = this.globalScope.getExtension().getBuildFeatures().getBuildConfig();
        if (buildConfig == null) {
            buildConfig = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_BUILDCONFIG);
        }
        if (!buildConfig.booleanValue()) {
            SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
            if (!model.getDefaultConfigData().getDefaultConfig().getBuildConfigFields().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }

    void validateResValues(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        Boolean resValues2 = this.globalScope.getExtension().getBuildFeatures().getResValues();
        if (resValues2 == null) {
            resValues2 = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_RESVALUES);
        }
        if (!resValues2.booleanValue()) {
            SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
            if (!model.getDefaultConfigData().getDefaultConfig().getResValues().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom resource values, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom resource values, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom resource values, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }
}

