/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "resourcesManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "state", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "createAnalyticsService", "", "project", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "instantiateAnalyticsService", "recordBlock", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "RegistrationAction", "State", "gradle-core"})
public abstract class AnalyticsConfiguratorService
implements BuildService<BuildServiceParameters.None> {
    private final AnalyticsResourceManager resourcesManager;
    private State state;

    @NotNull
    public final GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            String string = "Accessing GradleBuildProject.Builder through AnalyticsConfiguratorService is not allowed after AnalyticsService is created.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.resourcesManager.getProjectBuilder(projectPath);
    }

    @NotNull
    public final GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            String string = "Accessing GradleBuildVariant.Builder through AnalyticsConfiguratorService is not allowed after AnalyticsService is created.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.resourcesManager.getVariantBuilder(projectPath, variantName);
    }

    public final void recordBlock(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)executionType, (String)"executionType");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.resourcesManager.recordBlockAtConfiguration(executionType, projectPath, variant, block);
    }

    public final synchronized void createAnalyticsService(@NotNull Project project, @NotNull BuildEventsListenerRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        if (this.state == State.CALLBACK_REGISTERED) {
            return;
        }
        this.state = State.CALLBACK_REGISTERED;
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        BuildServiceRegistry buildServiceRegistry = gradle.getSharedServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"project.gradle\n            .sharedServices");
        Object object = buildServiceRegistry.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<com.android.build.gradle.internal.profile.AnalyticsService, com.android.build.gradle.internal.profile.AnalyticsService.Params>");
        }
        BuildServiceRegistration serviceRegistration = (BuildServiceRegistration)object;
        Gradle rootBuild = project.getGradle();
        while (true) {
            Gradle gradle2 = rootBuild;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle2, (String)"rootBuild");
            if (gradle2.getParent() == null) break;
            if (rootBuild.getParent() != null) continue;
            Intrinsics.throwNpe();
        }
        StartParameter startParameter = rootBuild.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"rootBuild.startParameter");
        if (startParameter.getTaskNames().isEmpty()) {
            project.getGradle().projectsEvaluated((Action)new Action<Gradle>(this, project, serviceRegistration){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildServiceRegistration $serviceRegistration;

                public final void execute(Gradle it) {
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsResourceManager analyticsResourceManager = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    BuildServiceParameters buildServiceParameters = this.$serviceRegistration.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceParameters, (String)"serviceRegistration.parameters");
                    analyticsResourceManager.configureAnalyticsService((AnalyticsService.Params)buildServiceParameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                }
                {
                    this.this$0 = analyticsConfiguratorService;
                    this.$project = project;
                    this.$serviceRegistration = buildServiceRegistration;
                }
            });
        } else {
            Gradle gradle3 = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"project.gradle");
            gradle3.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(this, project, serviceRegistration, registry){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildServiceRegistration $serviceRegistration;
                final /* synthetic */ BuildEventsListenerRegistry $registry;

                public final void execute(TaskExecutionGraph it) {
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsResourceManager analyticsResourceManager = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    TaskExecutionGraph taskExecutionGraph = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)taskExecutionGraph, (String)"it");
                    analyticsResourceManager.collectTaskMetadata(taskExecutionGraph);
                    AnalyticsResourceManager analyticsResourceManager2 = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    BuildServiceParameters buildServiceParameters = this.$serviceRegistration.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceParameters, (String)"serviceRegistration.parameters");
                    analyticsResourceManager2.configureAnalyticsService((AnalyticsService.Params)buildServiceParameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                    Gradle gradle = this.$project.getGradle();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
                    BuildServiceRegistry buildServiceRegistry = gradle.getSharedServices();
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
                    BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
                    boolean $i$f$getBuildService = false;
                    Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
                    }
                    Provider provider2 = ((BuildServiceRegistration)object).getService();
                    Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
                    this.$registry.onTaskCompletion(provider2);
                }
                {
                    this.this$0 = analyticsConfiguratorService;
                    this.$project = project;
                    this.$serviceRegistration = buildServiceRegistration;
                    this.$registry = buildEventsListenerRegistry;
                }
            });
        }
    }

    private final void instantiateAnalyticsService(Project project) {
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            return;
        }
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        BuildServiceRegistry buildServiceRegistry = gradle.getSharedServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
        Provider analyticsService = provider2;
        ((AnalyticsService)analyticsService.get()).setInitialMemorySampleForConfiguration(this.resourcesManager.getInitialMemorySample());
        ((AnalyticsService)analyticsService.get()).setConfigurationSpans(this.resourcesManager.getConfigurationSpans());
        this.state = State.ANALYTICS_SERVICE_CREATED;
    }

    public AnalyticsConfiguratorService() {
        GradleBuildProfile.Builder builder = GradleBuildProfile.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"GradleBuildProfile.newBuilder()");
        this.resourcesManager = new AnalyticsResourceManager(builder, new ConcurrentHashMap(), false, null, new ConcurrentHashMap(), null, null, 64, null);
        this.state = State.COLLECTING_DATA;
    }

    public static final /* synthetic */ AnalyticsResourceManager access$getResourcesManager$p(AnalyticsConfiguratorService $this) {
        return $this.resourcesManager;
    }

    public static final /* synthetic */ void access$instantiateAnalyticsService(AnalyticsConfiguratorService $this, Project project) {
        $this.instantiateAnalyticsService(project);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "", "(Ljava/lang/String;I)V", "COLLECTING_DATA", "CALLBACK_REGISTERED", "ANALYTICS_SERVICE_CREATED", "gradle-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State COLLECTING_DATA;
        public static final /* enum */ State CALLBACK_REGISTERED;
        public static final /* enum */ State ANALYTICS_SERVICE_CREATED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = COLLECTING_DATA = new State();
            stateArray[1] = CALLBACK_REGISTERED = new State();
            stateArray[2] = ANALYTICS_SERVICE_CREATED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AnalyticsConfiguratorService, BuildServiceParameters.None> {
        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        }

        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(project, AnalyticsConfiguratorService.class, null, 4, null);
        }
    }
}

