/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FeatureSetMetadata {
    public static final Integer MAX_NUMBER_OF_SPLITS_BEFORE_O = 50;
    public static final Integer MAX_NUMBER_OF_SPLITS_STARTING_IN_O = 127;
    @VisibleForTesting
    static final String OUTPUT_FILE_NAME = "feature-metadata.json";
    @VisibleForTesting
    public static final int BASE_ID = 127;
    private final File sourceFile;
    private final Set<FeatureInfo> featureSplits;
    private final Integer maxNumberOfSplitsBeforeO;

    public FeatureSetMetadata(Integer maxNumberOfSplitsBeforeO) {
        this.maxNumberOfSplitsBeforeO = maxNumberOfSplitsBeforeO;
        this.featureSplits = new HashSet<FeatureInfo>();
        this.sourceFile = null;
    }

    private FeatureSetMetadata(Set<FeatureInfo> featureSplits, File sourceFile) {
        this.maxNumberOfSplitsBeforeO = Integer.max(MAX_NUMBER_OF_SPLITS_BEFORE_O, featureSplits.size());
        this.featureSplits = ImmutableSet.copyOf(featureSplits);
        this.sourceFile = sourceFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void addFeatureSplit(int minSdkVersion2, String modulePath, String featureName2, String packageName2) {
        int id;
        if (minSdkVersion2 < 26) {
            if (this.featureSplits.size() >= this.maxNumberOfSplitsBeforeO) {
                throw new RuntimeException("You have reached the maximum number of feature splits : " + this.maxNumberOfSplitsBeforeO);
            }
            id = 126 - this.featureSplits.size();
        } else {
            if (this.featureSplits.size() >= MAX_NUMBER_OF_SPLITS_STARTING_IN_O) {
                throw new RuntimeException("You have reached the maximum number of feature splits : " + MAX_NUMBER_OF_SPLITS_STARTING_IN_O);
            }
            id = 128 + this.featureSplits.size();
        }
        this.featureSplits.add(new FeatureInfo(modulePath, featureName2, id, packageName2));
    }

    public Integer getResOffsetFor(String modulePath) {
        Optional<FeatureInfo> featureInfo = this.featureSplits.stream().filter(metadata -> metadata.modulePath.equals(modulePath)).findFirst();
        return featureInfo.isPresent() ? Integer.valueOf(featureInfo.get().resOffset) : null;
    }

    public String getFeatureNameFor(String modulePath) {
        Optional<FeatureInfo> featureInfo = this.featureSplits.stream().filter(metadata -> metadata.modulePath.equals(modulePath)).findFirst();
        return featureInfo.isPresent() ? featureInfo.get().featureName : null;
    }

    public Map<String, String> getFeatureNameToPackageNameMap() {
        return (Map)this.featureSplits.stream().collect(ImmutableMap.toImmutableMap(info2 -> info2.featureName, info2 -> info2.packageName));
    }

    public void save(File outputFile) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson2 = gsonBuilder.create();
        Files.asCharSink((File)outputFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson2.toJson(this.featureSplits));
    }

    public static FeatureSetMetadata load(File input) throws IOException {
        if (input.isDirectory()) {
            input = new File(input, OUTPUT_FILE_NAME);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson2 = gsonBuilder.create();
        Type typeToken = new TypeToken<HashSet<FeatureInfo>>(){}.getType();
        try (FileReader fileReader = new FileReader(input);){
            Set featureIds = (Set)gson2.fromJson((Reader)fileReader, typeToken);
            FeatureSetMetadata featureSetMetadata = new FeatureSetMetadata(featureIds, input);
            return featureSetMetadata;
        }
    }

    private static class FeatureInfo {
        final String modulePath;
        final String featureName;
        final int resOffset;
        final String packageName;

        FeatureInfo(String modulePath, String featureName2, int resOffset2, String packageName2) {
            this.modulePath = modulePath;
            this.featureName = featureName2;
            this.resOffset = resOffset2;
            this.packageName = packageName2;
        }
    }
}

