/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.ide.DefaultAppBundleProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultAppBundleVariantBuildOutput;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/AppModelBuilder;", "Lcom/android/build/gradle/internal/ide/ModelBuilder;", "Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "config", "extraModelInfo", "Lcom/android/build/gradle/internal/ExtraModelInfo;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "syncIssueReporter", "Lcom/android/build/gradle/internal/errors/SyncIssueReporter;", "projectType", "", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/variant/VariantModel;Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;Lcom/android/build/gradle/internal/ExtraModelInfo;Lcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/errors/SyncIssueReporter;ILcom/android/build/gradle/internal/scope/ProjectInfo;)V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "buildMinimalisticModel", "canBuild", "", "getDynamicFeatures", "", "isBaseSplit", "gradle-core"})
public final class AppModelBuilder
extends ModelBuilder<BaseAppModuleExtension> {
    @NotNull
    private final VariantModel variantModel;

    public AppModelBuilder(@NotNull GlobalScope globalScope, @NotNull VariantModel variantModel, @NotNull BaseAppModuleExtension config2, @NotNull ExtraModelInfo extraModelInfo, @NotNull ProjectOptions projectOptions, @NotNull SyncIssueReporter syncIssueReporter, int projectType, @NotNull ProjectInfo projectInfo) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)variantModel, (String)"variantModel");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)extraModelInfo, (String)"extraModelInfo");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncIssueReporter), (String)"syncIssueReporter");
        Intrinsics.checkParameterIsNotNull((Object)projectInfo, (String)"projectInfo");
        super(globalScope, variantModel, (BaseExtension)config2, extraModelInfo, projectOptions, syncIssueReporter, projectType, projectInfo);
        this.variantModel = variantModel;
    }

    @Override
    protected boolean isBaseSplit() {
        return true;
    }

    @Override
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return super.canBuild(modelName) || Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName());
    }

    @Override
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName())) {
            object = this.buildMinimalisticModel();
        } else {
            Object object2 = super.buildAll(modelName, project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"super.buildAll(modelName, project)");
            object = object2;
        }
        return object;
    }

    @Override
    @NotNull
    protected Collection<String> getDynamicFeatures() {
        return (Collection)GuavaKtxKt.toImmutableSet((Iterable)((BaseAppModuleExtension)this.extension).getDynamicFeatures());
    }

    private final Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        for (VariantImpl component2 : this.variantModel.getVariants()) {
            ArtifactsImpl artifacts2 = component2.getArtifacts();
            if (!component2.getVariantType().isBaseModule() || component2.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) continue;
            Provider bundleFile = artifacts2.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE);
            Provider apkFolder = artifacts2.get(InternalArtifactType.EXTRACTED_APKS.INSTANCE);
            variantsOutput.add((Object)new DefaultAppBundleVariantBuildOutput(component2.getName(), ((RegularFile)bundleFile.get()).getAsFile(), ((Directory)apkFolder.get()).getAsFile()));
        }
        return new DefaultAppBundleProjectBuildOutput((ImmutableList<AppBundleVariantBuildOutput>)variantsOutput.build());
    }
}

