/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.build.CxxBuilder;
import com.android.build.gradle.internal.cxx.build.CxxRegularBuilderKt;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRepublishBuilder;", "Lcom/android/build/gradle/internal/cxx/build/CxxBuilder;", "model", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "(Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;)V", "getModel", "()Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "objFolder", "Ljava/io/File;", "getObjFolder", "()Ljava/io/File;", "soFolder", "getSoFolder", "build", "", "ops", "Lorg/gradle/process/ExecOperations;", "gradle-core"})
public final class CxxRepublishBuilder
implements CxxBuilder {
    @NotNull
    private final CxxConfigurationModel model;

    public CxxRepublishBuilder(@NotNull CxxConfigurationModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.model = model;
    }

    @NotNull
    public final CxxConfigurationModel getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public File getObjFolder() {
        return this.model.getVariant().getSoFolder();
    }

    @Override
    @NotNull
    public File getSoFolder() {
        return this.model.getVariant().getSoFolder();
    }

    @Override
    public void build(@NotNull ExecOperations ops2) {
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        LoggingEnvironmentKt.infoln("link or copy build outputs to republish point", new Object[0]);
        CxxVariantModel variant2 = this.model.getVariant();
        List<CxxAbiModel> abis2 = this.model.getActiveAbis();
        List<NativeBuildConfigValueMini> miniConfigs = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(abis2, null);
        for (NativeBuildConfigValueMini config2 : miniConfigs) {
            for (NativeLibraryValueMini library : config2.libraries.values()) {
                Object libraryAbi;
                String[] stringArray;
                Object object;
                File file;
                File output2;
                Object object2 = library.output;
                if (object2 == null || !(output2 = (file = object2)).exists() || (object = library.abi) == null || (stringArray = Abi.getByName((String)(libraryAbi = (object2 = object)))) == null) continue;
                Object abi = object = stringArray;
                stringArray = new String[]{((Abi)((Object)abi)).getTag()};
                File baseOutputFolder = FileUtils.join((File)variant2.getSoFolder(), (String[])stringArray);
                if (!baseOutputFolder.isDirectory()) continue;
                Object object3 = new String[]{((Abi)((Object)abi)).getTag()};
                File baseRepublishFolder = FileUtils.join((File)variant2.getSoRepublishFolder(), (String[])object3);
                baseRepublishFolder.mkdirs();
                String[] stringArray2 = new String[]{output2.getName()};
                object3 = FileUtils.join((File)baseOutputFolder, (String[])stringArray2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"join(baseOutputFolder, output.name)");
                Object object4 = object3;
                stringArray2 = new String[]{output2.getName()};
                object3 = FileUtils.join((File)baseRepublishFolder, (String[])stringArray2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"join(baseRepublishFolder, output.name)");
                CxxRegularBuilderKt.hardLinkOrCopy((File)object4, (File)object3);
                for (File runtimeFile : library.runtimeFiles) {
                    String[] stringArray3 = new String[]{runtimeFile.getName()};
                    File file2 = FileUtils.join((File)baseOutputFolder, (String[])stringArray3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"join(baseOutputFolder, runtimeFile.name)");
                    File file3 = file2;
                    stringArray3 = new String[]{runtimeFile.getName()};
                    file2 = FileUtils.join((File)baseRepublishFolder, (String[])stringArray3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"join(baseRepublishFolder, runtimeFile.name)");
                    CxxRegularBuilderKt.hardLinkOrCopy(file3, file2);
                }
            }
        }
        for (CxxAbiModel abi : this.model.getActiveAbis()) {
            if (abi.getStlLibraryFile() == null || !abi.getStlLibraryFile().isFile() || !abi.getSoRepublishFolder().isDirectory()) continue;
            File file = abi.getSoRepublishFolder();
            String string = abi.getStlLibraryFile().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.stlLibraryFile.name");
            File objAbi = FilesKt.resolve((File)file, (String)string);
            CxxRegularBuilderKt.hardLinkOrCopy(abi.getStlLibraryFile(), objAbi);
        }
    }
}

