/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class TransformInvocationBuilder {
    Context context;
    Collection<TransformInput> inputs = ImmutableList.of();
    Collection<TransformInput> referencedInputs = ImmutableList.of();
    Collection<SecondaryInput> secondaryInputs = ImmutableList.of();
    TransformOutputProvider transformOutputProvider;
    boolean isIncremental = false;

    public TransformInvocationBuilder(Context context) {
        this.context = context;
    }

    public TransformInvocationBuilder addInputs(Collection<TransformInput> inputs) {
        this.inputs = ImmutableList.copyOf(inputs);
        return this;
    }

    public TransformInvocationBuilder addReferencedInputs(Collection<TransformInput> referencedInputs) {
        this.referencedInputs = ImmutableList.copyOf(referencedInputs);
        return this;
    }

    public TransformInvocationBuilder addSecondaryInputs(Collection<SecondaryInput> secondaryInputs) {
        this.secondaryInputs = ImmutableList.copyOf(secondaryInputs);
        return this;
    }

    public TransformInvocationBuilder addOutputProvider(TransformOutputProvider transformOutputProvider) {
        this.transformOutputProvider = transformOutputProvider;
        return this;
    }

    public TransformInvocationBuilder setIncrementalMode(boolean isIncremental) {
        this.isIncremental = isIncremental;
        return this;
    }

    public TransformInvocation build() {
        return new TransformInvocation(){

            public Context getContext() {
                return TransformInvocationBuilder.this.context;
            }

            public Collection<TransformInput> getInputs() {
                return TransformInvocationBuilder.this.inputs;
            }

            public Collection<TransformInput> getReferencedInputs() {
                return TransformInvocationBuilder.this.referencedInputs;
            }

            public Collection<SecondaryInput> getSecondaryInputs() {
                return TransformInvocationBuilder.this.secondaryInputs;
            }

            public TransformOutputProvider getOutputProvider() {
                return TransformInvocationBuilder.this.transformOutputProvider;
            }

            public boolean isIncremental() {
                return TransformInvocationBuilder.this.isIncremental;
            }
        };
    }
}

