/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTask;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTaskKt;
import com.android.build.gradle.internal.tasks.Info;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.ide.common.repository.GradleVersion;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "Lcom/android/build/gradle/internal/tasks/ClasspathComparisonTask;", "()V", "projectBuildFile", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectBuildFile", "()Lorg/gradle/api/file/RegularFileProperty;", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "onDifferentVersionsFound", "", "group", "module", "runtimeVersion", "compileVersion", "CreationAction", "gradle-core"})
public abstract class AppClasspathCheckTask
extends ClasspathComparisonTask {
    @Internal(value="only for task execution")
    @NotNull
    public abstract Property<String> getProjectPath();

    @Internal(value="only for task execution")
    @NotNull
    public abstract RegularFileProperty getProjectBuildFile();

    @Override
    protected void onDifferentVersionsFound(@NotNull String group, @NotNull String module2, @NotNull String runtimeVersion, @NotNull String compileVersion) {
        Object runtime;
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkParameterIsNotNull((Object)compileVersion, (String)"compileVersion");
        try {
            runtime = GradleVersion.parse((String)runtimeVersion);
            GradleVersion compile = GradleVersion.parse((String)compileVersion);
            runtime = runtime.compareTo(compile) > 0 ? runtimeVersion : compileVersion;
        }
        catch (Throwable e) {
            runtime = runtimeVersion;
        }
        Object suggestedVersion = runtime;
        String message = "Conflict with dependency '" + group + ':' + module2 + "' in project '" + this.getProjectPath().get() + "'.\nResolved versions for runtime classpath (" + runtimeVersion + ") and compile classpath (" + compileVersion + ") differ.\nThis can lead to runtime crashes.\nTo resolve this issue follow advice at https://developer.android.com/studio/build/gradle-tips#configure-project-wide-properties.\nAlternatively, you can try to fix the problem by adding this snippet to " + ((RegularFile)this.getProjectBuildFile().get()).getAsFile() + ":\n\ndependencies {\n    implementation(\"" + group + ':' + module2 + ':' + (String)suggestedVersion + "\")\n}\n";
        throw new RuntimeException(message);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends TaskCreationAction<AppClasspathCheckTask> {
        @NotNull
        private final ComponentCreationConfig creationConfig;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            this.creationConfig = creationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.creationConfig.computeTaskName("check", "Classpath");
        }

        @Override
        @NotNull
        public Class<AppClasspathCheckTask> getType() {
            return AppClasspathCheckTask.class;
        }

        @Override
        public void configure(@NotNull AppClasspathCheckTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            task.setVariantName(this.creationConfig.getName());
            Configuration runtimeClasspath = this.creationConfig.getVariantDependencies().getRuntimeClasspath();
            Configuration compileClasspath = this.creationConfig.getVariantDependencies().getCompileClasspath();
            task.getRuntimeVersionMap().set(task.getProject().getProviders().provider((Callable)new Callable<Map<Info, ? extends String>>(runtimeClasspath){
                final /* synthetic */ Configuration $runtimeClasspath;
                {
                    this.$runtimeClasspath = $runtimeClasspath;
                }

                public final Map<Info, String> call() {
                    return ClasspathComparisonTaskKt.toVersionMap(this.$runtimeClasspath);
                }
            }));
            task.getCompileVersionMap().set(task.getProject().getProviders().provider((Callable)new Callable<Map<Info, ? extends String>>(compileClasspath){
                final /* synthetic */ Configuration $compileClasspath;
                {
                    this.$compileClasspath = $compileClasspath;
                }

                public final Map<Info, String> call() {
                    return ClasspathComparisonTaskKt.toVersionMap(this.$compileClasspath);
                }
            }));
            String[] stringArray = new String[]{this.getName(), this.creationConfig.getDirName()};
            task.setFakeOutputDirectory(FileUtils.join((File)this.creationConfig.getServices().getProjectInfo().getIntermediatesDir(), (String[])stringArray));
            HasConfigurableValuesKt.setDisallowChanges(task.getProjectPath(), task.getProject().getPath());
            task.getProjectBuildFile().set(task.getProject().getBuildFile());
            task.getProjectBuildFile().disallowChanges();
        }
    }
}

