/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"createCert", "Ljava/security/cert/X509Certificate;", "keyPair", "Ljava/security/KeyPair;", "generateRsaKeyPair", "", "certFile", "Ljava/io/File;", "privateKeyFile", "writePemFile", "pemObject", "Lorg/bouncycastle/util/io/pem/PemObject;", "file", "gradle-core"})
public final class TLSUtilsKt {
    public static final void generateRsaKeyPair(@NotNull File certFile, @NotNull File privateKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)certFile, (String)"certFile");
        Intrinsics.checkParameterIsNotNull((Object)privateKeyFile, (String)"privateKeyFile");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator $this$generateRsaKeyPair_u24lambda_u2d0 = keyPairGenerator;
        boolean bl3 = false;
        $this$generateRsaKeyPair_u24lambda_u2d0.initialize(4096, new SecureRandom());
        KeyPair keyPair = $this$generateRsaKeyPair_u24lambda_u2d0.generateKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyPair");
        TLSUtilsKt.writePemFile(new PemObject("CERTIFICATE", TLSUtilsKt.createCert(keyPair).getEncoded()), certFile);
        TLSUtilsKt.writePemFile(new PemObject("RSA PRIVATE KEY", keyPair.getPrivate().getEncoded()), privateKeyFile);
    }

    private static final X509Certificate createCert(KeyPair keyPair) {
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(keyPair.getPrivate());
        X500Name name = new X500Name("CN=localhost");
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(name, BigInteger.valueOf(new SecureRandom().nextLong()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + Duration.ofDays(365L).toMillis()), name, SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded())));
        X509CertificateHolder certHolder = builder.build(signer);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        boolean bl = false;
        boolean bl2 = false;
        JcaX509CertificateConverter $this$createCert_u24lambda_u2d1 = jcaX509CertificateConverter;
        boolean bl3 = false;
        $this$createCert_u24lambda_u2d1.setProvider((Provider)new BouncyCastleProvider());
        X509Certificate x509Certificate = jcaX509CertificateConverter.getCertificate(certHolder);
        Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"JcaX509CertificateConverter().apply {\n        setProvider(BouncyCastleProvider())\n    }.getCertificate(certHolder)");
        return x509Certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writePemFile(PemObject pemObject, File file) {
        Closeable closeable = (Closeable)new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PemWriter writer = (PemWriter)closeable;
            boolean bl3 = false;
            writer.writeObject((PemObjectGenerator)pemObject);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

