/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationInvalidationState;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxMetadataGenerator;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.model.JsonUtilKt;
import com.android.build.gradle.internal.cxx.model.PrefabConfigurationState;
import com.android.build.gradle.internal.cxx.timing.TimingEnvironment;
import com.android.build.gradle.internal.cxx.timing.TimingEnvironmentKt;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.TokenizedCommandLineMap;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Internal;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 $2\u00020\u0001:\u0001$B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0006H&J\"\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00052\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0006H&R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxMetadataGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "getAbis", "()Ljava/util/List;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariantBuilder", "()Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "buildForOneConfiguration", "", "ops", "Lorg/gradle/process/ExecOperations;", "forceJsonGeneration", "", "abi", "checkPrefabConfig", "executeProcess", "generate", "forceGeneration", "abiName", "", "generateBuildFilesIndex", "generateCompileCommandsJsonBin", "generateSymbolFolderIndexFile", "getDependentBuildFiles", "Ljava/io/File;", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "Companion", "gradle-core"})
public abstract class ExternalNativeJsonGenerator
implements CxxMetadataGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxxVariantModel variant;
    @NotNull
    private final List<CxxAbiModel> abis;
    @Nullable
    private final GradleBuildVariant.Builder variantBuilder;

    public ExternalNativeJsonGenerator(@NotNull CxxVariantModel variant2, @NotNull List<CxxAbiModel> abis2, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis2, (String)"abis");
        this.variant = variant2;
        this.abis = abis2;
        this.variantBuilder = variantBuilder;
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    @NotNull
    public final CxxVariantModel getVariant() {
        return this.variant;
    }

    @Internal
    @NotNull
    public final List<CxxAbiModel> getAbis() {
        return this.abis;
    }

    @Override
    @Internal
    @Nullable
    public GradleBuildVariant.Builder getVariantBuilder() {
        return this.variantBuilder;
    }

    private final List<File> getDependentBuildFiles(CxxAbiModel abi) throws IOException {
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"newArrayList()");
        List result2 = arrayList;
        if (!CxxAbiModelKt.getJsonFile(abi).exists()) {
            return result2;
        }
        List<File> list = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, this.getVariantBuilder());
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getNativeBuildMiniConfig(abi, variantBuilder)");
        NativeBuildConfigValueMini config2 = list;
        for (File pkgDir : CreateCxxVariantModelKt.getPrefabPackageDirectoryList(this.variant)) {
            Files.walk(pkgDir.toPath(), new FileVisitOption[0]).forEach(new Consumer<Path>((List<File>)result2){
                final /* synthetic */ List<File> $result;
                {
                    this.$result = $result;
                }

                public final void accept(Path it) {
                    File file = it.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.toFile()");
                    this.$result.add(file);
                }
            });
        }
        list = config2.buildFiles;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"config.buildFiles");
        result2.addAll((Collection)list);
        return result2;
    }

    @Override
    public void generate(@NotNull ExecOperations ops2, boolean forceGeneration, @Nullable String abiName) {
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        ThreadLoggingEnvironment.Companion.requireExplicitLogger();
        CreateCxxVariantModelKt.getPrefabPackageDirectoryList(this.variant);
        CreateCxxVariantModelKt.getPrefabClassPath(this.variant);
        for (CxxAbiModel abi : this.abis) {
            String string;
            Object[] objectArray;
            if (abiName != null && !Intrinsics.areEqual((Object)abiName, (Object)abi.getAbi().getTag())) continue;
            try {
                this.buildForOneConfiguration(ops2, forceGeneration, abi);
            }
            catch (GradleException e) {
                objectArray = new Object[1];
                string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                objectArray[0] = string;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.METADATA_GENERATION_FAILURE, "exception while building Json %s", objectArray);
            }
            catch (ProcessException e) {
                objectArray = new Object[3];
                objectArray[0] = this.variant.getModule().getBuildSystem().getTag();
                objectArray[1] = this.variant.getModule().getMakeFile();
                string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                objectArray[2] = string;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.METADATA_GENERATION_FAILURE, "error when building with %s using %s: %s", objectArray);
            }
        }
    }

    protected void checkPrefabConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void buildForOneConfiguration(ExecOperations ops2, boolean forceJsonGeneration, CxxAbiModel abi) throws GradleException, IOException, ProcessException {
        AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(abi.getVariant().getModule().getMakeFile(), abi.getVariant().getVariantName() + '|' + abi.getAbi().getTag(), false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PassThroughPrefixingLoggingEnvironment recorder = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
            boolean bl3 = false;
            AutoCloseable autoCloseable2 = new TimingEnvironment(CxxAbiModelKt.getMetadataGenerationTimingFolder(abi), "generate_cxx_metadata", null, 4, null);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                GradleBuildVariant.Builder builder;
                boolean bl6;
                Object processBuilder;
                Object object;
                TimingEnvironment it = (TimingEnvironment)autoCloseable2;
                boolean bl7 = false;
                GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
                variantStats.setAbi(AnalyticsUtil.getAbi(abi.getAbi().getTag()));
                variantStats.setDebuggable(this.getVariant().isDebuggableEnabled());
                long startTime = System.currentTimeMillis();
                variantStats.setGenerationStartMs(startTime);
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = abi.getAbiPlatformVersion();
                    object = abi.getAbi().getTag();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"abi.abi.tag");
                    objectArray[1] = object;
                    objectArray[2] = abi.getAbiPlatformVersion();
                    LoggingEnvironmentKt.infoln("Start JSON generation. Platform version: %s min SDK version: %s", objectArray);
                    processBuilder = this.getProcessBuilder(abi);
                    String currentBuildCommand = StringsKt.trimIndent((String)("\n                    " + processBuilder + "\n                    Build command args: " + CxxAbiModelKt.getBuildCommandArguments(abi) + "\n                    Version: 2\n                    "));
                    PrefabConfigurationState prefabState = new PrefabConfigurationState(abi.getVariant().getModule().getProject().isPrefabEnabled(), CreateCxxVariantModelKt.getPrefabClassPath(abi.getVariant()), CreateCxxVariantModelKt.getPrefabPackageDirectoryList(this.getVariant()));
                    PrefabConfigurationState previousPrefabState = ExternalNativeJsonGenerator.Companion.getPreviousPrefabConfigurationState(CxxAbiModelKt.getPrefabConfigFile(abi));
                    JsonGenerationInvalidationState invalidationState2 = (JsonGenerationInvalidationState)TimingEnvironmentKt.time("create-invalidation-state", (Function0)new Function0<JsonGenerationInvalidationState>(forceJsonGeneration, abi, currentBuildCommand, this, prefabState, previousPrefabState){
                        final /* synthetic */ boolean $forceJsonGeneration;
                        final /* synthetic */ CxxAbiModel $abi;
                        final /* synthetic */ String $currentBuildCommand;
                        final /* synthetic */ ExternalNativeJsonGenerator this$0;
                        final /* synthetic */ PrefabConfigurationState $prefabState;
                        final /* synthetic */ PrefabConfigurationState $previousPrefabState;
                        {
                            this.$forceJsonGeneration = $forceJsonGeneration;
                            this.$abi = $abi;
                            this.$currentBuildCommand = $currentBuildCommand;
                            this.this$0 = $receiver;
                            this.$prefabState = $prefabState;
                            this.$previousPrefabState = $previousPrefabState;
                            super(0);
                        }

                        @NotNull
                        public final JsonGenerationInvalidationState invoke() {
                            return new JsonGenerationInvalidationState(this.$forceJsonGeneration, CxxAbiModelKt.getJsonFile(this.$abi), CxxAbiModelKt.getMetadataGenerationCommandFile(this.$abi), this.$currentBuildCommand, com.android.build.gradle.tasks.ExternalNativeJsonGenerator$Companion.access$getFileContent(ExternalNativeJsonGenerator.Companion, CxxAbiModelKt.getMetadataGenerationCommandFile(this.$abi)), ExternalNativeJsonGenerator.access$getDependentBuildFiles(this.this$0, this.$abi), this.$prefabState, this.$previousPrefabState);
                        }
                    });
                    if (invalidationState2.getRebuild()) {
                        Unit unit;
                        Object object2 = new Object[]{CxxAbiModelKt.getJsonFile(abi)};
                        LoggingEnvironmentKt.infoln("rebuilding JSON %s due to:", (Object[])object2);
                        for (String string : invalidationState2.getRebuildReasons()) {
                            LoggingEnvironmentKt.infoln(string, new Object[0]);
                        }
                        if (CxxAbiModelKt.shouldGeneratePrefabPackages(abi)) {
                            TimingEnvironmentKt.time("generate-prefab-packages", (Function0)new Function0<Unit>(this, ops2, abi){
                                final /* synthetic */ ExternalNativeJsonGenerator this$0;
                                final /* synthetic */ ExecOperations $ops;
                                final /* synthetic */ CxxAbiModel $abi;
                                {
                                    this.this$0 = $receiver;
                                    this.$ops = $ops;
                                    this.$abi = $abi;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.checkPrefabConfig();
                                    GeneratePrefabPackagesKt.generatePrefabPackages(this.$ops, this.$abi);
                                }
                            });
                        }
                        if (abi.getCxxBuildFolder().getParentFile().exists()) {
                            if (invalidationState2.getSoftRegeneration()) {
                                object2 = new Object[]{abi.getCxxBuildFolder()};
                                LoggingEnvironmentKt.infoln("keeping json folder '%s' but regenerating project", (Object[])object2);
                            } else {
                                object2 = new Object[]{abi.getCxxBuildFolder()};
                                LoggingEnvironmentKt.infoln("removing stale contents from '%s'", (Object[])object2);
                                FileUtils.deletePath((File)abi.getCxxBuildFolder());
                            }
                        }
                        if (abi.getCxxBuildFolder().mkdirs()) {
                            object2 = new Object[]{abi.getCxxBuildFolder()};
                            LoggingEnvironmentKt.infoln("created folder '%s'", (Object[])object2);
                        }
                        object2 = new Object[]{this.getVariant().getModule().getBuildSystem().getTag(), processBuilder};
                        LoggingEnvironmentKt.infoln("executing %s %s", (Object[])object2);
                        TimingEnvironmentKt.time("execute-generate-process", (Function0)new Function0<Unit>(this, ops2, abi){
                            final /* synthetic */ ExternalNativeJsonGenerator this$0;
                            final /* synthetic */ ExecOperations $ops;
                            final /* synthetic */ CxxAbiModel $abi;
                            {
                                this.this$0 = $receiver;
                                this.$ops = $ops;
                                this.$abi = $abi;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.executeProcess(this.$ops, this.$abi);
                            }
                        });
                        object2 = new Object[]{this.getVariant().getModule().getBuildSystem().getTag()};
                        LoggingEnvironmentKt.infoln("done executing %s", (Object[])object2);
                        if (!CxxAbiModelKt.getJsonFile(abi).exists()) {
                            object2 = StringCompanionObject.INSTANCE;
                            String string = "Expected json generation to create '%s' but it didn't";
                            Object[] objectArray2 = new Object[]{CxxAbiModelKt.getJsonFile(abi)};
                            boolean bl8 = false;
                            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                            throw new GradleException(string2);
                        }
                        object2 = this.getVariantBuilder();
                        if (object2 == null) {
                            unit = null;
                        } else {
                            Object object3 = object2;
                            bl6 = false;
                            boolean bl9 = false;
                            Object it2 = object3;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            boolean bl12 = false;
                            synchronized (it2) {
                                boolean bl13 = false;
                                TimingEnvironmentKt.time("remove-unexpected-so-files", (Function0)new Function0<Unit>(abi, (GradleBuildVariant.Builder)it2){
                                    final /* synthetic */ CxxAbiModel $abi;
                                    final /* synthetic */ GradleBuildVariant.Builder $it;
                                    {
                                        this.$abi = $abi;
                                        this.$it = $it;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        File file = this.$abi.getSoFolder();
                                        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(this.$abi, this.$it);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(\n                                                    abi, it\n                                            )");
                                        com.android.build.gradle.tasks.ExternalNativeJsonGenerator$Companion.access$removeUnexpectedSoFiles(ExternalNativeJsonGenerator.Companion, file, nativeBuildConfigValueMini);
                                    }
                                });
                                Unit unit2 = Unit.INSTANCE;
                            }
                            unit = Unit.INSTANCE;
                        }
                        object2 = new Object[1];
                        String string = CxxAbiModelKt.getMetadataGenerationCommandFile(abi).getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.metadataGenerationCommandFile.absolutePath");
                        object2[0] = string;
                        LoggingEnvironmentKt.infoln("write command file %s", (Object[])object2);
                        CxxAbiModelKt.getMetadataGenerationCommandFile(abi).getParentFile().mkdirs();
                        Path path = CxxAbiModelKt.getMetadataGenerationCommandFile(abi).toPath();
                        object2 = currentBuildCommand;
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                        Charset charset2 = charset;
                        bl6 = false;
                        Object object4 = object2;
                        if (object4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = ((String)object4).getBytes(charset2);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        Files.write(path, byArray, new OpenOption[0]);
                        Path path2 = CxxAbiModelKt.getPrefabConfigFile(abi).toPath();
                        object2 = prefabState.toJsonString();
                        Charset charset3 = Charsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"UTF_8");
                        Charset charset4 = charset3;
                        bl6 = false;
                        Object object5 = object2;
                        if (object5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray2 = ((String)object5).getBytes(charset4);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                        Files.write(path2, byArray2, new OpenOption[0]);
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
                    } else {
                        Object[] objectArray3 = new Object[]{CxxAbiModelKt.getJsonFile(abi)};
                        LoggingEnvironmentKt.infoln("JSON '%s' was up-to-date", objectArray3);
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
                    }
                    TimingEnvironmentKt.time("generate-extra-metadata-files", (Function0)new Function0<Unit>(this, abi){
                        final /* synthetic */ ExternalNativeJsonGenerator this$0;
                        final /* synthetic */ CxxAbiModel $abi;
                        {
                            this.this$0 = $receiver;
                            this.$abi = $abi;
                            super(0);
                        }

                        public final void invoke() {
                            ExternalNativeJsonGenerator.access$generateSymbolFolderIndexFile(this.this$0, this.$abi);
                            ExternalNativeJsonGenerator.access$generateBuildFilesIndex(this.this$0, this.$abi, this.this$0.getVariantBuilder());
                            ExternalNativeJsonGenerator.access$generateCompileCommandsJsonBin(this.this$0, this.$abi);
                        }
                    });
                    LoggingEnvironmentKt.infoln("JSON generation completed without problems", new Object[0]);
                }
                catch (GradleException e) {
                    try {
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                        LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"JSON generation completed with problem. Exception: ", (Object)((Object)e)), new Object[0]);
                        throw e;
                        catch (IOException e2) {
                            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                            LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"JSON generation completed with problem. Exception: ", (Object)e2), new Object[0]);
                            throw e2;
                        }
                        catch (ProcessException e3) {
                            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                            LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"JSON generation completed with problem. Exception: ", (Object)((Object)e3)), new Object[0]);
                            throw e3;
                        }
                    }
                    catch (Throwable throwable3) {
                        boolean bl14;
                        Object object6;
                        GradleBuildVariant.Builder builder2;
                        variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                        Object object7 = this.getVariantBuilder();
                        if (object7 == null) {
                            builder2 = null;
                        } else {
                            GradleBuildVariant.Builder builder3;
                            object6 = object7;
                            bl14 = false;
                            boolean bl15 = false;
                            GradleBuildVariant.Builder it3 = object6;
                            boolean bl16 = false;
                            boolean bl17 = false;
                            boolean bl18 = false;
                            synchronized (it3) {
                                boolean bl19 = false;
                                builder3 = it3.addNativeBuildConfig(variantStats);
                            }
                            builder2 = builder3;
                        }
                        CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).getParentFile().mkdirs();
                        Path path = CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).toPath();
                        object7 = PassThroughDeduplicatingLoggingEnvironmentKt.toJsonString(recorder.getRecord());
                        object6 = Charsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"UTF_8");
                        bl14 = false;
                        Object object8 = object7;
                        if (object8 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = ((String)object8).getBytes((Charset)object6);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        Files.write(path, byArray, new OpenOption[0]);
                        LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Writing build model to ", (Object)CxxAbiModelKt.getModelOutputFile(abi)), new Object[0]);
                        TimingEnvironmentKt.time("write-metadata-json-to-file", (Function0)new Function0<Unit>(abi){
                            final /* synthetic */ CxxAbiModel $abi;
                            {
                                this.$abi = $abi;
                                super(0);
                            }

                            public final void invoke() {
                                JsonUtilKt.writeJsonToFile(this.$abi);
                            }
                        });
                        throw throwable3;
                    }
                }
                variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                processBuilder = this.getVariantBuilder();
                if (processBuilder == null) {
                    builder = null;
                } else {
                    GradleBuildVariant.Builder builder4;
                    object = processBuilder;
                    boolean bl20 = false;
                    boolean bl21 = false;
                    String it4 = object;
                    boolean bl22 = false;
                    boolean bl23 = false;
                    bl6 = false;
                    synchronized (it4) {
                        boolean bl24 = false;
                        builder4 = it4.addNativeBuildConfig(variantStats);
                    }
                    builder = builder4;
                }
                CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).getParentFile().mkdirs();
                Path path = CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).toPath();
                processBuilder = PassThroughDeduplicatingLoggingEnvironmentKt.toJsonString(recorder.getRecord());
                object = Charsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"UTF_8");
                boolean bl25 = false;
                Object object9 = processBuilder;
                if (object9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object9).getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                Files.write(path, byArray, new OpenOption[0]);
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Writing build model to ", (Object)CxxAbiModelKt.getModelOutputFile(abi)), new Object[0]);
                TimingEnvironmentKt.time("write-metadata-json-to-file", (Function0)new /* invalid duplicate definition of identical inner class */);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void generateSymbolFolderIndexFile(CxxAbiModel abi) {
        CxxAbiModelKt.getSymbolFolderIndexFile(abi).getParentFile().mkdirs();
        File file = CxxAbiModelKt.getSymbolFolderIndexFile(abi);
        Object object = abi.getSoFolder().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"abi.soFolder.absolutePath");
        String string = object;
        object = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"UTF_8");
        FilesKt.writeText((File)file, (String)string, (Charset)object);
    }

    private final void generateBuildFilesIndex(CxxAbiModel abi, GradleBuildVariant.Builder variantBuilder) {
        CxxAbiModelKt.getBuildFileIndexFile(abi).getParentFile().mkdirs();
        File file = CxxAbiModelKt.getBuildFileIndexFile(abi);
        Object object = AndroidBuildGradleJsons.getNativeBuildMiniConfig((CxxAbiModel)abi, (GradleBuildVariant.Builder)variantBuilder).buildFiles;
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"getNativeBuildMiniConfig(\n                abi,\n                variantBuilder\n            ).buildFiles");
        Iterable iterable = (Iterable)object;
        object = System.lineSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lineSeparator()");
        String string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)((CharSequence)object), null, null, (int)0, null, null, (int)62, null);
        object = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"UTF_8");
        FilesKt.writeText((File)file, (String)string, (Charset)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateCompileCommandsJsonBin(CxxAbiModel abi) {
        TokenizedCommandLineMap interner2 = new TokenizedCommandLineMap(false, 0, (Function2)generateCompileCommandsJsonBin.interner.1.INSTANCE, 2, null);
        if (!CxxAbiModelKt.getCompileCommandsJsonFile(abi).exists() || CxxAbiModelKt.getCompileCommandsJsonBinFile(abi).exists() && CxxAbiModelKt.getCompileCommandsJsonBinFile(abi).lastModified() >= CxxAbiModelKt.getCompileCommandsJsonFile(abi).lastModified()) {
            return;
        }
        Object object = CxxAbiModelKt.getCompileCommandsJsonFile(abi);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileInputStream((File)object2);
        bl2 = false;
        object = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)object2, charset));
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            JsonReader reader = (JsonReader)object;
            boolean bl4 = false;
            AutoCloseable autoCloseable = (AutoCloseable)new CompileCommandsEncoder(CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), 0, 2, null);
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable2 = null;
            try {
                CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
                boolean bl7 = false;
                reader.beginArray();
                while (reader.hasNext()) {
                    String string;
                    reader.beginObject();
                    String directory2 = null;
                    String command = null;
                    String sourceFile = null;
                    block21: while (reader.hasNext()) {
                        block32: {
                            string = reader.nextName();
                            if (string == null) break block32;
                            int n = -1;
                            switch (string.hashCode()) {
                                case 3143036: {
                                    if (string.equals("file")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case -962584979: {
                                    if (string.equals("directory")) {
                                        n = 2;
                                    }
                                    break;
                                }
                                case 950394699: {
                                    if (string.equals("command")) {
                                        n = 3;
                                    }
                                    break;
                                }
                            }
                            switch (n) {
                                case 2: {
                                    String string2 = reader.nextString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reader.nextString()");
                                    directory2 = string2;
                                    continue block21;
                                }
                                case 3: {
                                    String string2 = reader.nextString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reader.nextString()");
                                    command = string2;
                                    continue block21;
                                }
                                case 1: {
                                    String string2 = reader.nextString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reader.nextString()");
                                    sourceFile = string2;
                                    continue block21;
                                }
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    if (command == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"command");
                        throw null;
                    }
                    if (sourceFile == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"sourceFile");
                        throw null;
                    }
                    string = (Triple)interner2.computeIfAbsent(command, sourceFile, (Function1)generateCompileCommandsJsonBin.1.1.1.INSTANCE);
                    String compiler = (String)string.component1();
                    List flags = (List)string.component2();
                    String output2 = (String)string.component3();
                    boolean bl8 = output2 != null;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (_Assertions.ENABLED && !bl8) {
                        boolean bl11 = false;
                        String string3 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string3));
                    }
                    if (directory2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"directory");
                        throw null;
                    }
                    encoder.writeCompileCommand(new File(sourceFile), new File(compiler), flags, new File(directory2), new File(output2));
                }
                reader.endArray();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public abstract ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel var1);

    public abstract void executeProcess(@NotNull ExecOperations var1, @NotNull CxxAbiModel var2);

    protected static final boolean isWindows() {
        return Companion.isWindows();
    }

    public static final /* synthetic */ List access$getDependentBuildFiles(ExternalNativeJsonGenerator $this, CxxAbiModel abi) {
        return $this.getDependentBuildFiles(abi);
    }

    public static final /* synthetic */ void access$generateSymbolFolderIndexFile(ExternalNativeJsonGenerator $this, CxxAbiModel abi) {
        $this.generateSymbolFolderIndexFile(abi);
    }

    public static final /* synthetic */ void access$generateBuildFilesIndex(ExternalNativeJsonGenerator $this, CxxAbiModel abi, GradleBuildVariant.Builder variantBuilder) {
        $this.generateBuildFilesIndex(abi, variantBuilder);
    }

    public static final /* synthetic */ void access$generateCompileCommandsJsonBin(ExternalNativeJsonGenerator $this, CxxAbiModel abi) {
        $this.generateCompileCommandsJsonBin(abi);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u00020\u00048DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator$Companion;", "", "()V", "isWindows", "", "isWindows$annotations", "()Z", "getFileContent", "", "commandFile", "Ljava/io/File;", "getPreviousPrefabConfigurationState", "Lcom/android/build/gradle/internal/cxx/model/PrefabConfigurationState;", "prefabStateFile", "removeUnexpectedSoFiles", "", "expectedOutputFolder", "config", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        protected final boolean isWindows() {
            return SdkConstants.CURRENT_PLATFORM == 2;
        }

        @JvmStatic
        protected static /* synthetic */ void isWindows$annotations() {
        }

        private final String getFileContent(File commandFile) throws IOException {
            String string;
            if (!commandFile.exists()) {
                string = "";
            } else {
                byte[] byArray = Files.readAllBytes(commandFile.toPath());
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"readAllBytes(commandFile.toPath())");
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                boolean bl = false;
                string = new String(byArray, charset);
            }
            return string;
        }

        private final PrefabConfigurationState getPreviousPrefabConfigurationState(File prefabStateFile) throws IOException {
            PrefabConfigurationState prefabConfigurationState;
            if (!prefabStateFile.exists()) {
                prefabConfigurationState = new PrefabConfigurationState(false, null, CollectionsKt.emptyList());
            } else {
                byte[] byArray = Files.readAllBytes(prefabStateFile.toPath());
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"readAllBytes(prefabStateFile.toPath())");
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                boolean bl = false;
                prefabConfigurationState = PrefabConfigurationState.Companion.fromJson(new String(byArray, charset));
            }
            return prefabConfigurationState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2) throws IOException {
            Comparable<File> comparable;
            if (!expectedOutputFolder.isDirectory()) {
                return;
            }
            Object object = Lists.newArrayList();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"newArrayList()");
            List expectedSoFiles = (List)object;
            for (NativeLibraryValueMini library : config2.libraries.values()) {
                File file = library.output;
                if (file == null) continue;
                File output2 = comparable = file;
                comparable = output2.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"output.toPath()");
                expectedSoFiles.add(comparable);
            }
            object = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream paths = (Stream)object;
                boolean bl3 = false;
                paths.filter(removeUnexpectedSoFiles.1.1.INSTANCE).filter(removeUnexpectedSoFiles.1.2.INSTANCE).filter(new Predicate<Path>((List<Path>)expectedSoFiles){
                    final /* synthetic */ List<Path> $expectedSoFiles;
                    {
                        this.$expectedSoFiles = $expectedSoFiles;
                    }

                    public final boolean test(Path it) {
                        return !this.$expectedSoFiles.contains(it);
                    }
                }).forEach(removeUnexpectedSoFiles.1.4.INSTANCE);
                comparable = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }

        public static final /* synthetic */ void access$removeUnexpectedSoFiles(Companion $this, File expectedOutputFolder, NativeBuildConfigValueMini config2) {
            $this.removeUnexpectedSoFiles(expectedOutputFolder, config2);
        }

        public static final /* synthetic */ String access$getFileContent(Companion $this, File commandFile) {
            return $this.getFileContent(commandFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

