/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.ArtifactTypeUtil;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.StringOption;
import com.android.builder.internal.packaging.AabFlinger;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "finalBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "finalBundleFileName", "", "getFinalBundleFileName", "()Ljava/lang/String;", "intermediaryBundleFile", "getIntermediaryBundleFile", "<set-?>", "Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "signingConfigData", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "CreationForAssetPackBundleAction", "Params", "gradle-core"})
public abstract class FinalizeBundleTask
extends NonIncrementalTask {
    @Nullable
    private SigningConfigDataProvider signingConfigData;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntermediaryBundleFile();

    @Nested
    @Optional
    @Nullable
    public final SigningConfigDataProvider getSigningConfigData() {
        return this.signingConfigData;
    }

    @Input
    @NotNull
    public final String getFinalBundleFileName() {
        String string = ((RegularFile)this.getFinalBundleFile().get()).getAsFile().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalBundleFile.get().asFile.name");
        return string;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getFinalBundleFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ FinalizeBundleTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                SigningConfigProviderParams signingConfigProviderParams;
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getIntermediaryBundleFile().set((Provider)this.this$0.getIntermediaryBundleFile());
                it.getFinalBundleFile().set((Provider)this.this$0.getFinalBundleFile());
                SigningConfigDataProvider signingConfigDataProvider = this.this$0.getSigningConfigData();
                if (signingConfigDataProvider != null && (signingConfigProviderParams = signingConfigDataProvider.convertToParams()) != null) {
                    SigningConfigProviderParams signingConfigProviderParams2 = signingConfigProviderParams;
                    boolean bl = false;
                    boolean bl2 = false;
                    SigningConfigProviderParams signing = signingConfigProviderParams2;
                    boolean bl3 = false;
                    it.getSigningConfig().set((Object)signing);
                }
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "finalBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "intermediaryBundleFile", "getIntermediaryBundleFile", "signingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigProviderParams;", "getSigningConfig", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getIntermediaryBundleFile();

        @NotNull
        public abstract RegularFileProperty getFinalBundleFile();

        @NotNull
        public abstract Property<SigningConfigProviderParams> getSigningConfig();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "()V", "compressBundle", "", "inputFile", "Ljava/io/File;", "outputFile", "run", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void compressBundle(File inputFile, File outputFile) {
            Object object = inputFile;
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = new ZipInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                ZipInputStream inputStream = (ZipInputStream)object;
                boolean bl2 = false;
                Object object2 = outputFile;
                int n2 = 0;
                object2 = new FileOutputStream((File)object2);
                n2 = 8192;
                boolean bl3 = false;
                object2 = new ZipOutputStream(object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n2));
                n2 = 0;
                bl3 = false;
                Throwable throwable2 = null;
                try {
                    ZipEntry zipEntry;
                    ZipOutputStream outputStream = (ZipOutputStream)object2;
                    boolean bl4 = false;
                    while ((zipEntry = inputStream.getNextEntry()) != null) {
                        ZipEntry entry = zipEntry;
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        outEntry.setTime(0L);
                        outputStream.putNextEntry(outEntry);
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                        outputStream.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                Unit unit;
                Unit unit2;
                FileUtils.deleteIfExists((File)((File)((Params)this.getParameters()).getFinalBundleFile().getAsFile().get()));
                Object object = (SigningConfigProviderParams)((Params)this.getParameters()).getSigningConfig().getOrNull();
                if (object == null) {
                    unit2 = null;
                } else {
                    SigningConfigData signingConfigData = ((SigningConfigProviderParams)object).resolve();
                    if (signingConfigData == null) {
                        unit2 = null;
                    } else {
                        SigningConfigData signingConfigData2 = signingConfigData;
                        boolean bl = false;
                        boolean bl2 = false;
                        SigningConfigData it = signingConfigData2;
                        boolean bl3 = false;
                        String string = it.getStoreType();
                        Object object2 = it.getStoreFile();
                        if (object2 == null) {
                            Intrinsics.throwNpe();
                        }
                        File file = object2;
                        object2 = it.getStorePassword();
                        if (object2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Object object3 = object2;
                        object2 = it.getKeyPassword();
                        if (object2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Object object4 = object2;
                        object2 = it.getKeyAlias();
                        if (object2 == null) {
                            Intrinsics.throwNpe();
                        }
                        CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)string, (File)file, (String)object3, (String)object4, (String)object2);
                        object2 = ((Params)this.getParameters()).getFinalBundleFile().getAsFile().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.finalBundleFile.asFile.get()");
                        File file2 = (File)object2;
                        object2 = it.getKeyAlias();
                        Locale locale = Locale.US;
                        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"US");
                        boolean bl4 = false;
                        Object object5 = object2;
                        boolean bl5 = false;
                        Object object6 = object5;
                        if (object6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)object6).toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
                        object2 = certificateInfo.getKey();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"certificateInfo.key");
                        object2 = (Closeable)new AabFlinger(file2, string2, (PrivateKey)object2, CollectionsKt.listOf((Object)certificateInfo.getCertificate()), 18);
                        boolean bl6 = false;
                        bl4 = false;
                        Throwable throwable = null;
                        try {
                            AabFlinger it2 = (AabFlinger)object2;
                            boolean bl7 = false;
                            File file3 = ((RegularFile)((Params)this.getParameters()).getIntermediaryBundleFile().get()).getAsFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"parameters.intermediaryBundleFile.get().asFile");
                            it2.writeZip(file3, -1);
                            object5 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                }
                if (unit != null) break block15;
                object = this;
                boolean bl = false;
                boolean bl8 = false;
                BundleToolRunnable $this$run_u24lambda_u2d4 = (BundleToolRunnable)object;
                boolean bl9 = false;
                Object object7 = ((Params)$this$run_u24lambda_u2d4.getParameters()).getIntermediaryBundleFile().getAsFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"parameters.intermediaryBundleFile.asFile.get()");
                File file = (File)object7;
                object7 = ((Params)$this$run_u24lambda_u2d4.getParameters()).getFinalBundleFile().getAsFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"parameters.finalBundleFile.asFile.get()");
                $this$run_u24lambda_u2d4.compressBundle(file, (File)object7);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "signingConfig", "Lcom/android/build/api/dsl/SigningConfig;", "isSigningReady", "", "(Lcom/android/build/gradle/internal/services/ProjectServices;Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/api/dsl/SigningConfig;Z)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends TaskCreationAction<FinalizeBundleTask> {
        @NotNull
        private final ProjectServices projectServices;
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final SigningConfig signingConfig;
        private final boolean isSigningReady;
        @NotNull
        private final Class<FinalizeBundleTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ProjectServices projectServices2, @NotNull ArtifactsImpl artifacts2, @NotNull SigningConfig signingConfig2, boolean isSigningReady) {
            Intrinsics.checkParameterIsNotNull((Object)projectServices2, (String)"projectServices");
            Intrinsics.checkParameterIsNotNull((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkParameterIsNotNull((Object)signingConfig2, (String)"signingConfig");
            this.projectServices = projectServices2;
            this.artifacts = artifacts2;
            this.signingConfig = signingConfig2;
            this.isSigningReady = isSigningReady;
            this.type = FinalizeBundleTask.class;
            this.name = "signBundle";
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FinalizeBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            String bundleName = Intrinsics.stringPlus((String)this.projectServices.getProjectInfo().getProjectBaseName(), (Object)".aab");
            Artifact artifact = (Artifact)SingleArtifact.BUNDLE.INSTANCE;
            DirectoryProperty directoryProperty = this.artifacts.getBuildDirectory$gradle_core();
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"artifacts.buildDirectory");
            File location = ArtifactTypeUtil.getOutputPath(artifact, directoryProperty, "", new String[0]);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).atLocation(location.getAbsolutePath()).withName(bundleName).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            VariantAwareTask variantAwareTask = task;
            Project project2 = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"task.project");
            VariantAwareTaskKt.configureVariantProperties(variantAwareTask, "", project2);
            this.artifacts.setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getIntermediaryBundleFile());
            if (this.isSigningReady) {
                SigningConfigData signingConfigData = SigningConfigData.Companion.fromDslSigningConfig(this.signingConfig);
                Provider provider2 = this.projectServices.getProviderFactory().provider((Callable)new Callable<SigningConfigData>(signingConfigData){
                    final /* synthetic */ SigningConfigData $signingConfigData;
                    {
                        this.$signingConfigData = $signingConfigData;
                    }

                    @Nullable
                    public final SigningConfigData call() {
                        return this.$signingConfigData;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"val signingConfigData =\n                    SigningConfigData.fromDslSigningConfig(signingConfig)\n                task.signingConfigData = SigningConfigDataProvider(\n                    signingConfigData = projectServices.providerFactory.provider { signingConfigData }");
                task.signingConfigData = new SigningConfigDataProvider((Provider<SigningConfigData>)provider2, null, this.artifacts.get(InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE));
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FinalizeBundleTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("sign", "Bundle");
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return FinalizeBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FinalizeBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            String bundleName = ((ApkCreationConfig)this.creationConfig).getServices().getProjectInfo().getProjectBaseName() + '-' + ((ApkCreationConfig)this.creationConfig).getBaseName() + ".aab";
            String apkLocationOverride = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            if (apkLocationOverride == null) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(bundleName).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
            } else {
                String[] stringArray = new String[]{((ApkCreationConfig)this.creationConfig).getDirName()};
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).atLocation(FileUtils.join((File)((ApkCreationConfig)this.creationConfig).getServices().file(apkLocationOverride), (String[])stringArray).getAbsolutePath()).withName(bundleName).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getIntermediaryBundleFile());
            if (!((ApkCreationConfig)this.creationConfig).getDebuggable()) {
                task.signingConfigData = SigningConfigDataProvider.Companion.create((ApkCreationConfig)this.creationConfig);
            }
        }
    }
}

