/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.Version;
import java.lang.reflect.Field;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.build.IncludedBuildState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"ANDROID_GRADLE_PLUGIN_ID", "", "CHECK_PERFORMED", "compareVersions", "", "firstProjectPath", "firstVersion", "projectToCheck", "Lorg/gradle/api/Project;", "enforceTheSamePluginVersions", "project", "gradle-core"})
@JvmName(name="AgpVersionChecker")
public final class AgpVersionChecker {
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_ID = "com.android.base";
    @NotNull
    private static final String CHECK_PERFORMED = "android.agp.version.check.performed";

    public static final void enforceTheSamePluginVersions(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (project2.getGradle().getParent() != null) {
            return;
        }
        ExtraPropertiesExtension extraProperties = project2.getRootProject().getExtensions().getExtraProperties();
        if (extraProperties.has(CHECK_PERFORMED)) {
            return;
        }
        String currentVersion = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        String currentProjectPath = project2.getProjectDir().getCanonicalPath();
        project2.getGradle().afterProject((Action)new Action<Project>(currentProjectPath, currentVersion){
            final /* synthetic */ String $currentProjectPath;
            final /* synthetic */ String $currentVersion;
            {
                this.$currentProjectPath = $currentProjectPath;
                this.$currentVersion = $currentVersion;
            }

            public final void execute(Project it) {
                String string = this.$currentProjectPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentProjectPath");
                String string2 = string;
                string = this.$currentVersion;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentVersion");
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                AgpVersionChecker.access$compareVersions(string2, string, it);
            }
        });
        Collection collection = project2.getGradle().getIncludedBuilds();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"project.gradle.includedBuilds");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IncludedBuild includedBuild = (IncludedBuild)element$iv;
            boolean bl = false;
            IncludedBuild includedBuild2 = includedBuild;
            if (includedBuild2 instanceof IncludedBuildState) {
                ((IncludedBuildState)includedBuild).getConfiguredBuild().allprojects((Action)new Action<Project>(currentProjectPath, currentVersion){
                    final /* synthetic */ String $currentProjectPath;
                    final /* synthetic */ String $currentVersion;
                    {
                        this.$currentProjectPath = $currentProjectPath;
                        this.$currentVersion = $currentVersion;
                    }

                    public final void execute(Project it) {
                        String string = this.$currentProjectPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentProjectPath");
                        String string2 = string;
                        string = this.$currentVersion;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentVersion");
                        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                        AgpVersionChecker.access$compareVersions(string2, string, it);
                    }
                });
                continue;
            }
            project2.getLogger().warn("Unable to detect AGP versions for included builds. All projects in the build should use the same AGP version. Class name for the included build object: " + includedBuild.getClass().getName() + '.');
        }
        extraProperties.set(CHECK_PERFORMED, (Object)true);
    }

    private static final void compareVersions(String firstProjectPath, String firstVersion, Project projectToCheck) {
        projectToCheck.getPlugins().withId(ANDROID_GRADLE_PLUGIN_ID, (Action)new Action<Plugin>(projectToCheck, firstVersion, firstProjectPath){
            final /* synthetic */ Project $projectToCheck;
            final /* synthetic */ String $firstVersion;
            final /* synthetic */ String $firstProjectPath;
            {
                this.$projectToCheck = $projectToCheck;
                this.$firstVersion = $firstVersion;
                this.$firstProjectPath = $firstProjectPath;
            }

            public final void execute(Plugin<?> it) {
                String string;
                try {
                    Field field;
                    Object object;
                    block8: {
                        Class<?> clazz;
                        try {
                            clazz = it.getClass().getClassLoader().loadClass(Version.class.getName());
                        }
                        catch (ClassNotFoundException exception) {
                            clazz = it.getClass().getClassLoader().loadClass(com.android.builder.model.Version.class.getName());
                        }
                        Class<?> versionClass = clazz;
                        Object[] objectArray = versionClass.getFields();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"versionClass.fields");
                        objectArray = objectArray;
                        boolean bl = false;
                        Object[] objectArray2 = objectArray;
                        boolean bl2 = false;
                        for (Object object2 : objectArray2) {
                            Field it2 = (Field)object2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"ANDROID_GRADLE_PLUGIN_VERSION")) continue;
                            object = object2;
                            break block8;
                        }
                        object = null;
                    }
                    Object object3 = (Field)object;
                    if (object3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((object3 = (field = object3).get(null)) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)object3;
                }
                catch (Throwable ex) {
                    this.$projectToCheck.getLogger().error("Unable to get AGP version for project `" + this.$projectToCheck.getProjectDir().getCanonicalPath() + "`. All projects in the build should use the same AGP version.", ex);
                    throw ex;
                }
                String versionValue = string;
                if (!Intrinsics.areEqual((Object)versionValue, (Object)this.$firstVersion)) {
                    throw new IllegalStateException(StringsKt.trimIndent((String)("\nUsing multiple versions of the Android Gradle plugin in the same build is not allowed.\n- Project `" + this.$firstProjectPath + "` is using version `" + this.$firstVersion + "`\n- Project `" + this.$projectToCheck.getProjectDir().getCanonicalPath() + "` is using version `" + versionValue + "`\n            ")));
                }
            }
        });
    }

    public static final /* synthetic */ void access$compareVersions(String firstProjectPath, String firstVersion, Project projectToCheck) {
        AgpVersionChecker.compareVersions(firstProjectPath, firstVersion, projectToCheck);
    }
}

