/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.cxx.configure.CxxCreateGradleTasksKt;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.AnalyticsRecordingTask;
import com.android.build.gradle.internal.tasks.ApkZipPackagingTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.CompressAssetsTask;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.ExtractProfilerNativeDependenciesTask;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.PackagedDependenciesWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.VariantType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class AbstractAppTaskManager<VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
extends TaskManager<VariantBuilderT, VariantT> {
    protected AbstractAppTaskManager(List<ComponentInfo<VariantBuilderT, VariantT>> variants, List<TestComponentImpl> testComponents, List<TestFixturesImpl> testFixturesComponents, boolean hasFlavors, ProjectOptions projectOptions, GlobalScope globalScope, BaseExtension extension, ProjectInfo projectInfo) {
        super(variants, testComponents, testFixturesComponents, hasFlavors, projectOptions, globalScope, extension, projectInfo);
    }

    protected void createCommonTasks(ComponentInfo<VariantBuilderT, VariantT> variant2, List<? extends ComponentInfo<VariantBuilderT, VariantT>> allComponentsWithLint) {
        VariantImpl appVariantProperties = (VariantImpl)variant2.getVariant();
        ApkCreationConfig apkCreationConfig = (ApkCreationConfig)((Object)appVariantProperties);
        this.createAnchorTasks(appVariantProperties);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(appVariantProperties));
        this.createDependencyStreams(appVariantProperties);
        this.createApplicationIdWriterTask(apkCreationConfig);
        this.taskFactory.register(new CheckManifest.CreationAction(appVariantProperties));
        this.createMergeApkManifestsTask(appVariantProperties);
        this.createGenerateResValuesTask(appVariantProperties);
        this.createRenderscriptTask(appVariantProperties);
        this.createMergeResourcesTasks(appVariantProperties);
        this.createShaderTask(appVariantProperties);
        this.createMergeAssetsTask(appVariantProperties);
        this.taskFactory.register(new CompressAssetsTask.CreationAction(apkCreationConfig));
        this.createBuildConfigTask(appVariantProperties);
        this.createApkProcessResTask(appVariantProperties);
        this.registerRClassTransformStream(appVariantProperties);
        this.createProcessJavaResTask(appVariantProperties);
        this.createAidlTask(appVariantProperties);
        this.maybeExtractProfilerDependencies(apkCreationConfig);
        CxxCreateGradleTasksKt.createCxxVariantBuildTask(this.taskFactory, (VariantImpl)variant2.getVariant());
        this.createMergeJniLibFoldersTasks(appVariantProperties);
        this.createDataBindingTasksIfNecessary(appVariantProperties);
        this.createMlkitTask(appVariantProperties);
        this.createCompileTask(appVariantProperties);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(appVariantProperties));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.FullCreationAction(appVariantProperties));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.SymbolTableCreationAction(appVariantProperties));
        this.createPackagingTask(apkCreationConfig);
        this.taskFactory.register(new PackagedDependenciesWriterTask.CreationAction(appVariantProperties));
        this.taskFactory.register(new ApkZipPackagingTask.CreationAction(appVariantProperties));
    }

    private void createCompileTask(VariantImpl variant2) {
        ApkCreationConfig apkCreationConfig = (ApkCreationConfig)((Object)variant2);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(variant2);
        this.addJavacClassesStream(variant2);
        AbstractAppTaskManager.setJavaCompilerTask(javacTask, variant2);
        this.createPostCompilationTasks(apkCreationConfig);
    }

    @Override
    protected void postJavacCreation(ComponentCreationConfig creationConfig) {
        Provider<Directory> javacOutput = creationConfig.getArtifacts().get(InternalArtifactType.JAVAC.INSTANCE);
        ConfigurableFileCollection preJavacGeneratedBytecode = creationConfig.getVariantData().getAllPreJavacGeneratedBytecode();
        ConfigurableFileCollection postJavacGeneratedBytecode = creationConfig.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.register(new BundleAllClasses.CreationAction(creationConfig));
        ConfigurableFileCollection files2 = creationConfig.getServices().fileCollection(javacOutput, preJavacGeneratedBytecode, postJavacGeneratedBytecode);
        creationConfig.getArtifacts().appendToAllClasses((FileCollection)files2);
    }

    @Override
    protected void createVariantPreBuildTask(ComponentCreationConfig creationConfig) {
        VariantType variantType = creationConfig.getVariantType();
        if (variantType.isApk()) {
            Object task;
            boolean useDependencyConstraints = creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
            if (variantType.isTestComponent()) {
                task = this.taskFactory.register(new TestPreBuildTask.CreationAction((TestComponentImpl)creationConfig));
                if (useDependencyConstraints) {
                    task.configure(t -> t.setEnabled(false));
                }
            } else {
                task = this.taskFactory.register(AppPreBuildTask.getCreationAction(creationConfig));
                ApkCreationConfig config2 = (ApkCreationConfig)creationConfig;
                boolean analyticsEnabled = creationConfig.getServices().getProjectOptions().isAnalyticsEnabled();
                if (!config2.getDebuggable() && analyticsEnabled) {
                    TaskProvider<AnalyticsRecordingTask> recordTask = this.taskFactory.register(new AnalyticsRecordingTask.CreationAction(config2));
                    task.configure(it -> it.finalizedBy(new Object[]{recordTask}));
                }
            }
            if (!useDependencyConstraints) {
                TaskProvider<AppClasspathCheckTask> classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(creationConfig));
                TaskFactoryUtils.dependsOn(task, classpathCheck);
            }
            if (variantType.isBaseModule() && this.globalScope.hasDynamicFeatures()) {
                TaskProvider<CheckMultiApkLibrariesTask> checkMultiApkLibrariesTask = this.taskFactory.register(new CheckMultiApkLibrariesTask.CreationAction(creationConfig));
                TaskFactoryUtils.dependsOn(task, checkMultiApkLibrariesTask);
            }
            return;
        }
        super.createVariantPreBuildTask(creationConfig);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentCreationConfig creationConfig, QualifiedContent.ContentType contentType) {
        if (creationConfig.getVariantScope().consumesFeatureJars() && contentType == QualifiedContent.DefaultContentType.RESOURCES && !(creationConfig instanceof ConsumableCreationConfig)) {
            return TransformManager.SCOPE_FULL_WITH_FEATURES;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void createApplicationIdWriterTask(ApkCreationConfig creationConfig) {
        if (creationConfig.getVariantType().isBaseModule()) {
            this.taskFactory.register(new ModuleMetadataWriterTask.CreationAction((ApplicationCreationConfig)creationConfig));
        }
        TaskProvider<ApplicationIdWriterTask> applicationIdWriterTask = this.taskFactory.register(new ApplicationIdWriterTask.CreationAction(creationConfig));
        TextResourceFactory resources = this.project.getResources().getText();
        ((ComponentImpl)((Object)creationConfig)).getVariantData().applicationIdTextResource = resources.fromFile(applicationIdWriterTask);
    }

    private void createMergeResourcesTasks(VariantImpl variant2) {
        this.createMergeResourcesTask(variant2, true, (ImmutableSet<MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        ProjectOptions projectOptions = variant2.getServices().getProjectOptions();
        boolean nonTransitiveR = projectOptions.get(BooleanOption.NON_TRANSITIVE_R_CLASS);
        boolean namespaced = variant2.getGlobalScope().getExtension().getAaptOptions().getNamespaced();
        if ((projectOptions.get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS) || nonTransitiveR) && !variant2.getVariantType().isForTesting() && !namespaced) {
            this.basicCreateMergeResourcesTask(variant2, TaskManager.MergeType.PACKAGE, false, false, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of(), null);
        }
    }

    private void maybeExtractProfilerDependencies(ApkCreationConfig apkCreationConfig) {
        if (apkCreationConfig.getShouldPackageProfilerDependencies()) {
            this.taskFactory.register(new ExtractProfilerNativeDependenciesTask.CreationAction(apkCreationConfig));
        }
    }
}

