/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.manifest;

import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.build.gradle.internal.manifest.ManifestDataKt;
import com.android.build.gradle.internal.manifest.ManifestDataProvider;
import com.android.build.gradle.internal.services.ProjectServices;
import java.io.File;
import java.util.function.BooleanSupplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/manifest/LazyManifestParser;", "Lcom/android/build/gradle/internal/manifest/ManifestDataProvider;", "manifestFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "manifestFileRequired", "", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "manifestParsingAllowed", "Ljava/util/function/BooleanSupplier;", "(Lorg/gradle/api/provider/Provider;ZLcom/android/build/gradle/internal/services/ProjectServices;Ljava/util/function/BooleanSupplier;)V", "manifestData", "Lcom/android/build/gradle/internal/manifest/ManifestData;", "getManifestData", "()Lorg/gradle/api/provider/Provider;", "manifestData$delegate", "Lkotlin/Lazy;", "manifestLocation", "", "getManifestLocation", "()Ljava/lang/String;", "gradle-core"})
public final class LazyManifestParser
implements ManifestDataProvider {
    @NotNull
    private final Provider<RegularFile> manifestFile;
    private final boolean manifestFileRequired;
    @NotNull
    private final ProjectServices projectServices;
    @NotNull
    private final BooleanSupplier manifestParsingAllowed;
    @NotNull
    private final Lazy manifestData$delegate;

    public LazyManifestParser(@NotNull Provider<RegularFile> manifestFile, boolean manifestFileRequired, @NotNull ProjectServices projectServices2, @NotNull BooleanSupplier manifestParsingAllowed) {
        Intrinsics.checkParameterIsNotNull(manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)projectServices2, (String)"projectServices");
        Intrinsics.checkParameterIsNotNull((Object)manifestParsingAllowed, (String)"manifestParsingAllowed");
        this.manifestFile = manifestFile;
        this.manifestFileRequired = manifestFileRequired;
        this.projectServices = projectServices2;
        this.manifestParsingAllowed = manifestParsingAllowed;
        this.manifestData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Property<ManifestData>>(this){
            final /* synthetic */ LazyManifestParser this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Property<ManifestData> invoke() {
                Provider provider2 = LazyManifestParser.access$getManifestFile$p(this.this$0).map((Transformer)new Transformer<ManifestData, RegularFile>(this.this$0){
                    final /* synthetic */ LazyManifestParser this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final ManifestData transform(RegularFile it) {
                        File file = it.getAsFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.asFile");
                        return ManifestDataKt.parseManifest(file, LazyManifestParser.access$getManifestFileRequired$p(this.this$0), LazyManifestParser.access$getManifestParsingAllowed$p(this.this$0), LazyManifestParser.access$getProjectServices$p(this.this$0).getIssueReporter());
                    }
                });
                Property property = LazyManifestParser.access$getProjectServices$p(this.this$0).getObjectFactory().property(ManifestData.class);
                boolean bl = false;
                boolean bl2 = false;
                Property it = property;
                boolean bl3 = false;
                it.set(provider2);
                it.finalizeValueOnRead();
                return property;
            }
        }));
    }

    @Override
    @NotNull
    public Provider<ManifestData> getManifestData() {
        Lazy lazy = this.manifestData$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pyright (C) 2020 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.android.build.gradle.internal.manifest\n\nimport com.android.build.gradle.internal.services.ProjectServices\nimport org.gradle.api.file.RegularFile\nimport org.gradle.api.provider.Provider\nimport java.util.function.BooleanSupplier\n\n/**\n * a lazy manifest parser that can create a `Provider<ManifestData>`\n */\nclass LazyManifestParser(\n    private val manifestFile: Provider<RegularFile>,\n    private val manifestFileRequired: Boolean,\n    private val projectServices: ProjectServices,\n    private val manifestParsingAllowed: BooleanSupplier\n): ManifestDataProvider {\n\n     override val manifestData: Provider<ManifestData> by lazy {\n        // using map will allow us to keep task dependency should the manifest be generated or\n        // transformed via a task\n        val provider = manifestFile.map {\n            parseManifest(\n                it.asFile,\n                manifestFileRequired,\n                manifestParsingAllowed,\n                projectServices.issueReporter\n            )\n        }\n\n        // wrap the provider in a property to allow memoization\n        projectServices.objectFactory.property(ManifestData::class.java).also {\n            it.set(provider)\n            it.finalizeValueOnRead()\n            // TODO disable early get\n        }\n    }");
        return (Provider)object;
    }

    @Override
    @NotNull
    public String getManifestLocation() {
        String string = ((RegularFile)this.manifestFile.get()).getAsFile().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"manifestFile.get().asFile.absolutePath");
        return string;
    }

    public static final /* synthetic */ Provider access$getManifestFile$p(LazyManifestParser $this) {
        return $this.manifestFile;
    }

    public static final /* synthetic */ boolean access$getManifestFileRequired$p(LazyManifestParser $this) {
        return $this.manifestFileRequired;
    }

    public static final /* synthetic */ BooleanSupplier access$getManifestParsingAllowed$p(LazyManifestParser $this) {
        return $this.manifestParsingAllowed;
    }

    public static final /* synthetic */ ProjectServices access$getProjectServices$p(LazyManifestParser $this) {
        return $this.projectServices;
    }
}

