/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.signing.DefaultSigningConfig;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import shadow.bundletool.com.android.prefs.AndroidLocation;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0007\u00a8\u0006\b"}, d2={"createDefaultDebugStore", "", "defaultDebugKeystoreLocation", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "getDefaultDebugKeystoreLocation", "Lcom/android/prefs/AndroidLocationsProvider;", "gradle-core"})
@JvmName(name="GradleKeystoreHelper")
public final class GradleKeystoreHelper {
    @NotNull
    public static final File getDefaultDebugKeystoreLocation(@NotNull AndroidLocationsProvider $this$getDefaultDebugKeystoreLocation) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)$this$getDefaultDebugKeystoreLocation, (String)"<this>");
        try {
            file = KeystoreHelper.defaultDebugKeystoreLocation((AndroidLocationsProvider)$this$getDefaultDebugKeystoreLocation);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"{\n    KeystoreHelper.defaultDebugKeystoreLocation(this)\n}");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw new InvalidUserDataException("Failed to get default debug keystore location.", (Throwable)e);
        }
        return file;
    }

    public static final void createDefaultDebugStore(@NotNull File defaultDebugKeystoreLocation, @NotNull Logger logger) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)defaultDebugKeystoreLocation, (String)"defaultDebugKeystoreLocation");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        DefaultSigningConfig signingConfig2 = DefaultSigningConfig.Companion.debugSigningConfig(defaultDebugKeystoreLocation);
        logger.info("Creating default debug keystore at {}", (Object)defaultDebugKeystoreLocation.getAbsolutePath());
        try {
            String string = signingConfig2.getStoreType();
            Object object = signingConfig2.getStoreFile();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            File file = object;
            object = signingConfig2.getStorePassword();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = object;
            object = signingConfig2.getKeyPassword();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object3 = object;
            object = signingConfig2.getKeyAlias();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (!KeystoreHelper.createDebugStore((String)string, (File)file, (String)object2, (String)object3, (String)object, (ILogger)new LoggerWrapper(logger))) {
                throw new IOException("Unable to create missing debug keystore.");
            }
        }
        catch (KeytoolException e) {
            throw new IOException(e);
        }
    }
}

