/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.AndroidAnalyticsTestListener;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.builder.core.LibraryRequest;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class AndroidUnitTest
extends Test
implements VariantAwareTask {
    private String variantName;
    private ArtifactCollection dependencies;
    private GenerateTestConfig.TestConfigInputs testConfigInputs;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String name) {
        this.variantName = name;
    }

    @Nested
    @Optional
    public GenerateTestConfig.TestConfigInputs getTestConfigInputs() {
        return this.testConfigInputs;
    }

    @Internal
    abstract RegularFileProperty getJacocoCoverageOutputFile();

    @TaskAction
    public void executeTests() {
        JacocoTaskExtension jcoExtension = (JacocoTaskExtension)this.getExtensions().findByType(JacocoTaskExtension.class);
        AndroidAnalyticsTestListener testListener = new AndroidAnalyticsTestListener(this.dependencies, jcoExtension != null && jcoExtension.isEnabled(), (AnalyticsService)this.getAnalyticsService().get(), this.getFilter());
        this.addTestListener(testListener);
        super.executeTests();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AndroidUnitTest, ComponentCreationConfig> {
        private final UnitTestCreationConfig unitTestCreationConfig;

        public CreationAction(UnitTestCreationConfig unitTestCreationConfig) {
            super(unitTestCreationConfig);
            this.unitTestCreationConfig = unitTestCreationConfig;
        }

        @Override
        public String getName() {
            return this.computeTaskName("test");
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidUnitTest> taskProvider) {
            super.handleProvider(taskProvider);
            if (this.unitTestCreationConfig.getVariantDslInfo().isTestCoverageEnabled()) {
                this.unitTestCreationConfig.getArtifacts().setInitialProvider(taskProvider, AndroidUnitTest::getJacocoCoverageOutputFile).withName(taskProvider.getName() + ".exec").on(InternalArtifactType.UNIT_TEST_CODE_COVERAGE.INSTANCE);
            }
        }

        @Override
        public void configure(AndroidUnitTest task) {
            super.configure(task);
            this.unitTestCreationConfig.onTestedConfig(testedConfig -> {
                if (testedConfig.getVariantDslInfo().isTestCoverageEnabled()) {
                    task.getProject().getPlugins().withType(JacocoPlugin.class, plugin -> {
                        JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)task.getExtensions().findByType(JacocoTaskExtension.class);
                        if (testedConfig.getVariantType().isAar()) {
                            jacocoTaskExtension.setExcludes(Collections.singletonList("*"));
                        }
                        jacocoTaskExtension.setDestinationFile(task.getJacocoCoverageOutputFile().getAsFile());
                    });
                }
                return null;
            });
            GlobalScope globalScope = this.creationConfig.getGlobalScope();
            BaseExtension extension = globalScope.getExtension();
            VariantCreationConfig testedVariant = this.creationConfig.getTestedConfig();
            boolean includeAndroidResources = extension.getTestOptions().getUnitTests().isIncludeAndroidResources();
            boolean useRelativePathInTestConfig = this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_RELATIVE_PATH_IN_TEST_CONFIG);
            task.systemProperty("java.awt.headless", "true");
            task.setGroup("verification");
            task.setDescription("Run unit tests for the " + testedVariant.getName() + " build.");
            task.setTestClassesDirs(this.creationConfig.getArtifacts().getAllClasses());
            task.setClasspath((FileCollection)this.computeClasspath(this.creationConfig, includeAndroidResources));
            if (includeAndroidResources) {
                task.testConfigInputs = new GenerateTestConfig.TestConfigInputs(this.unitTestCreationConfig);
            }
            TestTaskReports testTaskReports = task.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(this.creationConfig.getServices().getProjectInfo().getTestResultsFolder(), task.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(this.creationConfig.getServices().getProjectInfo().getTestReportFolder(), task.getName()));
            extension.getTestOptions().getUnitTests().applyConfiguration(task);
            task.getOutputs().doNotCacheIf("AndroidUnitTest task is not yet cacheable when includeAndroidResources=true and android.testConfig.useRelativePath=false", (Spec & Serializable)thisTask -> includeAndroidResources && !useRelativePathInTestConfig);
            task.dependencies = this.creationConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
        }

        private ConfigurableFileCollection computeClasspath(ComponentCreationConfig creationConfig, boolean includeAndroidResources) {
            GlobalScope globalScope = creationConfig.getGlobalScope();
            ArtifactsImpl artifacts2 = creationConfig.getArtifacts();
            ConfigurableFileCollection collection = creationConfig.getServices().fileCollection();
            if (includeAndroidResources) {
                collection.from(new Object[]{artifacts2.get(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE)});
            }
            collection.from(new Object[]{creationConfig.getAllProjectClassesPostAsmInstrumentation()});
            collection.from(new Object[]{artifacts2.get(InternalArtifactType.JAVA_RES.INSTANCE)});
            collection.from(new Object[]{creationConfig.getDependenciesClassesJarsPostAsmInstrumentation(AndroidArtifacts.ArtifactScope.ALL)});
            collection.from(new Object[]{creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            if (creationConfig.getBuildFeatures().getAndroidResources() && !globalScope.getExtension().getAaptOptions().getNamespaced()) {
                collection.from(new Object[]{creationConfig.getVariantScope().getRJarForUnitTests()});
            }
            collection.from(new Object[]{this.getAdditionalAndRequestedOptionalLibraries(creationConfig.getGlobalScope())});
            collection.from(new Object[]{creationConfig.getGlobalScope().getMockableJarArtifact()});
            return collection;
        }

        private ConfigurableFileCollection getAdditionalAndRequestedOptionalLibraries(GlobalScope globalScope) {
            return this.creationConfig.getServices().fileCollection(() -> {
                SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader = (SdkComponentsBuildService.VersionedSdkLoader)globalScope.getVersionedSdkLoader().get();
                return BootClasspathBuilder.INSTANCE.computeAdditionalAndRequestedOptionalLibraries(this.creationConfig.getServices().getProjectInfo().getProject(), (List)versionedSdkLoader.getAdditionalLibrariesProvider().get(), (List)versionedSdkLoader.getOptionalLibrariesProvider().get(), false, (List<LibraryRequest>)ImmutableList.copyOf(globalScope.getExtension().getLibraryRequests()), this.creationConfig.getServices().getIssueReporter());
            });
        }
    }
}

