/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.AbstractOsFileConventions;
import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.build.gradle.external.gnumake.CommandClassifier;
import com.android.build.gradle.external.gnumake.CommandLine;
import com.android.build.gradle.external.gnumake.FlowAnalyzer;
import com.android.build.gradle.external.gnumake.OsFileConventions;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.utils.NativeSourceFileExtensions;
import com.android.utils.NdkUtils;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0002J\b\u0010'\u001a\u00020!H\u0002J\u0014\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\nH\u0002J\u0016\u0010)\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020+0*H\u0002J\u0016\u0010,\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020-0*H\u0002J2\u0010.\u001a\u00020\u00002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder;", "", "androidMk", "Ljava/io/File;", "executionRootPath", "compileCommandsJsonBinFile", "fileConventions", "Lcom/android/build/gradle/external/gnumake/OsFileConventions;", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/external/gnumake/OsFileConventions;)V", "buildTargetsCommand", "", "", "cFileExtensions", "", "compileCommandsEncoder", "Lcom/android/utils/cxx/CompileCommandsEncoder;", "cppFileExtensions", "outputs", "", "Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "skipProcessingCompilerFlags", "", "getSkipProcessingCompilerFlags", "()Z", "setSkipProcessingCompilerFlags", "(Z)V", "toolChainToCCompiler", "", "toolChainToCppCompiler", "build", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "buildImpl", "extractWorkingDirectoryFromDryRunOutputIfAvailable", "", "dryRunOutput", "findLibraryNames", "findToolChainCompilers", "findToolChainName", "outputFileName", "findToolchainNames", "generateCleanCommands", "generateLibraries", "", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "generateToolchains", "Lcom/android/build/gradle/internal/cxx/json/NativeToolchainValue;", "setCommands", "buildCommand", "cleanCommand", "variantName", "Companion", "Output", "gradle-core"})
public final class NativeBuildConfigValueBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File androidMk;
    @NotNull
    private File executionRootPath;
    @NotNull
    private final File compileCommandsJsonBinFile;
    @NotNull
    private final Map<String, String> toolChainToCCompiler;
    @NotNull
    private final Map<String, String> toolChainToCppCompiler;
    @NotNull
    private final Set<String> cFileExtensions;
    @NotNull
    private final Set<String> cppFileExtensions;
    @NotNull
    private final List<Output> outputs;
    @NotNull
    private final OsFileConventions fileConventions;
    @Nullable
    private List<String> buildTargetsCommand;
    private boolean skipProcessingCompilerFlags;
    private CompileCommandsEncoder compileCommandsEncoder;

    public NativeBuildConfigValueBuilder(@NotNull File androidMk, @NotNull File executionRootPath, @NotNull File compileCommandsJsonBinFile, @NotNull OsFileConventions fileConventions) {
        Intrinsics.checkNotNullParameter((Object)androidMk, (String)"androidMk");
        Intrinsics.checkNotNullParameter((Object)executionRootPath, (String)"executionRootPath");
        Intrinsics.checkNotNullParameter((Object)compileCommandsJsonBinFile, (String)"compileCommandsJsonBinFile");
        Intrinsics.checkNotNullParameter((Object)fileConventions, (String)"fileConventions");
        this.androidMk = androidMk;
        this.executionRootPath = executionRootPath;
        this.compileCommandsJsonBinFile = compileCommandsJsonBinFile;
        this.toolChainToCCompiler = new HashMap();
        this.toolChainToCppCompiler = new HashMap();
        this.cFileExtensions = new HashSet();
        this.cppFileExtensions = new HashSet();
        this.outputs = new ArrayList();
        this.fileConventions = fileConventions;
    }

    public /* synthetic */ NativeBuildConfigValueBuilder(File file, File file2, File file3, OsFileConventions osFileConventions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            OsFileConventions osFileConventions2 = AbstractOsFileConventions.createForCurrentHost();
            Intrinsics.checkNotNullExpressionValue((Object)osFileConventions2, (String)"createForCurrentHost()");
            osFileConventions = osFileConventions2;
        }
        this(file, file2, file3, osFileConventions);
    }

    public final boolean getSkipProcessingCompilerFlags() {
        return this.skipProcessingCompilerFlags;
    }

    public final void setSkipProcessingCompilerFlags(boolean bl) {
        this.skipProcessingCompilerFlags = bl;
    }

    @NotNull
    public final NativeBuildConfigValueBuilder setCommands(@NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName, @NotNull String dryRunOutput) {
        Intrinsics.checkNotNullParameter(buildCommand, (String)"buildCommand");
        Intrinsics.checkNotNullParameter(cleanCommand, (String)"cleanCommand");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)dryRunOutput, (String)"dryRunOutput");
        Collection collection = this.outputs;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new RuntimeException("setCommands should be called once");
        }
        this.extractWorkingDirectoryFromDryRunOutputIfAvailable(dryRunOutput);
        List<BuildStepInfo> list = CommandClassifier.classify(dryRunOutput, this.fileConventions);
        Intrinsics.checkNotNullExpressionValue(list, (String)"classify(dryRunOutput, fileConventions)");
        List<BuildStepInfo> buildSteps = list;
        ListMultimap<String, List<BuildStepInfo>> listMultimap = FlowAnalyzer.analyze(buildSteps);
        Intrinsics.checkNotNullExpressionValue(listMultimap, (String)"analyze(buildSteps)");
        ListMultimap<String, List<BuildStepInfo>> outputs = listMultimap;
        for (Map.Entry entry : outputs.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"outputs.entries()");
            Map.Entry entry2 = entry;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            Map.Entry entry3 = entry;
            boolean bl3 = false;
            List value = (List)entry3.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            this.outputs.add(new Output(key, value, buildCommand, cleanCommand, variantName));
        }
        this.buildTargetsCommand = CollectionsKt.plus((Collection)buildCommand, (Iterable)CollectionsKt.listOf((Object)"{LIST_OF_TARGETS_TO_BUILD}"));
        return this;
    }

    private final void extractWorkingDirectoryFromDryRunOutputIfAvailable(String dryRunOutput) {
        if (StringsKt.contains$default((CharSequence)dryRunOutput, (CharSequence)"make: Entering directory", (boolean)false, (int)2, null)) {
            Regex workingDirPattern = new Regex("^make: Entering directory [`'](.*?)'$", RegexOption.MULTILINE);
            MatchResult matchResult = Regex.find$default((Regex)workingDirPattern, (CharSequence)dryRunOutput, (int)0, (int)2, null);
            if (matchResult == null) {
                return;
            }
            MatchResult match2 = matchResult;
            matchResult = match2.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchResult);
            this.executionRootPath = new File(matchResult.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final NativeBuildConfigValue build() {
        NativeBuildConfigValue nativeBuildConfigValue;
        AutoCloseable autoCloseable = (AutoCloseable)new CompileCommandsEncoder(this.compileCommandsJsonBinFile, 0, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
            boolean bl3 = false;
            this.compileCommandsEncoder = encoder;
            nativeBuildConfigValue = this.buildImpl();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return nativeBuildConfigValue;
    }

    private final NativeBuildConfigValue buildImpl() {
        this.findLibraryNames();
        this.findToolchainNames();
        this.findToolChainCompilers();
        NativeBuildConfigValue config2 = new NativeBuildConfigValue();
        List<Output> $this$sortBy$iv = this.outputs;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Output it = (Output)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getLibraryName());
                    it = (Output)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getLibraryName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
        }
        config2.cleanCommandsComponents = this.generateCleanCommands();
        config2.buildTargetsCommandComponents = this.buildTargetsCommand;
        Object[] objectArray = new File[]{this.androidMk};
        config2.buildFiles = Lists.newArrayList((Object[])objectArray);
        config2.libraries = this.generateLibraries();
        config2.toolchains = this.generateToolchains();
        config2.cFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cFileExtensions);
        config2.cppFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cppFileExtensions);
        return config2;
    }

    private final void findLibraryNames() {
        for (Output output2 : this.outputs) {
            String string = this.fileConventions.getFileParent(output2.getOutputFileName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileConventions.getFileParent(output.outputFileName)");
            String parentFile = string;
            String string2 = this.fileConventions.getFileName(parentFile);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileConventions.getFileName(parentFile)");
            String abi = string2;
            output2.setArtifactName(NdkUtils.getTargetNameFromBuildOutputFileName((String)this.fileConventions.getFileName(output2.getOutputFileName())));
            string2 = StringCompanionObject.INSTANCE;
            String string3 = "%s-%s-%s";
            Object[] objectArray = new Object[]{output2.getArtifactName(), output2.getVariantName(), abi};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            output2.setLibraryName(string4);
        }
    }

    private final void findToolChainCompilers() {
        for (Output output2 : this.outputs) {
            String string;
            Object object;
            String string2;
            String toolchain = output2.getToolchain();
            Set cCompilers = new HashSet();
            Set cppCompilers = new HashSet();
            Map compilerToWeirdExtensions = new HashMap();
            for (BuildStepInfo buildStepInfo : output2.getCommandInputs()) {
                String compilerCommand = buildStepInfo.getCommand().getExecutable();
                String extension = FilesKt.getExtension((File)new File(buildStepInfo.getOnlyInput()));
                if (NativeSourceFileExtensions.C_FILE_EXTENSIONS.contains(extension)) {
                    this.cFileExtensions.add(extension);
                    cCompilers.add(compilerCommand);
                    continue;
                }
                if (NativeSourceFileExtensions.CPP_FILE_EXTENSIONS.contains(extension)) {
                    this.cppFileExtensions.add(extension);
                    cppCompilers.add(compilerCommand);
                    continue;
                }
                Set extensions = (Set)compilerToWeirdExtensions.get(compilerCommand);
                if (extensions == null) {
                    extensions = new HashSet();
                    Map map = compilerToWeirdExtensions;
                    boolean bl = false;
                    map.put(compilerCommand, extensions);
                }
                extensions.add(extension);
            }
            if (cCompilers.size() > 1) {
                throw new RuntimeException("Too many c compilers in toolchain.");
            }
            if (cppCompilers.size() > 1) {
                throw new RuntimeException("Too many cpp compilers in toolchain.");
            }
            String string3 = (String)CollectionsKt.firstOrNull((Iterable)cCompilers);
            if (string3 == null) {
                string2 = null;
            } else {
                object = string3;
                boolean extension = false;
                boolean set = false;
                String it = object;
                boolean bl2 = false;
                if (toolchain != null) {
                    Map<String, String> map = this.toolChainToCCompiler;
                    boolean bl = false;
                    map.put(toolchain, it);
                }
                string2 = object;
            }
            String cCompiler = string2;
            object = (String)CollectionsKt.firstOrNull((Iterable)cppCompilers);
            if (object == null) {
                string = null;
            } else {
                String extension = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = extension;
                boolean bl5 = false;
                if (toolchain != null) {
                    Map<String, String> map = this.toolChainToCppCompiler;
                    boolean bl3 = false;
                    map.put(toolchain, it);
                }
                string = extension;
            }
            String string4 = string;
            for (String compiler : compilerToWeirdExtensions.keySet()) {
                if (Intrinsics.areEqual((Object)compiler, (Object)cCompiler)) {
                    Set set = (Set)compilerToWeirdExtensions.get(compiler);
                    Intrinsics.checkNotNull((Object)set);
                    this.cFileExtensions.addAll(set);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)compiler, (Object)string4)) continue;
                Set set = (Set)compilerToWeirdExtensions.get(compiler);
                Intrinsics.checkNotNull((Object)set);
                this.cppFileExtensions.addAll(set);
            }
        }
    }

    private final String findToolChainName(String outputFileName) {
        return Intrinsics.stringPlus((String)"toolchain-", (Object)this.fileConventions.getFileName(this.fileConventions.getFileParent(outputFileName)));
    }

    private final void findToolchainNames() {
        for (Output output2 : this.outputs) {
            output2.setToolchain(this.findToolChainName(output2.getOutputFileName()));
        }
    }

    private final List<List<String>> generateCleanCommands() {
        Object object = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newHashSet()");
        Set cleanCommands = (Set)object;
        for (Output output2 : this.outputs) {
            cleanCommands.add(output2.getCleanCommand());
        }
        object = Lists.newArrayList((Iterable)cleanCommands);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newArrayList(cleanCommands)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeLibraryValue> generateLibraries() {
        Map librariesMap = new HashMap();
        for (Output output2 : this.outputs) {
            NativeLibraryValue value = new NativeLibraryValue();
            Map map = librariesMap;
            String string = output2.getLibraryName();
            boolean bl = false;
            map.put(string, value);
            value.buildCommandComponents = CollectionsKt.plus((Collection)output2.getBuildCommand(), (Iterable)CollectionsKt.listOf((Object)output2.getOutputFileName()));
            value.abi = this.fileConventions.getFileName(this.fileConventions.getFileParent(output2.getOutputFileName()));
            value.artifactName = output2.getArtifactName();
            value.toolchain = output2.getToolchain();
            value.output = this.fileConventions.toFile(output2.getOutputFileName());
            String workingDirPath = this.executionRootPath.getAbsolutePath();
            for (BuildStepInfo commandInput : output2.getCommandInputs()) {
                CommandLine command = commandInput.getCommand();
                String outputFile = CompileCommandsCodecKt.extractFlagArgument((String)"-o", (String)"--output", command.getEscapedFlags());
                Object object = this.compileCommandsEncoder;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compileCommandsEncoder");
                    throw null;
                }
                CompileCommandsEncoder compileCommandsEncoder = object;
                object = this.fileConventions.toFile(commandInput.getOnlyInput());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fileConventions.toFile(commandInput.onlyInput)");
                Object object2 = object;
                File file = new File(command.getExecutable());
                List list = CompileCommandsCodecKt.stripArgsForIde$default((String)commandInput.getOnlyInput(), command.getEscapedFlags(), null, (int)4, null);
                File file2 = new File(workingDirPath);
                Intrinsics.checkNotNull((Object)outputFile);
                File file3 = new File(outputFile);
                object = output2.getArtifactName();
                Intrinsics.checkNotNull((Object)object);
                compileCommandsEncoder.writeCompileCommand((File)object2, file, list, file2, file3, (String)object);
            }
            if (this.skipProcessingCompilerFlags) continue;
            ArrayList<NativeSourceFileValue> nativeSourceFiles = new ArrayList<NativeSourceFileValue>();
            value.files = nativeSourceFiles;
            for (BuildStepInfo input : output2.getCommandInputs()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                NativeSourceFileValue file = new NativeSourceFileValue();
                nativeSourceFiles.add(file);
                file.src = this.fileConventions.toFile(input.getOnlyInput());
                if (!this.fileConventions.isPathAbsolute(input.getOnlyInput())) {
                    file.src = this.fileConventions.toFile(this.executionRootPath, input.getOnlyInput());
                }
                int n = 0;
                Map rawFlagsLookUpMap = new LinkedHashMap();
                n = 0;
                int n2 = input.getCommand().getRawFlags().size();
                if (n < n2) {
                    do {
                        int i2 = n++;
                        Map map2 = rawFlagsLookUpMap;
                        String string2 = input.getCommand().getEscapedFlags().get(i2);
                        String string3 = input.getCommand().getRawFlags().get(i2);
                        boolean bl2 = false;
                        map2.put(string2, string3);
                    } while (n < n2);
                }
                Iterable iterable = CompileCommandsCodecKt.stripArgsForIde$default((String)input.getOnlyInput(), input.getCommand().getEscapedFlags(), null, (int)4, null);
                NativeSourceFileValue nativeSourceFileValue = file;
                boolean $i$f$map = false;
                void i2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string4 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string5 = (String)rawFlagsLookUpMap.get(it);
                    collection.add(string5);
                }
                collection = (List)destination$iv$iv;
                nativeSourceFileValue.flags = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
        }
        return librariesMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeToolchainValue> generateToolchains() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.outputs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Output output2 = (Output)element$iv$iv;
            boolean bl2 = false;
            if (output2.getToolchain() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set toolchainSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List toolchains = new ArrayList(toolchainSet);
        CollectionsKt.sort((List)toolchains);
        Map toolchainsMap = new HashMap();
        for (String toolchain : toolchains) {
            NativeToolchainValue toolchainValue = new NativeToolchainValue();
            Object object = toolchainsMap;
            boolean bl = false;
            object.put(toolchain, toolchainValue);
            if (this.toolChainToCCompiler.containsKey(toolchain)) {
                object = this.toolChainToCCompiler.get(toolchain);
                Intrinsics.checkNotNull((Object)object);
                toolchainValue.cCompilerExecutable = this.fileConventions.toFile((String)object);
            }
            if (!this.toolChainToCppCompiler.containsKey(toolchain)) continue;
            object = this.toolChainToCppCompiler.get(toolchain);
            Intrinsics.checkNotNull((Object)object);
            toolchainValue.cppCompilerExecutable = this.fileConventions.toFile((String)object);
        }
        return toolchainsMap;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "", "outputFileName", "", "commandInputs", "", "Lcom/android/build/gradle/external/gnumake/BuildStepInfo;", "buildCommand", "cleanCommand", "variantName", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "artifactName", "getArtifactName", "()Ljava/lang/String;", "setArtifactName", "(Ljava/lang/String;)V", "getBuildCommand", "()Ljava/util/List;", "getCleanCommand", "getCommandInputs", "libraryName", "getLibraryName", "setLibraryName", "getOutputFileName", "toolchain", "getToolchain", "setToolchain", "getVariantName", "gradle-core"})
    private static final class Output {
        @NotNull
        private final String outputFileName;
        @NotNull
        private final List<BuildStepInfo> commandInputs;
        @NotNull
        private final List<String> buildCommand;
        @NotNull
        private final List<String> cleanCommand;
        @NotNull
        private final String variantName;
        @Nullable
        private String artifactName;
        @Nullable
        private String libraryName;
        @Nullable
        private String toolchain;

        public Output(@NotNull String outputFileName, @NotNull List<BuildStepInfo> commandInputs, @NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)outputFileName, (String)"outputFileName");
            Intrinsics.checkNotNullParameter(commandInputs, (String)"commandInputs");
            Intrinsics.checkNotNullParameter(buildCommand, (String)"buildCommand");
            Intrinsics.checkNotNullParameter(cleanCommand, (String)"cleanCommand");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            this.outputFileName = outputFileName;
            this.commandInputs = commandInputs;
            this.buildCommand = buildCommand;
            this.cleanCommand = cleanCommand;
            this.variantName = variantName;
        }

        @NotNull
        public final String getOutputFileName() {
            return this.outputFileName;
        }

        @NotNull
        public final List<BuildStepInfo> getCommandInputs() {
            return this.commandInputs;
        }

        @NotNull
        public final List<String> getBuildCommand() {
            return this.buildCommand;
        }

        @NotNull
        public final List<String> getCleanCommand() {
            return this.cleanCommand;
        }

        @NotNull
        public final String getVariantName() {
            return this.variantName;
        }

        @Nullable
        public final String getArtifactName() {
            return this.artifactName;
        }

        public final void setArtifactName(@Nullable String string) {
            this.artifactName = string;
        }

        @Nullable
        public final String getLibraryName() {
            return this.libraryName;
        }

        public final void setLibraryName(@Nullable String string) {
            this.libraryName = string;
        }

        @Nullable
        public final String getToolchain() {
            return this.toolchain;
        }

        public final void setToolchain(@Nullable String string) {
            this.toolchain = string;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Companion;", "", "()V", "generateExtensions", "", "", "extensionSet", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Collection<String> generateExtensions(Set<String> extensionSet) {
            ArrayList arrayList = Lists.newArrayList((Iterable)extensionSet);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(extensionSet)");
            List extensionList = arrayList;
            CollectionsKt.sort((List)extensionList);
            return extensionList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

