/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.EmulatorComponents;
import com.android.build.gradle.internal.PlatformComponents;
import com.android.build.gradle.internal.PlatformToolsComponents;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.build.gradle.internal.SdkType;
import com.android.build.gradle.internal.SupportToolsComponents;
import com.android.build.gradle.internal.SystemImageComponents;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0002:;B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017J\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010\"\u001a\u0004\u0018\u00010\u0007J\b\u0010#\u001a\u0004\u0018\u00010\u0017J\b\u0010$\u001a\u0004\u0018\u00010\u0017J\b\u0010%\u001a\u0004\u0018\u00010\u0017J\u0012\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\b\u0010*\u001a\u0004\u0018\u00010\u0017J\b\u0010+\u001a\u0004\u0018\u00010\u0017J\b\u0010,\u001a\u0004\u0018\u00010\u0017J\b\u0010-\u001a\u0004\u0018\u00010\u0017J\u0010\u0010.\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0019J\b\u00101\u001a\u0004\u0018\u000102J\n\u00103\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0007H\u0002J\u0006\u00107\u001a\u00020\tJ\u0006\u00108\u001a\u000209R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy;", "", "sdkLocationSourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "suppressWarningIfTooNewForVersions", "(Lcom/android/build/gradle/internal/SdkLocationSourceSet;Ljava/lang/String;Lcom/android/repository/Revision;ZLcom/android/builder/errors/IssueReporter;Ljava/lang/String;)V", "components", "Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "getComponents", "()Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "components$delegate", "Lkotlin/Lazy;", "checkBuildToolsRevision", "revision", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getApiVersionsFile", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreForSystemModulesJar", "getCoreLambaStubs", "getEmulatorLibFolder", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getSystemImageLibFolder", "imageHash", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "loadSdkComponents", "targetHash", "buildToolRevision", "loadedSuccessfully", "reset", "", "Companion", "DirectLoadComponents", "gradle-core"})
public final class SdkDirectLoadingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkLocationSourceSet sdkLocationSourceSet;
    @Nullable
    private final String platformTargetHashSupplier;
    @Nullable
    private final Revision buildToolRevisionSupplier;
    private final boolean useAndroidX;
    @NotNull
    private final IssueReporter issueReporter;
    @Nullable
    private final String suppressWarningIfTooNewForVersions;
    @NotNull
    private final Lazy components$delegate;
    @NotNull
    private static final ConcurrentHashMap<Revision, Optional<BuildToolInfo>> buildToolsCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, Optional<PlatformComponents>> platformCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, Optional<SystemImageComponents>> systemImageCache = new ConcurrentHashMap();

    public SdkDirectLoadingStrategy(@NotNull SdkLocationSourceSet sdkLocationSourceSet, @Nullable String platformTargetHashSupplier, @Nullable Revision buildToolRevisionSupplier, boolean useAndroidX, @NotNull IssueReporter issueReporter2, @Nullable String suppressWarningIfTooNewForVersions) {
        Intrinsics.checkNotNullParameter((Object)sdkLocationSourceSet, (String)"sdkLocationSourceSet");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
        this.issueReporter = issueReporter2;
        this.suppressWarningIfTooNewForVersions = suppressWarningIfTooNewForVersions;
        this.components$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectLoadComponents>(this){
            final /* synthetic */ SdkDirectLoadingStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final DirectLoadComponents invoke() {
                return SdkDirectLoadingStrategy.access$init(this.this$0);
            }
        }));
    }

    private final DirectLoadComponents getComponents() {
        Lazy lazy = this.components$delegate;
        boolean bl = false;
        return (DirectLoadComponents)lazy.getValue();
    }

    private final synchronized DirectLoadComponents init() {
        String string = this.platformTargetHashSupplier;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String targetHash = string;
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        Revision revision = this.buildToolRevisionSupplier;
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy2 = sdkDirectLoadingStrategy;
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy3 = sdkDirectLoadingStrategy2;
            String string4 = string3;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        Revision buildToolRevision = sdkDirectLoadingStrategy.checkBuildToolsRevision(revision);
        return this.loadSdkComponents(targetHash, buildToolRevision);
    }

    private final DirectLoadComponents loadSdkComponents(String targetHash, Revision buildToolRevision) {
        boolean bl;
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
        if (sdkLocation.getType() == SdkType.MISSING) {
            return null;
        }
        File file = sdkLocation.getDirectory();
        Intrinsics.checkNotNull((Object)file);
        File sdkDirectory2 = file;
        PlatformToolsComponents platformTools = PlatformToolsComponents.Companion.build$gradle_core(sdkDirectory2);
        SupportToolsComponents supportTools = SupportToolsComponents.Companion.build$gradle_core(sdkDirectory2, targetHash);
        ConcurrentMap $this$getOrPut$iv = buildToolsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(buildToolRevision);
        if (object == null) {
            boolean bl2 = false;
            Optional<BuildToolInfo> optional = Optional.ofNullable(SdkParsingUtilsKt.buildBuildTools(sdkDirectory2, buildToolRevision));
            boolean bl3 = false;
            bl = false;
            Optional<BuildToolInfo> default$iv = optional;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(buildToolRevision, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BuildToolInfo buildTools = ((Optional)object).orElse(null);
        ConcurrentMap $this$getOrPut$iv2 = platformCache;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv2.get(targetHash);
        if (object2 == null) {
            boolean bl5 = false;
            Optional<PlatformComponents> optional = Optional.ofNullable(PlatformComponents.Companion.build$gradle_core(sdkDirectory2, targetHash));
            bl = false;
            boolean bl6 = false;
            Optional<PlatformComponents> default$iv = optional;
            boolean bl7 = false;
            object2 = $this$getOrPut$iv2.putIfAbsent(targetHash, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        PlatformComponents platform = ((Optional)object2).orElse(null);
        EmulatorComponents emulator = EmulatorComponents.Companion.build$gradle_core(sdkDirectory2);
        if (platformTools == null || supportTools == null || buildTools == null || platform == null) {
            return null;
        }
        SdkParsingUtilsKt.warnIfCompileSdkTooNew(platform.getTargetPlatformVersion$gradle_core(), this.issueReporter, this.suppressWarningIfTooNewForVersions);
        return new DirectLoadComponents(sdkDirectory2, platformTools, supportTools, buildTools, platform, emulator);
    }

    private final Revision checkBuildToolsRevision(Revision revision) {
        if (revision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.";
            Object[] objectArray = new Object[]{revision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.BUILD_TOOLS_TOO_LOW, (String)string2, (String)ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString(), null, (int)8, null);
            stringCompanionObject = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
            Intrinsics.checkNotNullExpressionValue((Object)stringCompanionObject, (String)"DEFAULT_BUILD_TOOLS_REVISION");
            return stringCompanionObject;
        }
        return revision;
    }

    public final boolean loadedSuccessfully() {
        return this.getComponents() != null;
    }

    @Nullable
    public final File getAdbExecutable() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            PlatformToolsComponents platformToolsComponents = directLoadComponents.getPlatformTools$gradle_core();
            file = platformToolsComponents.getAdbExecutable$gradle_core();
        }
        return file;
    }

    @Nullable
    public final File getAnnotationsJar() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            SupportToolsComponents supportToolsComponents = directLoadComponents.getSupportTools$gradle_core();
            file = supportToolsComponents.getAnnotationsJar$gradle_core();
        }
        return file;
    }

    @Nullable
    public final File getAidlFramework() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            file = platformComponents.getAidlFramework$gradle_core();
        }
        return file;
    }

    @Nullable
    public final File getAndroidJar() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            file = platformComponents.getAndroidJar$gradle_core();
        }
        return file;
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        List<OptionalLibrary> list;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            list = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            list = platformComponents.getAdditionalLibraries$gradle_core();
        }
        return list;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        List<OptionalLibrary> list;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            list = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            list = platformComponents.getOptionalLibraries$gradle_core();
        }
        return list;
    }

    @Nullable
    public final File getApiVersionsFile() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            file = platformComponents.getApiVersionsFile();
        }
        return file;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        AndroidVersion androidVersion;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            androidVersion = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            androidVersion = platformComponents.getTargetPlatformVersion$gradle_core();
        }
        return androidVersion;
    }

    @Nullable
    public final List<File> getTargetBootClasspath() {
        List<File> list;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            list = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            list = platformComponents.getTargetBootClasspath$gradle_core();
        }
        return list;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        DirectLoadComponents directLoadComponents = this.getComponents();
        return directLoadComponents == null ? null : directLoadComponents.getBuildToolInfo$gradle_core();
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo == null ? null : buildToolInfo.getRevision();
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component2) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component2));
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        }
        return file;
    }

    @Nullable
    public final File getSystemImageLibFolder(@NotNull String imageHash) {
        SystemImageComponents systemImageComponents;
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        ConcurrentMap $this$getOrPut$iv = systemImageCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(imageHash);
        if (object == null) {
            boolean bl = false;
            DirectLoadComponents directLoadComponents = this.getComponents();
            Optional<SystemImageComponents> optional = Optional.ofNullable(SystemImageComponents.Companion.build$gradle_core(directLoadComponents == null ? null : directLoadComponents.getSdkDirectory$gradle_core(), imageHash));
            boolean bl2 = false;
            boolean bl3 = false;
            Optional<SystemImageComponents> default$iv = optional;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(imageHash, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (systemImageComponents = (SystemImageComponents)((Optional)object).orElse(null)) == null ? null : systemImageComponents.getSystemImageDir$gradle_core();
    }

    @Nullable
    public final File getEmulatorLibFolder() {
        EmulatorComponents emulatorComponents;
        DirectLoadComponents directLoadComponents = this.getComponents();
        return directLoadComponents == null ? null : ((emulatorComponents = directLoadComponents.getEmulator$gradle_core()) == null ? null : emulatorComponents.getEmulatorDir$gradle_core());
    }

    @Nullable
    public final File getCoreForSystemModulesJar() {
        File file;
        DirectLoadComponents directLoadComponents = this.getComponents();
        if (directLoadComponents == null) {
            file = null;
        } else {
            PlatformComponents platformComponents = directLoadComponents.getPlatform$gradle_core();
            file = platformComponents.getCoreForSystemModulesJar$gradle_core();
        }
        return file;
    }

    public final void reset() {
        Companion.clearCaches();
    }

    public static final /* synthetic */ DirectLoadComponents access$init(SdkDirectLoadingStrategy $this) {
        return $this.init();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$Companion;", "", "()V", "buildToolsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/repository/Revision;", "Ljava/util/Optional;", "Lcom/android/sdklib/BuildToolInfo;", "platformCache", "", "Lcom/android/build/gradle/internal/PlatformComponents;", "systemImageCache", "Lcom/android/build/gradle/internal/SystemImageComponents;", "clearCaches", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final synchronized void clearCaches() {
            buildToolsCache.clear();
            platformCache.clear();
            systemImageCache.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "", "sdkDirectory", "Ljava/io/File;", "platformTools", "Lcom/android/build/gradle/internal/PlatformToolsComponents;", "supportTools", "Lcom/android/build/gradle/internal/SupportToolsComponents;", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "platform", "Lcom/android/build/gradle/internal/PlatformComponents;", "emulator", "Lcom/android/build/gradle/internal/EmulatorComponents;", "(Ljava/io/File;Lcom/android/build/gradle/internal/PlatformToolsComponents;Lcom/android/build/gradle/internal/SupportToolsComponents;Lcom/android/sdklib/BuildToolInfo;Lcom/android/build/gradle/internal/PlatformComponents;Lcom/android/build/gradle/internal/EmulatorComponents;)V", "getBuildToolInfo$gradle_core", "()Lcom/android/sdklib/BuildToolInfo;", "getEmulator$gradle_core", "()Lcom/android/build/gradle/internal/EmulatorComponents;", "getPlatform$gradle_core", "()Lcom/android/build/gradle/internal/PlatformComponents;", "getPlatformTools$gradle_core", "()Lcom/android/build/gradle/internal/PlatformToolsComponents;", "getSdkDirectory$gradle_core", "()Ljava/io/File;", "getSupportTools$gradle_core", "()Lcom/android/build/gradle/internal/SupportToolsComponents;", "gradle-core"})
    private static final class DirectLoadComponents {
        @NotNull
        private final File sdkDirectory;
        @NotNull
        private final PlatformToolsComponents platformTools;
        @NotNull
        private final SupportToolsComponents supportTools;
        @NotNull
        private final BuildToolInfo buildToolInfo;
        @NotNull
        private final PlatformComponents platform;
        @Nullable
        private final EmulatorComponents emulator;

        public DirectLoadComponents(@NotNull File sdkDirectory2, @NotNull PlatformToolsComponents platformTools, @NotNull SupportToolsComponents supportTools, @NotNull BuildToolInfo buildToolInfo, @NotNull PlatformComponents platform, @Nullable EmulatorComponents emulator) {
            Intrinsics.checkNotNullParameter((Object)sdkDirectory2, (String)"sdkDirectory");
            Intrinsics.checkNotNullParameter((Object)platformTools, (String)"platformTools");
            Intrinsics.checkNotNullParameter((Object)supportTools, (String)"supportTools");
            Intrinsics.checkNotNullParameter((Object)buildToolInfo, (String)"buildToolInfo");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            this.sdkDirectory = sdkDirectory2;
            this.platformTools = platformTools;
            this.supportTools = supportTools;
            this.buildToolInfo = buildToolInfo;
            this.platform = platform;
            this.emulator = emulator;
        }

        @NotNull
        public final File getSdkDirectory$gradle_core() {
            return this.sdkDirectory;
        }

        @NotNull
        public final PlatformToolsComponents getPlatformTools$gradle_core() {
            return this.platformTools;
        }

        @NotNull
        public final SupportToolsComponents getSupportTools$gradle_core() {
            return this.supportTools;
        }

        @NotNull
        public final BuildToolInfo getBuildToolInfo$gradle_core() {
            return this.buildToolInfo;
        }

        @NotNull
        public final PlatformComponents getPlatform$gradle_core() {
            return this.platform;
        }

        @Nullable
        public final EmulatorComponents getEmulator$gradle_core() {
            return this.emulator;
        }
    }
}

