/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;

public class FeatureSplitDeclaration {
    @VisibleForTesting
    static final String PERSISTED_FILE_NAME = "feature-split.json";
    private final String modulePath;
    private final String namespace;

    public FeatureSplitDeclaration(String modulePath, String namespace2) {
        this.modulePath = modulePath;
        this.namespace = namespace2;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void save(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, PERSISTED_FILE_NAME);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson2 = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson2.toJson((Object)this));
    }

    public static FeatureSplitDeclaration load(FileCollection input) throws IOException {
        File persistedFile = FeatureSplitDeclaration.getOutputFile(input);
        if (persistedFile == null) {
            throw new FileNotFoundException("No feature split declaration present");
        }
        return FeatureSplitDeclaration.load(persistedFile);
    }

    public static FeatureSplitDeclaration load(File input) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson2 = gsonBuilder.create();
        try (FileReader fileReader = new FileReader(input);){
            FeatureSplitDeclaration featureSplitDeclaration = (FeatureSplitDeclaration)gson2.fromJson((Reader)fileReader, FeatureSplitDeclaration.class);
            return featureSplitDeclaration;
        }
    }

    private static File getOutputFile(FileCollection input) {
        for (File file : input.getAsFileTree().getFiles()) {
            if (!file.getName().equals(PERSISTED_FILE_NAME)) continue;
            return file;
        }
        return null;
    }

    public static File getOutputFile(File directory2) {
        return new File(directory2, PERSISTED_FILE_NAME);
    }
}

