/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.process.ProcessException;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class InstallVariantTask
extends NonIncrementalTask {
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private String variantName;
    private Set<String> supportedAbis;
    private AndroidVersion minSdkVersion;

    @Inject
    public InstallVariantTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Install task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getBuildTools().adbExecutable(), this.getTimeOutInMs(), (ILogger)iLogger, System.getenv("ANDROID_SERIAL"));
        deviceProvider.use(() -> {
            BuiltArtifactsImpl builtArtifacts = new BuiltArtifactsLoaderImpl().load((Directory)this.getApkDirectory().get());
            InstallVariantTask.install(this.getProjectName(), this.variantName, deviceProvider, this.minSdkVersion, builtArtifacts, this.supportedAbis, this.getInstallOptions(), this.getTimeOutInMs(), this.getLogger());
            return null;
        });
    }

    static void install(String projectName, String variantName, DeviceProvider deviceProvider, AndroidVersion minSkdVersion, BuiltArtifactsImpl builtArtifacts, Set<String> supportedAbis2, Collection<String> installOptions, int timeOutInMs, Logger logger) throws DeviceException, ProcessException {
        LoggerWrapper iLogger = new LoggerWrapper(logger);
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (AndroidVersion)minSkdVersion, (ILogger)iLogger, (String)projectName, (String)variantName)) continue;
            List<File> apkFiles = BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput((DeviceConfigProvider)new DeviceConfigProviderImpl(device), builtArtifacts, supportedAbis2);
            if (apkFiles.isEmpty()) {
                logger.lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), projectName, variantName, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                continue;
            }
            logger.lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList(apkFiles), device.getName(), projectName, variantName});
            Collection extraArgs = (Collection)MoreObjects.firstNonNull(installOptions, (Object)ImmutableList.of());
            if (apkFiles.size() > 1) {
                device.installPackages(apkFiles, extraArgs, timeOutInMs, (ILogger)iLogger);
                ++successfulInstallCount;
                continue;
            }
            device.installPackage(apkFiles.get(0), extraArgs, timeOutInMs, (ILogger)iLogger);
            ++successfulInstallCount;
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getApkDirectory();

    @Nested
    public abstract BuildToolsExecutableInput getBuildTools();

    public static class CreationAction
    extends VariantTaskCreationAction<InstallVariantTask, ApkCreationConfig> {
        public CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void configure(InstallVariantTask task) {
            super.configure(task);
            task.variantName = ((ApkCreationConfig)this.creationConfig).getBaseName();
            task.supportedAbis = ((ApkCreationConfig)this.creationConfig).getVariantDslInfo().getSupportedAbis();
            task.minSdkVersion = VariantApiExtensionsKt.toSharedAndroidVersion(((ApkCreationConfig)this.creationConfig).getMinSdkVersion());
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription() + ".");
            task.setGroup("Install");
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(SingleArtifact.APK.INSTANCE, task.getApkDirectory());
            task.setTimeOutInMs(((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            task.setInstallOptions(((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            SdkComponentsKt.initialize(task.getBuildTools(), this.creationConfig);
        }

        @Override
        public void handleProvider(TaskProvider<InstallVariantTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }
    }
}

