/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;

class ReportingPlugin
implements Plugin<Project> {
    private TestOptions extension;

    public void apply(Project project2) {
        project2.evaluationDependsOnChildren();
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project2).execute().get()).getProjectOptions();
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions), project2.getLogger());
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(syncIssueHandler, projectOptions, project2.getPath());
        LintFromMaven lintFromMaven = LintFromMaven.from(project2, projectOptions, syncIssueHandler);
        ProjectServices projectServices2 = new ProjectServices(syncIssueHandler, deprecationReporter, project2.getObjects(), project2.getLogger(), project2.getProviders(), project2.getLayout(), projectOptions, project2.getGradle().getSharedServices(), lintFromMaven, null, project2.getGradle().getStartParameter().getMaxWorkerCount(), new ProjectInfo(project2), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)project2).file(arg_0)));
        DslServicesImpl dslServices2 = new DslServicesImpl(projectServices2, (Provider<SdkComponentsBuildService>)project2.getProviders().provider(() -> null));
        this.extension = (TestOptions)project2.getExtensions().create("android", TestOptions.class, new Object[]{dslServices2});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project2.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.getResultsDir().set(project2.provider(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return (Directory)project2.getLayout().getBuildDirectory().dir("androidTest-results").get();
            }
            return project2.getLayout().getProjectDirectory().dir(resultsDir);
        }));
        mergeReportsTask.getReportsDir().set(project2.provider(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return (Directory)project2.getLayout().getBuildDirectory().dir(FileUtils.join((String[])new String[]{"reports", "androidTests"})).get();
            }
            return project2.getLayout().getProjectDirectory().dir(reportsDir);
        }));
        project2.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project2.getGradle().getStartParameter().isContinueOnFailure()) {
            project2.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

