/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.BaseExtension;
import com.google.common.base.Preconditions;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePluginConvention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/scope/ProjectInfo;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "getBuildDir", "Ljava/io/File;", "getExtension", "Lcom/android/build/gradle/BaseExtension;", "getIntermediatesDir", "getJacocoAgent", "getJacocoAgentOutputDirectory", "getOutputsDir", "getProject", "getProjectBaseName", "", "getReportsDir", "getTestReportFolder", "getTestResultsFolder", "getTmpFolder", "gradle-core"})
public final class ProjectInfo {
    @NotNull
    private final Project project;

    public ProjectInfo(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final String getProjectBaseName() {
        BasePluginConvention convention = (BasePluginConvention)Preconditions.checkNotNull((Object)this.project.getConvention().findPlugin(BasePluginConvention.class));
        Intrinsics.checkNotNull((Object)convention);
        String string = convention.getArchivesBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"!!.archivesBaseName");
        return string;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getBuildDir() {
        File file = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        return file;
    }

    @Nullable
    public final File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    @NotNull
    public final File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    @Nullable
    public final File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    @NotNull
    public final File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    @NotNull
    public final File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    @NotNull
    public final File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    @NotNull
    public final File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    @NotNull
    public final File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    @NotNull
    public final BaseExtension getExtension() {
        Object object = this.getProject().getExtensions().getByName("android");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        }
        return (BaseExtension)object;
    }
}

