/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultsFlavorComparator;
import com.android.build.gradle.internal.variant.DefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.DefaultFlavorComparator;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.builder.errors.IssueReporter;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001Be\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\t\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"H\u0002R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R,\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/variant/VariantModelImpl;", "Lcom/android/build/gradle/internal/variant/VariantModel;", "inputs", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "Lcom/android/build/gradle/internal/dsl/BuildType;", "Lcom/android/build/gradle/internal/dsl/ProductFlavor;", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "testBuilderTypeProvider", "Lkotlin/Function0;", "", "variantProvider", "", "Lcom/android/build/api/variant/impl/VariantImpl;", "testComponentProvider", "Lcom/android/build/api/component/impl/TestComponentImpl;", "issueHandler", "Lcom/android/builder/errors/IssueReporter;", "(Lcom/android/build/gradle/internal/variant/VariantInputModel;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/android/builder/errors/IssueReporter;)V", "defaultVariant", "getDefaultVariant", "()Ljava/lang/String;", "getInputs", "()Lcom/android/build/gradle/internal/variant/VariantInputModel;", "testComponents", "getTestComponents", "()Ljava/util/List;", "variants", "getVariants", "computeDefaultVariant", "finalizeDefaultVariantDsl", "", "getBuildAuthorSpecifiedDefaultBuildType", "getBuildAuthorSpecifiedDefaultFlavors", "", "gradle-core"})
public final class VariantModelImpl
implements VariantModel {
    @NotNull
    private final VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> inputs;
    @NotNull
    private final Function0<String> testBuilderTypeProvider;
    @NotNull
    private final Function0<List<VariantImpl>> variantProvider;
    @NotNull
    private final Function0<List<TestComponentImpl>> testComponentProvider;
    @NotNull
    private final IssueReporter issueHandler;

    public VariantModelImpl(@NotNull VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> inputs, @NotNull Function0<String> testBuilderTypeProvider, @NotNull Function0<? extends List<? extends VariantImpl>> variantProvider, @NotNull Function0<? extends List<? extends TestComponentImpl>> testComponentProvider, @NotNull IssueReporter issueHandler) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(testBuilderTypeProvider, (String)"testBuilderTypeProvider");
        Intrinsics.checkNotNullParameter(variantProvider, (String)"variantProvider");
        Intrinsics.checkNotNullParameter(testComponentProvider, (String)"testComponentProvider");
        Intrinsics.checkNotNullParameter((Object)issueHandler, (String)"issueHandler");
        this.inputs = inputs;
        this.testBuilderTypeProvider = testBuilderTypeProvider;
        this.variantProvider = variantProvider;
        this.testComponentProvider = testComponentProvider;
        this.issueHandler = issueHandler;
    }

    @Override
    @NotNull
    public VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public List<VariantImpl> getVariants() {
        return (List)this.variantProvider.invoke();
    }

    @Override
    @NotNull
    public List<TestComponentImpl> getTestComponents() {
        return (List)this.testComponentProvider.invoke();
    }

    @Override
    @Nullable
    public String getDefaultVariant() {
        return this.computeDefaultVariant();
    }

    private final String computeDefaultVariant() {
        VariantImpl defaultComponent;
        this.finalizeDefaultVariantDsl();
        if (this.getVariants().isEmpty()) {
            return null;
        }
        String chosenBuildType = this.getBuildAuthorSpecifiedDefaultBuildType();
        Map<String, String> chosenFlavors = this.getBuildAuthorSpecifiedDefaultFlavors();
        String string = (String)this.testBuilderTypeProvider.invoke();
        String fallbackDefaultBuildType = string == null ? "debug" : string;
        Comparator comparator = new BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType).thenComparing(new BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors)).thenComparing(new DefaultBuildTypeComparator(fallbackDefaultBuildType)).thenComparing(new DefaultFlavorComparator());
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType)\n                .thenComparing(BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors))\n                .thenComparing(DefaultBuildTypeComparator(fallbackDefaultBuildType))\n                .thenComparing(DefaultFlavorComparator())");
        Comparator preferredDefaultVariantScopeComparator = comparator;
        VariantImpl variantImpl = defaultComponent = (VariantImpl)CollectionsKt.minWith((Iterable)this.getVariants(), preferredDefaultVariantScopeComparator);
        return variantImpl == null ? null : variantImpl.getName();
    }

    private final void finalizeDefaultVariantDsl() {
        for (BuildTypeData<BuildType> buildTypeData : this.getInputs().getBuildTypes().values()) {
            buildTypeData.getBuildType().getIsDefault().finalizeValue();
        }
        for (ProductFlavorData productFlavorData : this.getInputs().getProductFlavors().values()) {
            ((ProductFlavor)productFlavorData.getProductFlavor()).getIsDefault().finalizeValue();
        }
    }

    private final String getBuildAuthorSpecifiedDefaultBuildType() {
        List buildTypesMarkedAsDefault = new ArrayList(1);
        for (BuildTypeData<BuildType> buildType : this.getInputs().getBuildTypes().values()) {
            if (!buildType.getBuildType().isDefault()) continue;
            buildTypesMarkedAsDefault.add(buildType.getBuildType().getName());
        }
        CollectionsKt.sort((List)buildTypesMarkedAsDefault);
        if (buildTypesMarkedAsDefault.size() > 1) {
            IssueReporter.reportWarning$default((IssueReporter)this.issueHandler, (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_BUILD_TYPE_DEFAULT, (String)("Ambiguous default build type: '" + Joiner.on((String)"', '").join((Iterable)buildTypesMarkedAsDefault) + "'.\nPlease only set `isDefault = true` for one build type."), (String)Joiner.on((char)',').join((Iterable)buildTypesMarkedAsDefault), null, (int)8, null);
        }
        return buildTypesMarkedAsDefault.isEmpty() ? (String)null : (String)buildTypesMarkedAsDefault.get(0);
    }

    private final Map<String, String> getBuildAuthorSpecifiedDefaultFlavors() {
        Object object;
        ArrayListMultimap userDefaults = ArrayListMultimap.create();
        for (ProductFlavorData<ProductFlavor> flavor : this.getInputs().getProductFlavors().values()) {
            ProductFlavor productFlavor = flavor.getProductFlavor();
            String dimension = productFlavor.getDimension();
            object = productFlavor.getIsDefault().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"productFlavor.getIsDefault().get()");
            if (!((Boolean)object).booleanValue()) continue;
            userDefaults.put((Object)dimension, (Object)productFlavor.getName());
        }
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (String dimension : userDefaults.keySet()) {
            List userDefault = userDefaults.get((Object)dimension);
            Intrinsics.checkNotNullExpressionValue((Object)userDefault, (String)"userDefault");
            CollectionsKt.sort((List)userDefault);
            object = userDefault;
            boolean bl = false;
            if (!object.isEmpty()) {
                defaults.put((Object)dimension, userDefault.get(0));
            }
            if (userDefault.size() <= 1) continue;
            IssueReporter.reportWarning$default((IssueReporter)this.issueHandler, (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_PRODUCT_FLAVOR_DEFAULT, (String)("Ambiguous default product flavors for flavor dimension '" + dimension + "': '" + Joiner.on((String)"', '").join((Iterable)userDefault) + "'.\nPlease only set `isDefault = true` for one product flavor in each flavor dimension."), (String)dimension, null, (int)8, null);
        }
        ImmutableMap immutableMap = defaults.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"defaults.build()");
        return (Map)immutableMap;
    }
}

