/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.AnnotationProcessorImpl;
import com.android.build.api.variant.AnnotationProcessor;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.JdkImageTransformKt;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.decorator.LockableList;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.tasks.CommandLineArgumentProviderAdapter;
import com.android.build.gradle.tasks.JdkImageInput;
import com.android.build.gradle.tasks.SerializableArtifact;
import com.android.builder.errors.IssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.wireless.android.sdk.stats.AnnotationProcessorInfo;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u001a.\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u001a\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a2\u0010\u0015\u001a\u00020\u00062\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u001c\u001a\u00020\u0006*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u001a\u0010 \u001a\u00020\u0006*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001d\u001a\u0012\u0010\"\u001a\u00020\u0006*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"ANNOTATION_PROCESSORS_INDICATOR_FILE", "", "DEFAULT_INCREMENTAL_COMPILATION", "", "INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE", "checkSdkCompatibility", "", "compileSdkVersion", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "detectAnnotationProcessors", "", "Lcom/android/build/gradle/tasks/SerializableArtifact;", "artifacts", "", "apOptionClassNames", "", "processorClasspath", "readAnnotationProcessorsFromJsonFile", "processorListFile", "Ljava/io/File;", "recordAnnotationProcessorsForAnalytics", "processors", "projectPath", "variantName", "analyticService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "writeAnnotationProcessorsToJsonFile", "configureAnnotationProcessorPath", "Lorg/gradle/api/tasks/compile/JavaCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "configureProperties", "task", "configurePropertiesForAnnotationProcessing", "gradle-core"})
@JvmName(name="JavaCompileUtils")
public final class JavaCompileUtils {
    @NotNull
    public static final String ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/services/javax.annotation.processing.Processor";
    @NotNull
    public static final String INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/gradle/incremental.annotation.processors";
    public static final boolean DEFAULT_INCREMENTAL_COMPILATION = true;

    public static final void configureProperties(@NotNull JavaCompile $this$configureProperties, @NotNull ComponentCreationConfig creationConfig, @NotNull JavaCompile task) {
        Intrinsics.checkNotNullParameter((Object)$this$configureProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        com.android.build.api.dsl.CompileOptions compileOptions = creationConfig.getGlobal().getCompileOptions();
        if (compileOptions.getSourceCompatibility().isJava9Compatible()) {
            JavaCompileUtils.checkSdkCompatibility(creationConfig.getGlobal().getCompileSdkHashString(), creationConfig.getServices().getIssueReporter());
            Object object = task.getProject().getConfigurations().findByName("androidJdkImage");
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                boolean bl3 = false;
                String string = "The androidJdkImage configuration must exist for Java 9+ sources.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FileCollection jdkImage = JdkImageTransformKt.getJdkImageFromTransform(creationConfig.getServices().getProjectInfo().getProject(), (JavaCompiler)task.getJavaCompiler().getOrNull());
            $this$configureProperties.getOptions().getCompilerArgumentProviders().add(new JdkImageInput(jdkImage));
            $this$configureProperties.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath(), creationConfig.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, null)};
            $this$configureProperties.setClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
        } else {
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath()};
            $this$configureProperties.getOptions().setBootstrapClasspath((FileCollection)task.getProject().files(objectArray));
            $this$configureProperties.setClasspath(creationConfig.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, null));
        }
        $this$configureProperties.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        $this$configureProperties.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
        $this$configureProperties.getOptions().setEncoding(compileOptions.getEncoding());
    }

    public static final void configurePropertiesForAnnotationProcessing(@NotNull JavaCompile $this$configurePropertiesForAnnotationProcessing, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configurePropertiesForAnnotationProcessing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        AnnotationProcessor processorOptions = creationConfig.getJavaCompilation().getAnnotationProcessor();
        CompileOptions compileOptions = $this$configurePropertiesForAnnotationProcessing.getOptions();
        JavaCompileUtils.configureAnnotationProcessorPath($this$configurePropertiesForAnnotationProcessing, creationConfig);
        compileOptions.getCompilerArgumentProviders().add(new CommandLineArgumentProviderAdapter(((AnnotationProcessorImpl)processorOptions).getFinalListOfClassNames(), (Provider<Map<String, String>>)((Provider)processorOptions.getArguments())));
        List list = ((AnnotationProcessorImpl)processorOptions).getArgumentProviders();
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        ((LockableList)it).lock();
        compileOptions.getCompilerArgumentProviders().addAll(it);
    }

    public static final void configureAnnotationProcessorPath(@NotNull JavaCompile $this$configureAnnotationProcessorPath, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configureAnnotationProcessorPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        FileCollection projectJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAR, null, 8, null);
        FileCollection externalJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.PROCESSED_JAR, null, 8, null);
        $this$configureAnnotationProcessorPath.getOptions().setAnnotationProcessorPath(projectJars.plus(externalJars));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Boolean> detectAnnotationProcessors(@NotNull List<String> apOptionClassNames, @NotNull Collection<SerializableArtifact> processorClasspath) {
        Intrinsics.checkNotNullParameter(apOptionClassNames, (String)"apOptionClassNames");
        Intrinsics.checkNotNullParameter(processorClasspath, (String)"processorClasspath");
        boolean bl = false;
        Map processors = new LinkedHashMap();
        if (!apOptionClassNames.isEmpty()) {
            for (String processor22 : apOptionClassNames) {
                Map map = processors;
                Boolean bl2 = false;
                boolean bl3 = false;
                map.put(processor22, bl2);
            }
        } else {
            Map map;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            boolean processor22 = false;
            Map processorArtifacts = new LinkedHashMap();
            processorArtifacts.putAll(JavaCompileUtils.detectAnnotationProcessors(processorClasspath));
            Map processor22 = processorArtifacts;
            Map map2 = processors;
            boolean $i$f$mapKeys = false;
            void var6_12 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv;
                boolean bl4 = false;
                String string = ((SerializableArtifact)it.getKey()).getDisplayName();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = string;
                Map map3 = map;
                boolean bl5 = false;
                entry = it$iv$iv.getValue();
                map3.put(string2, entry);
            }
            map = destination$iv$iv;
            map2.putAll(map);
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<SerializableArtifact, Boolean> detectAnnotationProcessors(@NotNull Collection<SerializableArtifact> artifacts2) {
        Intrinsics.checkNotNullParameter(artifacts2, (String)"artifacts");
        boolean bl = false;
        Map processors = new LinkedHashMap();
        for (SerializableArtifact artifact : artifacts2) {
            boolean bl2;
            Object object;
            File artifactFile = artifact.getFile();
            if (artifactFile.isDirectory()) {
                if (!new File(artifactFile, ANNOTATION_PROCESSORS_INDICATOR_FILE).exists()) continue;
                object = processors;
                Boolean bl3 = new File(artifactFile, INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE).exists();
                bl2 = false;
                object.put(artifact, bl3);
                continue;
            }
            if (!artifactFile.isFile()) continue;
            try {
                object = new JarFile(artifactFile);
                boolean bl4 = false;
                bl2 = false;
                Throwable throwable = null;
                try {
                    JarFile jarFile = (JarFile)object;
                    boolean bl5 = false;
                    if (jarFile.getJarEntry(ANNOTATION_PROCESSORS_INDICATOR_FILE) != null) {
                        Map map = processors;
                        Boolean bl6 = jarFile.getJarEntry(INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE) != null;
                        boolean bl7 = false;
                        map.put(artifact, bl6);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {}
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeAnnotationProcessorsToJsonFile(@NotNull Map<String, Boolean> processors, @NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            FileUtils.deleteIfExists((File)processorListFile);
            Closeable closeable = new FileWriter(processorListFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl3 = false;
                gson2.toJson(processors, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, Boolean> readAnnotationProcessorsFromJsonFile(@NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            Closeable closeable = new FileReader(processorListFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl3 = false;
                Object object = gson2.fromJson((Reader)reader, new TypeToken<Map<String, ? extends Boolean>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(reader, ob\u2026>() {\n            }.type)");
                Map map = (Map)object;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final void recordAnnotationProcessorsForAnalytics(@NotNull Map<String, Boolean> processors, @NotNull String projectPath, @NotNull String variantName, @NotNull AnalyticsService analyticService) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)analyticService, (String)"analyticService");
        GradleBuildVariant.Builder variant2 = analyticService.getVariantBuilder(projectPath, variantName);
        for (Map.Entry<String, Boolean> processor : processors.entrySet()) {
            AnnotationProcessorInfo.Builder builder = AnnotationProcessorInfo.newBuilder();
            builder.setSpec(processor.getKey());
            builder.setIsIncremental(processor.getValue().booleanValue());
            GradleBuildVariant.Builder builder2 = variant2;
            if (builder2 == null) continue;
            builder2.addAnnotationProcessors(builder);
        }
        GradleBuildVariant.Builder builder = variant2;
        if (builder != null) {
            builder.setIsAnnotationProcessingIncremental(!processors.values().contains(false));
        }
    }

    private static final void checkSdkCompatibility(String compileSdkVersion, IssueReporter issueReporter2) {
        String string = compileSdkVersion;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)it);
        Intrinsics.checkNotNull((Object)androidVersion);
        if (androidVersion.getFeatureLevel() < 30) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to compile Java 9+ source, please set compileSdkVersion to 30 or above", null, null, (int)12, null);
        }
    }
}

