/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.gradle.internal.res.namespaced.NamespaceRewriterKt;
import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.io.NonClosingStreams;
import com.android.resources.NamespaceReferenceRewriter;
import com.android.resources.ResourceType;
import com.android.utils.PositionXmlParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002_`B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+2\u0006\u0010,\u001a\u00020-H\u0007J \u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u000fH\u0002J\u001e\u00103\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206J\u0016\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aJ\u0010\u00107\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0002JD\u0010;\u001a\u00020\r2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u00020\u00012!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b?\u0012\b\b\u0014\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\r0>H\u0082\bJ\u0016\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u000206J\u001e\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u0002062\u0006\u0010<\u001a\u00020\u0001J\u0018\u0010F\u001a\u00020\r2\u0006\u00102\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010G\u001a\u00020\r2\u0006\u00102\u001a\u00020\u000fH\u0002J\u0010\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\u000fH\u0002J\u0010\u0010J\u001a\u00020\r2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020LH\u0002J\u0010\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u000fH\u0002J\u0010\u0010P\u001a\u00020\r2\u0006\u00102\u001a\u00020\u000fH\u0002J\u0016\u0010Q\u001a\u00020\r2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206J\u0010\u0010R\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020LH\u0002J\u0010\u0010S\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010T\u001a\u00020\r2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206JJ\u0010U\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020L2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\"\u0010V\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0Wj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`XH\u0002J%\u0010Y\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\\J\u000e\u0010]\u001a\u00020\r2\u0006\u0010^\u001a\u00020\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter;", "", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/symbols/SymbolTable;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/google/common/collect/ImmutableList;Lorg/gradle/api/logging/Logger;)V", "localPackage", "", "referenceRewriter", "Lcom/android/resources/NamespaceReferenceRewriter;", "collectAndRemoveXmlNamespaces", "", "node", "Lorg/w3c/dom/Element;", "namespacesToFix", "Ljava/util/HashSet;", "findPackage", "type", "name", "findPackageForAttr", "findStyleableChild", "Lkotlin/Pair;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "generatePublicFile", "Ljava/nio/file/Path;", "publicTxt", "Ljava/io/InputStream;", "outputDirectory", "getMainElement", "document", "Lorg/w3c/dom/Document;", "maybeFindPackage", "reversed", "", "maybeWriteAttribute", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "writer", "Ljava/io/Writer;", "namespaceStyleables", "styleables", "", "fixedTable", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "packageContainsSymbol", "table", "canonicalName", "removeParent", "element", "rewriteAarResource", "input", "output", "Ljava/io/OutputStream;", "rewriteClass", "clazz", "", "originalClass", "rewriteFile", "displayInput", "method", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "rewriteJar", "inputJarStream", "outputJarStream", "rewriteManifest", "inputManifest", "outputManifest", "rewriteParent", "rewriteStyleElement", "rewriteStyleItem", "styleItemElement", "rewriteStyleItemNameAttribute", "attribute", "Lorg/w3c/dom/Node;", "rewriteStyleItemValue", "rewriteStyleItems", "styleElement", "rewriteStyleableElement", "rewriteValuesFile", "rewriteValuesNode", "rewriteXmlDoc", "rewriteXmlFile", "rewriteXmlNode", "usedNamespaces", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "writePublicFile", "symbols", "publicSymbols", "writePublicFile$gradle_core", "writeRClass", "rClassPath", "ClassReWriter", "MethodReWriter", "gradle-core"})
public final class NamespaceRewriter {
    @NotNull
    private final ImmutableList<SymbolTable> symbolTables;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String localPackage;
    @NotNull
    private final NamespaceReferenceRewriter referenceRewriter;

    public NamespaceRewriter(@NotNull ImmutableList<SymbolTable> symbolTables, @NotNull Logger logger) {
        String string;
        Intrinsics.checkNotNullParameter(symbolTables, (String)"symbolTables");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.symbolTables = symbolTables;
        this.logger = logger;
        SymbolTable symbolTable = (SymbolTable)CollectionsKt.firstOrNull((List)((List)this.symbolTables));
        this.localPackage = symbolTable == null ? "" : ((string = symbolTable.getTablePackage()) == null ? "" : string);
        this.referenceRewriter = new NamespaceReferenceRewriter(this.localPackage, (Function2)new Function2<String, String, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull String p0, @NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((NamespaceRewriter)this.receiver).findPackage(p0, p1);
            }
        });
    }

    public /* synthetic */ NamespaceRewriter(ImmutableList immutableList, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = Logging.getLogger(NamespaceRewriter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(NamespaceRewriter::class.java)");
            logger = logger2;
        }
        this((ImmutableList<SymbolTable>)immutableList, logger);
    }

    public final void rewriteClass(@NotNull Path clazz, @NotNull Path output2) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        byte[] originalClass = Files.readAllBytes(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)originalClass, (String)"originalClass");
        byte[] rewrittenClass = this.rewriteClass(originalClass);
        Files.write(output2, rewrittenClass, new OpenOption[0]);
    }

    private final byte[] rewriteClass(byte[] originalClass) {
        ClassWriter cw = new ClassWriter(0);
        ClassReWriter crw = new ClassReWriter(458752, (ClassVisitor)cw);
        ClassReader cr = new ClassReader(originalClass);
        cr.accept((ClassVisitor)crw, 0);
        crw.writeInnerRClasses();
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteJar(@NotNull InputStream inputJarStream, @NotNull OutputStream outputJarStream) {
        Intrinsics.checkNotNullParameter((Object)inputJarStream, (String)"inputJarStream");
        Intrinsics.checkNotNullParameter((Object)outputJarStream, (String)"outputJarStream");
        Closeable closeable = new ZipInputStream(NonClosingStreams.nonClosing((InputStream)inputJarStream));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipInputStream input = (ZipInputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new ZipOutputStream(NonClosingStreams.nonClosing((OutputStream)outputJarStream));
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ZipEntry zipEntry;
                ZipOutputStream output2 = (ZipOutputStream)closeable2;
                boolean bl6 = false;
                while ((zipEntry = input.getNextEntry()) != null) {
                    ZipEntry entry = zipEntry;
                    String name = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
                    output2.putNextEntry(ZipEntryUtils.zipEntry((String)name));
                    byte[] byArray = ByteStreams.toByteArray((InputStream)input);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(input)");
                    output2.write(this.rewriteClass(byArray));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewriteFile(InputStream input, OutputStream output2, Object displayInput, Function1<? super Document, Unit> method) {
        Object object;
        boolean $i$f$rewriteFile = false;
        try {
            object = PositionXmlParser.parse((InputStream)NonClosingStreams.nonClosing((InputStream)input));
        }
        catch (Exception e) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to parse ", (Object)displayInput), e);
        }
        Document doc = object;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
            method.invoke((Object)doc);
        }
        catch (Exception e) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed namespace ", (Object)displayInput), e);
        }
        object = NonClosingStreams.nonClosing((OutputStream)output2);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new OutputStreamWriter((OutputStream)object, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl3 = false;
            it.write(XmlPrettyPrinter.prettyPrint((Node)doc, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc), (String)System.lineSeparator(), (boolean)false));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteManifest(@NotNull InputStream inputManifest, @NotNull OutputStream outputManifest, @NotNull Object displayInput) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputManifest, (String)"inputManifest");
        Intrinsics.checkNotNullParameter((Object)outputManifest, (String)"outputManifest");
        Intrinsics.checkNotNullParameter((Object)displayInput, (String)"displayInput");
        NamespaceRewriter namespaceRewriter = this;
        NamespaceReferenceRewriter namespaceReferenceRewriter = this.referenceRewriter;
        boolean $i$f$rewriteFile = false;
        try {
            object = PositionXmlParser.parse((InputStream)NonClosingStreams.nonClosing((InputStream)inputManifest));
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to parse ", (Object)displayInput), e$iv);
        }
        Document doc$iv = object;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)doc$iv, (String)"doc");
            Node p0 = doc$iv;
            boolean bl = false;
            namespaceReferenceRewriter.rewriteManifestNode(p0);
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed namespace ", (Object)displayInput), e$iv);
        }
        object = NonClosingStreams.nonClosing((OutputStream)outputManifest);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new OutputStreamWriter((OutputStream)object, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it$iv = (OutputStreamWriter)object;
            boolean bl3 = false;
            it$iv.write(XmlPrettyPrinter.prettyPrint((Node)doc$iv, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc$iv), (String)System.lineSeparator(), (boolean)false));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteValuesFile(@NotNull InputStream input, @NotNull OutputStream output2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        NamespaceRewriter this_$iv = this;
        boolean $i$f$rewriteFile = false;
        try {
            object = PositionXmlParser.parse((InputStream)NonClosingStreams.nonClosing((InputStream)input));
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to parse ", (Object)input), e$iv);
        }
        Document doc$iv = object;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)doc$iv, (String)"doc");
            Node p0 = doc$iv;
            boolean bl = false;
            this.rewriteValuesNode(p0);
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed namespace ", (Object)input), e$iv);
        }
        object = NonClosingStreams.nonClosing((OutputStream)output2);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new OutputStreamWriter((OutputStream)object, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it$iv = (OutputStreamWriter)object;
            boolean bl3 = false;
            it$iv.write(XmlPrettyPrinter.prettyPrint((Node)doc$iv, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc$iv), (String)System.lineSeparator(), (boolean)false));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void rewriteValuesNode(Node node) {
        Node it;
        Node it$iv;
        int $i$f$forEach;
        ArrayList<Node> copy$iv;
        Object $this$forEach$iv;
        Object object;
        if (node.getNodeType() == 3) {
            String content2 = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"content");
            NamespaceReferenceRewriter.RewrittenReference rewrittenReference = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)content2, (boolean)false, (boolean)false, (int)6, null);
            String namespacedContent = rewrittenReference.component1();
            if (!Intrinsics.areEqual((Object)content2, (Object)namespacedContent)) {
                node.setNodeValue(namespacedContent);
            }
        } else {
            if (node.getNodeType() == 1 && Intrinsics.areEqual((Object)node.getNodeName(), (Object)"style")) {
                this.rewriteStyleElement((Element)node);
                return;
            }
            if (node.getNodeType() == 1 && Intrinsics.areEqual((Object)node.getNodeName(), (Object)"declare-styleable")) {
                this.rewriteStyleableElement((Element)node);
                return;
            }
        }
        if ((object = node.getAttributes()) != null) {
            $this$forEach$iv = object;
            boolean $i$f$forEach2 = false;
            copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            if (n < n2) {
                do {
                    int i$iv = n++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (n < n2);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl2 = false;
                this.rewriteValuesNode(it);
            }
        }
        object = node.getChildNodes();
        if (object != null) {
            $this$forEach$iv = object;
            boolean $i$f$forEach3 = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            int $this$forEach$iv$iv = 0;
            $i$f$forEach = $this$forEach$iv.getLength();
            if ($this$forEach$iv$iv < $i$f$forEach) {
                do {
                    int i$iv = $this$forEach$iv$iv++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while ($this$forEach$iv$iv < $i$f$forEach);
            }
            Iterable $this$forEach$iv$iv2 = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv2) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl3 = false;
                this.rewriteValuesNode(it);
            }
        }
    }

    private final void rewriteStyleElement(Element element) {
        this.rewriteParent(element, "style");
        this.rewriteStyleItems(element);
    }

    private final void rewriteParent(Element element, String type) {
        CharSequence name;
        Node node = element.getAttributes().getNamedItem("parent");
        String originalParent = node == null ? null : node.getNodeValue();
        String parent = null;
        if (originalParent == null) {
            String possiblePackage;
            Node node2 = element.getAttributes().getNamedItem("name");
            Intrinsics.checkNotNull((Object)node2);
            String string = node2.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.attributes.getNa\u2026dItem(\"name\")!!.nodeValue");
            name = string;
            String possibleParent = StringsKt.substringBeforeLast((String)name, (char)'.', (String)"");
            CharSequence charSequence = possibleParent;
            boolean bl = false;
            if (!(charSequence.length() == 0) && (possiblePackage = this.maybeFindPackage(type, possibleParent, false)) != null) {
                parent = "@*" + possiblePackage + ':' + type + '/' + possibleParent;
            }
        } else {
            name = originalParent;
            boolean possibleParent = false;
            if (!(name.length() == 0) && !StringsKt.contains$default((CharSequence)originalParent, (char)':', (boolean)false, (int)2, null)) {
                String rewrittenParent;
                parent = originalParent;
                if (!StringsKt.startsWith$default((String)parent, (String)"@", (boolean)false, (int)2, null)) {
                    parent = '@' + type + '/' + parent;
                }
                name = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)parent, (boolean)false, (boolean)false, (int)6, null);
                parent = rewrittenParent = name.component1();
            }
        }
        if (parent != null && !Intrinsics.areEqual(parent, (Object)originalParent)) {
            Attr parentAttribute = element.getOwnerDocument().createAttribute("parent");
            parentAttribute.setValue(parent);
            element.getAttributes().setNamedItem(parentAttribute);
        }
    }

    private final void removeParent(Element element) {
        element.removeAttribute("parent");
    }

    /*
     * WARNING - void declaration
     */
    private final void rewriteStyleableElement(Element element) {
        void $this$forEach$iv;
        this.removeParent(element);
        NodeList nodeList = element.getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"element.childNodes");
        boolean $i$f$forEach = false;
        ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
        int n = 0;
        int n2 = $this$forEach$iv.getLength();
        if (n < n2) {
            do {
                int i$iv = n++;
                copy$iv.add($this$forEach$iv.item(i$iv));
            } while (n < n2);
        }
        Iterable $this$forEach$iv$iv = copy$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            Node it$iv = (Node)element$iv$iv;
            boolean bl = false;
            Node child = it$iv;
            boolean bl2 = false;
            if (child.getNodeType() != 1 || !Intrinsics.areEqual((Object)child.getNodeName(), (Object)"attr") && !Intrinsics.areEqual((Object)child.getNodeName(), (Object)"item")) continue;
            Element cfr_ignored_0 = (Element)child;
            NamedNodeMap namedNodeMap = ((Element)child).getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)namedNodeMap, (String)"child.attributes");
            NamedNodeMap $this$forEach$iv2 = namedNodeMap;
            boolean $i$f$forEach3 = false;
            ArrayList<Node> copy$iv2 = new ArrayList<Node>($this$forEach$iv2.getLength());
            int n3 = 0;
            int n4 = $this$forEach$iv2.getLength();
            if (n3 < n4) {
                do {
                    int i$iv = n3++;
                    copy$iv2.add($this$forEach$iv2.item(i$iv));
                } while (n3 < n4);
            }
            Iterable $this$forEach$iv$iv2 = copy$iv2;
            boolean $i$f$forEach4 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                Node it$iv2 = (Node)element$iv$iv2;
                boolean bl3 = false;
                Node it = it$iv2;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)"name")) continue;
                String string = it.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeValue");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null)) continue;
                String string2 = it.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.nodeValue");
                String foundPackage = this.findPackageForAttr(string2);
                if (Intrinsics.areEqual((Object)foundPackage, (Object)this.localPackage)) continue;
                it.setNodeValue('*' + foundPackage + ':' + it.getNodeValue());
            }
        }
    }

    private final void rewriteStyleItems(Element styleElement) {
        NodeList nodeList = styleElement.getChildNodes();
        if (nodeList != null) {
            NodeList $this$forEach$iv = nodeList;
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            if (n < n2) {
                do {
                    int i$iv = n++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (n < n2);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Node it$iv = (Node)element$iv$iv;
                boolean bl = false;
                Node it = it$iv;
                boolean bl2 = false;
                if (it.getNodeType() != 1 || !Intrinsics.areEqual((Object)it.getNodeName(), (Object)"item")) continue;
                this.rewriteStyleItem((Element)it);
            }
        }
    }

    private final void rewriteStyleItem(Element styleItemElement) {
        Node it$iv;
        NodeList $this$forEach$iv;
        NamedNodeMap namedNodeMap = styleItemElement.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)namedNodeMap, (String)"styleItemElement.attributes");
        boolean $i$f$forEach = false;
        ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
        int n = 0;
        int n2 = $this$forEach$iv.getLength();
        if (n < n2) {
            do {
                int i$iv = n++;
                copy$iv.add($this$forEach$iv.item(i$iv));
            } while (n < n2);
        }
        Iterable $this$forEach$iv$iv22 = copy$iv;
        int $i$f$forEach2 = 0;
        for (Object element$iv$iv : $this$forEach$iv$iv22) {
            it$iv = (Node)element$iv$iv;
            boolean bl = false;
            Node attribute = it$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)attribute.getNodeName(), (Object)"name")) continue;
            this.rewriteStyleItemNameAttribute(attribute);
        }
        $this$forEach$iv = styleItemElement.getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"styleItemElement.childNodes");
        $i$f$forEach = false;
        copy$iv = new ArrayList($this$forEach$iv.getLength());
        int $this$forEach$iv$iv22 = 0;
        $i$f$forEach2 = $this$forEach$iv.getLength();
        if ($this$forEach$iv$iv22 < $i$f$forEach2) {
            do {
                int i$iv = $this$forEach$iv$iv22++;
                copy$iv.add($this$forEach$iv.item(i$iv));
            } while ($this$forEach$iv$iv22 < $i$f$forEach2);
        }
        Iterable $this$forEach$iv$iv = copy$iv;
        $i$f$forEach2 = 0;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (Node)element$iv$iv;
            boolean bl = false;
            Node node = it$iv;
            boolean bl3 = false;
            if (node.getNodeType() != 3) continue;
            this.rewriteStyleItemValue(node);
        }
    }

    private final void rewriteStyleItemNameAttribute(Node attribute) {
        String string = attribute.getNodeValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.nodeValue");
        if (StringsKt.contains$default((CharSequence)string, (char)':', (boolean)false, (int)2, null)) {
            return;
        }
        String content2 = Intrinsics.stringPlus((String)"@attr/", (Object)attribute.getNodeValue());
        NamespaceReferenceRewriter.RewrittenReference rewrittenReference = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)content2, (boolean)false, (boolean)false, (int)6, null);
        String namespacedContent = rewrittenReference.component1();
        String foundPackage = rewrittenReference.component2();
        if (!Intrinsics.areEqual((Object)content2, (Object)namespacedContent)) {
            attribute.setNodeValue('*' + foundPackage + ':' + attribute.getNodeValue());
        }
    }

    private final void rewriteStyleItemValue(Node node) {
        String content2 = node.getNodeValue();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"content");
        NamespaceReferenceRewriter.RewrittenReference rewrittenReference = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)content2, (boolean)false, (boolean)false, (int)6, null);
        String namespacedContent = rewrittenReference.component1();
        if (!Intrinsics.areEqual((Object)content2, (Object)namespacedContent)) {
            node.setNodeValue(namespacedContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteXmlFile(@NotNull InputStream input, @NotNull OutputStream output2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        NamespaceRewriter this_$iv = this;
        boolean $i$f$rewriteFile = false;
        try {
            object = PositionXmlParser.parse((InputStream)NonClosingStreams.nonClosing((InputStream)input));
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to parse ", (Object)input), e$iv);
        }
        Document doc$iv = object;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)doc$iv, (String)"doc");
            Document p0 = doc$iv;
            boolean bl = false;
            this.rewriteXmlDoc(p0);
        }
        catch (Exception e$iv) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed namespace ", (Object)input), e$iv);
        }
        object = NonClosingStreams.nonClosing((OutputStream)output2);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new OutputStreamWriter((OutputStream)object, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it$iv = (OutputStreamWriter)object;
            boolean bl3 = false;
            it$iv.write(XmlPrettyPrinter.prettyPrint((Node)doc$iv, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc$iv), (String)System.lineSeparator(), (boolean)false));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public final void rewriteAarResource(@NotNull String name, @NotNull InputStream input, @NotNull OutputStream output2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        if (StringsKt.startsWith$default((String)name, (String)"res/values/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"res/values-", (boolean)false, (int)2, null)) {
            this.rewriteValuesFile(input, output2);
        } else {
            if (StringsKt.startsWith$default((String)name, (String)"res/raw/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"res/raw-", (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Raw resources do not need rewriting");
            }
            if (StringsKt.endsWith$default((String)name, (String)".xml", (boolean)false, (int)2, null)) {
                this.rewriteXmlFile(input, output2);
            } else {
                throw new IllegalArgumentException("Non-xml resources do not need rewriting");
            }
        }
    }

    private final void rewriteXmlDoc(Document document) {
        Node it;
        Node it$iv;
        int $i$f$forEach;
        Iterable $this$forEach$iv$iv22;
        int n;
        Object copy$iv;
        boolean $i$f$forEach2;
        Object $this$forEach$iv;
        Element mainNode = this.getMainElement(document);
        HashSet<String> namespacesToFix = new HashSet<String>();
        HashMap<String, String> usedNamespaces = new HashMap<String, String>();
        this.collectAndRemoveXmlNamespaces(mainNode, namespacesToFix);
        Iterator iterator2 = mainNode.getAttributes();
        if (iterator2 != null) {
            $this$forEach$iv = iterator2;
            $i$f$forEach2 = false;
            copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n2 = 0;
            n = $this$forEach$iv.getLength();
            if (n2 < n) {
                do {
                    int i$iv = n2++;
                    ((ArrayList)copy$iv).add($this$forEach$iv.item(i$iv));
                } while (n2 < n);
            }
            $this$forEach$iv$iv22 = (Iterable)copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv22) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl2 = false;
                String string = it.getNodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeName");
                if (StringsKt.startsWith$default((String)string, (String)"xmlns:", (boolean)false, (int)2, null)) continue;
                this.rewriteXmlNode(it, document, namespacesToFix, usedNamespaces);
            }
        }
        iterator2 = mainNode.getChildNodes();
        if (iterator2 != null) {
            $this$forEach$iv = iterator2;
            $i$f$forEach2 = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            int $this$forEach$iv$iv22 = 0;
            $i$f$forEach = $this$forEach$iv.getLength();
            if ($this$forEach$iv$iv22 < $i$f$forEach) {
                do {
                    int i$iv = $this$forEach$iv$iv22++;
                    ((ArrayList)copy$iv).add($this$forEach$iv.item(i$iv));
                } while ($this$forEach$iv$iv22 < $i$f$forEach);
            }
            $this$forEach$iv$iv22 = (Iterable)copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv22) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl3 = false;
                this.rewriteXmlNode(it, document, namespacesToFix, usedNamespaces);
            }
        }
        Object object = MapsKt.toSortedMap((Map)usedNamespaces);
        $i$f$forEach2 = false;
        iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            copy$iv = object = iterator2.next();
            boolean bl = false;
            String pckg = (String)copy$iv.getKey();
            Object object2 = object;
            n = 0;
            String namespace2 = (String)object2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)namespace2, (String)"namespace");
            mainNode.setAttribute(Intrinsics.stringPlus((String)"xmlns:", (Object)StringsKt.replace$default((String)namespace2, (char)'.', (char)'_', (boolean)false, (int)4, null)), Intrinsics.stringPlus((String)"http://schemas.android.com/apk/res/", (Object)pckg));
        }
    }

    private final void collectAndRemoveXmlNamespaces(Element node, HashSet<String> namespacesToFix) {
        Node it;
        Node it$iv;
        int $i$f$forEach;
        ArrayList<Node> copy$iv;
        boolean $i$f$forEach2;
        Object $this$forEach$iv;
        Object object = node.getAttributes();
        if (object != null) {
            $this$forEach$iv = object;
            $i$f$forEach2 = false;
            copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            if (n < n2) {
                do {
                    int i$iv = n++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (n < n2);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl2 = false;
                String string = it.getNodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeName");
                if (!StringsKt.startsWith$default((String)string, (String)"xmlns:", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)it.getNodeValue(), (Object)"http://schemas.android.com/apk/res-auto")) continue;
                String string2 = it.getNodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.nodeName");
                String ns = StringsKt.substringAfter$default((String)string2, (String)"xmlns:", null, (int)2, null);
                namespacesToFix.add(ns);
                node.removeAttribute(Intrinsics.stringPlus((String)"xmlns:", (Object)ns));
            }
        }
        object = node.getChildNodes();
        if (object != null) {
            $this$forEach$iv = object;
            $i$f$forEach2 = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            int $this$forEach$iv$iv = 0;
            $i$f$forEach = $this$forEach$iv.getLength();
            if ($this$forEach$iv$iv < $i$f$forEach) {
                do {
                    int i$iv = $this$forEach$iv$iv++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while ($this$forEach$iv$iv < $i$f$forEach);
            }
            Iterable $this$forEach$iv$iv2 = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv2) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl3 = false;
                if (!(it instanceof Element)) continue;
                this.collectAndRemoveXmlNamespaces((Element)it, namespacesToFix);
            }
        }
    }

    private final Element getMainElement(Document document) {
        Element candidateMainNode = null;
        NodeList nodeList = document.getChildNodes();
        if (nodeList != null) {
            NodeList $this$forEach$iv = nodeList;
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            if (n < n2) {
                do {
                    int i$iv = n++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (n < n2);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Node it$iv = (Node)element$iv$iv;
                boolean bl = false;
                Node it = it$iv;
                boolean bl2 = false;
                if (it.getNodeType() != 1) continue;
                if (candidateMainNode != null) {
                    String string = "Invalid XML file - there can only be one main node.";
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                candidateMainNode = (Element)it;
            }
        }
        nodeList = candidateMainNode;
        if (nodeList == null) {
            String string = "Invalid XML file - missing main node.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return nodeList;
    }

    private final void rewriteXmlNode(Node node, Document document, HashSet<String> namespacesToFix, HashMap<String, String> usedNamespaces) {
        Node it;
        Node it$iv;
        int $i$f$forEach;
        ArrayList<Node> copy$iv;
        Object $this$forEach$iv;
        Object object;
        int n;
        Object namespacedContent;
        String content2;
        if (node.getNodeType() == 3) {
            content2 = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"content");
            NamespaceReferenceRewriter.RewrittenReference rewrittenReference = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)content2, (boolean)false, (boolean)false, (int)6, null);
            namespacedContent = rewrittenReference.component1();
            if (!Intrinsics.areEqual((Object)content2, (Object)namespacedContent)) {
                node.setNodeValue((String)namespacedContent);
            }
        } else if (node.getNodeType() == 2) {
            content2 = node.getNodeName();
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"node.nodeName");
            if (StringsKt.contains$default((CharSequence)content2, (CharSequence)":", (boolean)false, (int)2, null)) {
                boolean bl;
                block18: {
                    Iterable $this$any$iv = namespacesToFix;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it2 = (String)element$iv;
                            n = 0;
                            String string = node.getNodeName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName");
                            if (!StringsKt.startsWith$default((String)string, (String)Intrinsics.stringPlus((String)it2, (Object)":"), (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    String $i$f$any = node.getNodeName();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$any, (String)"node.nodeName");
                    String name = StringsKt.substringAfter$default((String)$i$f$any, (char)':', null, (int)2, null);
                    String content3 = Intrinsics.stringPlus((String)"@attr/", (Object)name);
                    namespacedContent = NamespaceReferenceRewriter.rewritePossibleReference$default((NamespaceReferenceRewriter)this.referenceRewriter, (String)content3, (boolean)true, (boolean)false, (int)4, null);
                    String namespacedContent2 = namespacedContent.component1();
                    String foundPackage = namespacedContent.component2();
                    if (!Intrinsics.areEqual((Object)content3, (Object)namespacedContent2)) {
                        usedNamespaces.computeIfAbsent(foundPackage, new Function(usedNamespaces){
                            final /* synthetic */ HashMap<String, String> $usedNamespaces;
                            {
                                this.$usedNamespaces = $usedNamespaces;
                            }

                            @NotNull
                            public final String apply(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.stringPlus((String)"ns", (Object)this.$usedNamespaces.size());
                            }
                        });
                        String string = Intrinsics.stringPlus((String)"http://schemas.android/apk/res/", (Object)foundPackage);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = usedNamespaces.get(foundPackage);
                        Intrinsics.checkNotNull((Object)string2);
                        document.renameNode(node, string, stringBuilder.append(string2).append(':').append(name).toString());
                    }
                }
            }
        }
        if ((object = node.getAttributes()) != null) {
            $this$forEach$iv = object;
            boolean $i$f$forEach2 = false;
            copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int foundPackage = 0;
            n = $this$forEach$iv.getLength();
            if (foundPackage < n) {
                do {
                    int i$iv = foundPackage++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (foundPackage < n);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl2 = false;
                this.rewriteXmlNode(it, document, namespacesToFix, usedNamespaces);
            }
        }
        object = node.getChildNodes();
        if (object != null) {
            $this$forEach$iv = object;
            boolean $i$f$forEach3 = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            int $this$forEach$iv$iv = 0;
            $i$f$forEach = $this$forEach$iv.getLength();
            if ($this$forEach$iv$iv < $i$f$forEach) {
                do {
                    int i$iv = $this$forEach$iv$iv++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while ($this$forEach$iv$iv < $i$f$forEach);
            }
            Iterable $this$forEach$iv$iv2 = copy$iv;
            $i$f$forEach = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv2) {
                it$iv = (Node)element$iv$iv;
                boolean bl = false;
                it = it$iv;
                boolean bl3 = false;
                this.rewriteXmlNode(it, document, namespacesToFix, usedNamespaces);
            }
        }
    }

    public final void writeRClass(@NotNull Path rClassPath) {
        Intrinsics.checkNotNullParameter((Object)rClassPath, (String)"rClassPath");
        SymbolTable currentTable = (SymbolTable)this.symbolTables.get(0);
        SymbolTable.Builder fixedTable = SymbolTable.Companion.builder().tablePackage(currentTable.getTablePackage());
        for (ResourceType type : ResourceType.values()) {
            if (type != ResourceType.STYLEABLE) {
                fixedTable.addAll((Collection)currentTable.getSymbolByResourceType(type));
                continue;
            }
            this.namespaceStyleables(currentTable.getSymbolByResourceType(ResourceType.STYLEABLE), fixedTable);
        }
        ImmutableList immutableList = ImmutableList.of((Object)fixedTable.build());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(fixedTable.build())");
        BytecodeRClassWriterKt.exportToCompiledJava$default((Iterable)((Iterable)immutableList), (Path)rClassPath, (boolean)false, (int)4, null);
    }

    @VisibleForTesting
    public final void namespaceStyleables(@NotNull List<? extends Symbol> styleables, @NotNull SymbolTable.Builder fixedTable) {
        Intrinsics.checkNotNullParameter(styleables, (String)"styleables");
        Intrinsics.checkNotNullParameter((Object)fixedTable, (String)"fixedTable");
        SymbolTable currentTable = (SymbolTable)this.symbolTables.get(0);
        Iterable $this$forEach$iv = styleables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Symbol symbol = (Symbol)element$iv;
            boolean bl = false;
            if (symbol.getChildren().isEmpty()) {
                fixedTable.add(symbol);
                continue;
            }
            ImmutableList.Builder newChildren = ImmutableList.builder();
            Iterable $this$forEach$iv2 = (Iterable)symbol.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)":", (boolean)false, (int)2, null)) {
                    newChildren.add((Object)it);
                    continue;
                }
                String foundPackage = this.findPackageForAttr(it);
                if (!Intrinsics.areEqual((Object)foundPackage, (Object)currentTable.getTablePackage())) {
                    newChildren.add((Object)(foundPackage + ':' + it));
                    continue;
                }
                newChildren.add((Object)it);
            }
            Symbol.StyleableSymbol cfr_ignored_0 = (Symbol.StyleableSymbol)symbol;
            String string = symbol.getName();
            ImmutableList immutableList = ((Symbol.StyleableSymbol)symbol).getValues();
            ImmutableList immutableList2 = newChildren.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"newChildren.build()");
            Symbol.StyleableSymbol newStyleable = Symbol.Companion.createStyleableSymbol$default((Symbol.Companion)Symbol.Companion, (String)string, (ImmutableList)immutableList, (List)((List)immutableList2), (boolean)false, (int)8, null);
            fixedTable.add((Symbol)newStyleable);
        }
    }

    private final Pair<Symbol.StyleableSymbol, String> findStyleableChild(String name) {
        String canonicalName = SymbolUtils.canonicalizeValueResourceName((String)name);
        for (SymbolTable table : this.symbolTables) {
            Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
            Symbol.StyleableSymbol maybeParent = SymbolTable.maybeGetStyleableParentSymbolForChild$default((SymbolTable)table, (String)canonicalName, (int)0, (int)2, null);
            if (maybeParent == null) continue;
            return new Pair((Object)maybeParent, (Object)table.getTablePackage());
        }
        String string = "In package " + this.localPackage + " found unknown styleable " + canonicalName;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public final String findPackage(@NotNull String type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)type, (Object)ResourceType.ATTR.getName())) {
            return this.findPackageForAttr(name);
        }
        String string = this.maybeFindPackage(type, name, false);
        if (string == null) {
            String string2 = "In package " + this.localPackage + " found unknown symbol of type " + type + " and name " + name + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private final String findPackageForAttr(String name) {
        String string;
        String foundPackage = this.maybeFindPackage("attr", name, false);
        if (foundPackage == null) {
            foundPackage = this.maybeFindPackage("attr?", name, true);
        }
        if ((string = foundPackage) == null) {
            String string2 = "In package " + this.localPackage + " found unknown attribute " + name;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private final String maybeFindPackage(String type, String name, boolean reversed) {
        String canonicalName = SymbolUtils.canonicalizeValueResourceName((String)name);
        ArrayList<String> packages = null;
        String result2 = null;
        for (SymbolTable table : reversed ? this.symbolTables.reverse() : this.symbolTables) {
            Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
            if (!this.packageContainsSymbol(table, type, canonicalName)) continue;
            if (result2 == null) {
                result2 = table.getTablePackage();
                continue;
            }
            if (packages == null) {
                packages = new ArrayList<String>();
            }
            packages.add(table.getTablePackage());
        }
        if (packages != null && !packages.isEmpty()) {
            this.logger.info("In package " + this.localPackage + " multiple options found in its dependencies for resource " + type + ' ' + name + ". Using " + result2 + ", other available: " + Joiner.on((String)", ").join((Iterable)packages));
        }
        return result2;
    }

    private final boolean packageContainsSymbol(SymbolTable table, String type, String canonicalName) {
        ResourceType resourceType = NamespaceRewriterKt.access$getResourceType(type);
        if (!table.containsSymbol(resourceType, canonicalName)) {
            return false;
        }
        if (resourceType == ResourceType.ATTR) {
            Object object = table.getSymbols().get((Object)resourceType, (Object)canonicalName);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.AttributeSymbol");
            }
            Symbol.AttributeSymbol attr = (Symbol.AttributeSymbol)object;
            return attr.isMaybeDefinition() == Intrinsics.areEqual((Object)type, (Object)"attr?");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path generatePublicFile(@Nullable InputStream publicTxt, @NotNull Path outputDirectory) {
        SymbolTable symbolTable;
        Object object;
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        SymbolTable symbols = (SymbolTable)this.symbolTables.get(0);
        Path values = outputDirectory.resolve("values");
        Files.createDirectories(values, new FileAttribute[0]);
        Path publicXml = values.resolve("auto-namespace-public.xml");
        if (Files.exists(publicXml, new LinkOption[0])) {
            String string = Intrinsics.stringPlus((String)"Internal error: Auto namespaced public XML file already exists: ", (Object)new Function0<Path>(publicXml){
                final /* synthetic */ Path $publicXml;
                {
                    this.$publicXml = $publicXml;
                    super(0);
                }

                public final Path invoke() {
                    return this.$publicXml.toAbsolutePath();
                }
            });
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (publicTxt != null) {
            object = SymbolIo.readFromPublicTxtFile((InputStream)publicTxt, (String)"", (String)symbols.getTablePackage());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readFromPublicTxtFile(pu\u2026\"\", symbols.tablePackage)");
            symbolTable = object;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)symbols, (String)"symbols");
            symbolTable = symbols;
        }
        SymbolTable publicSymbols = symbolTable;
        object = Files.newBufferedWriter(publicXml, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Writer writer = it;
            Intrinsics.checkNotNullExpressionValue((Object)symbols, (String)"symbols");
            this.writePublicFile$gradle_core(writer, symbols, publicSymbols);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)publicXml, (String)"publicXml");
        return publicXml;
    }

    @VisibleForTesting
    public final void writePublicFile$gradle_core(@NotNull Writer writer, @NotNull SymbolTable symbols, @NotNull SymbolTable publicSymbols) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)publicSymbols, (String)"publicSymbols");
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.write("\n<resources>\n");
        if (!publicSymbols.getSymbols().isEmpty()) {
            writer.write("\n");
            boolean allPublic = Intrinsics.areEqual((Object)symbols, (Object)publicSymbols);
            Iterable $this$forEach$iv = symbols.getResourceTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceType resourceType = (ResourceType)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = symbols.getSymbolByResourceType(resourceType);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Symbol symbol = (Symbol)element$iv2;
                    boolean bl2 = false;
                    if (!allPublic && !NamespaceRewriterKt.access$isPublic(symbol, publicSymbols)) continue;
                    if (symbol.getResourceType() == ResourceType.ATTR) {
                        this.maybeWriteAttribute(symbol, writer);
                        continue;
                    }
                    writer.write("    <public name=\"");
                    writer.write(symbol.getName());
                    writer.write("\" type=\"");
                    writer.write(resourceType.getName());
                    writer.write("\" />\n");
                }
            }
        }
        writer.write("\n</resources>\n");
    }

    private final void maybeWriteAttribute(Symbol symbol, Writer writer) {
        String foundPackage = this.findPackageForAttr(symbol.getName());
        if (Intrinsics.areEqual((Object)foundPackage, (Object)this.localPackage)) {
            writer.write("    <public name=\"");
            writer.write(symbol.getName());
            writer.write("\" type=\"attr\" />\n");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000e\u001a\u00020\bJ.\u0010\u0012\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016JE\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0010\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;", "Lorg/objectweb/asm/ClassVisitor;", "api", "", "cv", "(Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter;ILorg/objectweb/asm/ClassVisitor;)V", "innerClasses", "Ljava/util/HashSet;", "", "addInnerClass", "", "innerClass", "findPackageForSymbol", "type", "name", "findStyleableChildSymbol", "Lkotlin/Pair;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "visitInnerClass", "outerName", "innerName", "access", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "desc", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "writeInnerRClasses", "gradle-core"})
    private final class ClassReWriter
    extends ClassVisitor {
        @NotNull
        private final HashSet<String> innerClasses;

        public ClassReWriter(@Nullable int api, ClassVisitor cv) {
            Intrinsics.checkNotNullParameter((Object)NamespaceRewriter.this, (String)"this$0");
            super(api, cv);
            this.innerClasses = new HashSet();
        }

        public void visitInnerClass(@Nullable String name, @Nullable String outerName, @Nullable String innerName, int access) {
            if (outerName != null && !StringsKt.endsWith$default((String)outerName, (String)"/R", (boolean)false, (int)2, null)) {
                this.cv.visitInnerClass(name, outerName, innerName, access);
            }
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions) {
            return new MethodReWriter(this.api, this.cv.visitMethod(access, name, desc, signature, exceptions), this);
        }

        public final void writeInnerRClasses() {
            for (String innerClass : this.innerClasses) {
                Intrinsics.checkNotNullExpressionValue((Object)innerClass, (String)"innerClass");
                this.cv.visitInnerClass(innerClass, StringsKt.substringBeforeLast$default((String)innerClass, (char)'$', null, (int)2, null), StringsKt.substringAfterLast$default((String)innerClass, (char)'$', null, (int)2, null), 9);
            }
        }

        @NotNull
        public final Pair<Symbol.StyleableSymbol, String> findStyleableChildSymbol(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return NamespaceRewriter.this.findStyleableChild(name);
        }

        @NotNull
        public final String findPackageForSymbol(@NotNull String type, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return NamespaceRewriter.this.findPackage(type, name);
        }

        public final void addInnerClass(@NotNull String innerClass) {
            Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
            this.innerClasses.add(innerClass);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$MethodReWriter;", "Lorg/objectweb/asm/MethodVisitor;", "api", "", "mv", "crw", "Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;", "Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter;", "(ILorg/objectweb/asm/MethodVisitor;Lcom/android/build/gradle/internal/res/namespaced/NamespaceRewriter$ClassReWriter;)V", "visitFieldInsn", "", "opcode", "owner", "", "name", "desc", "visitFieldInsnForStyleable", "gradle-core"})
    private static final class MethodReWriter
    extends MethodVisitor {
        @NotNull
        private final ClassReWriter crw;

        public MethodReWriter(int api, @Nullable MethodVisitor mv, @NotNull ClassReWriter crw) {
            Intrinsics.checkNotNullParameter((Object)((Object)crw), (String)"crw");
            super(api, mv);
            this.crw = crw;
        }

        public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @Nullable String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (StringsKt.contains$default((CharSequence)owner, (CharSequence)"/R$", (boolean)false, (int)2, null)) {
                String type = StringsKt.substringAfterLast$default((String)owner, (char)'$', null, (int)2, null);
                if (Intrinsics.areEqual((Object)type, (Object)"styleable") && Intrinsics.areEqual((Object)desc, (Object)"I")) {
                    this.visitFieldInsnForStyleable(opcode, owner, name);
                } else {
                    String newPkg = StringsKt.replace$default((String)this.crw.findPackageForSymbol(type, name), (char)'.', (char)'/', (boolean)false, (int)4, null);
                    String newOwner = newPkg + "/R$" + type;
                    this.crw.addInnerClass(newOwner);
                    this.mv.visitFieldInsn(opcode, newOwner, name, desc);
                }
            } else {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private final void visitFieldInsnForStyleable(int opcode, String owner, String name) {
            Pair<Symbol.StyleableSymbol, String> parentPackage = this.crw.findStyleableChildSymbol(name);
            Symbol.StyleableSymbol parent = (Symbol.StyleableSymbol)parentPackage.getFirst();
            String newOwner = Intrinsics.stringPlus((String)StringsKt.replace$default((String)((String)parentPackage.getSecond()), (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)"/R$styleable");
            this.crw.addInnerClass(newOwner);
            String parentName = parent.getCanonicalName();
            String childName = StringsKt.drop((String)StringsKt.substringAfter$default((String)name, (String)parentName, null, (int)2, null), (int)1);
            if (StringsKt.startsWith$default((String)childName, (String)"android_", (boolean)false, (int)2, null)) {
                this.mv.visitFieldInsn(opcode, newOwner, name, "I");
            } else {
                String childPackage = this.crw.findPackageForSymbol("attr", childName);
                if (Intrinsics.areEqual((Object)childPackage, (Object)parentPackage.getSecond())) {
                    this.mv.visitFieldInsn(opcode, newOwner, name, "I");
                } else {
                    String newName = parentName + '_' + StringsKt.replace$default((String)childPackage, (char)'.', (char)'_', (boolean)false, (int)4, null) + '_' + childName;
                    this.mv.visitFieldInsn(opcode, newOwner, newName, "I");
                }
            }
        }
    }
}

