/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdManager;
import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.sun.xml.bind.v2.util.EditDistance;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"J5\u0010#\u001a\u0004\u0018\u00010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b*J,\u0010+\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0016J\u0014\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160-H\u0002J\u0014\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\"J*\u00101\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\u0006\u0010)\u001a\u00020\u00162\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u000203H\u0002J\u0016\u00105\u001a\u00020/2\u0006\u0010(\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0002J)\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\u0006\u0010(\u001a\u00020\u00162\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>H\u0002\u00a2\u0006\u0002\u0010?R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/build/gradle/internal/AvdManager;", "", "avdFolder", "Ljava/io/File;", "versionedSdkLoader", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "snapshotHandler", "Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "(Ljava/io/File;Lorg/gradle/api/provider/Provider;Lcom/android/sdklib/repository/AndroidSdkHandler;Lcom/android/prefs/AndroidLocationsProvider;Lcom/android/build/gradle/internal/AvdSnapshotHandler;)V", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "getAvdManager", "()Lcom/android/sdklib/internal/avd/AvdManager;", "avdManager$delegate", "Lkotlin/Lazy;", "defaultEmulatorPropertiesMap", "", "", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "getDeviceManager", "()Lcom/android/sdklib/devices/DeviceManager;", "deviceManager$delegate", "logger", "Lcom/android/utils/ILogger;", "sdkDirectory", "getSdkDirectory", "()Ljava/io/File;", "allAvds", "", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "imageProvider", "Lorg/gradle/api/file/Directory;", "imageHash", "deviceName", "hardwareProfile", "createAvd$gradle_core", "createOrRetrieveAvd", "defaultHardwareConfig", "", "deleteAvds", "", "avds", "getHardwareProfiles", "maxEditDistance", "", "maxSuggestions", "loadSnapshotIfNeeded", "emulatorGpuFlag", "retrieveSystemImage", "Lcom/android/sdklib/ISystemImage;", "imageLocation", "Ljava/nio/file/Path;", "runWithMultiProcessLocking", "V", "runnable", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "gradle-core"})
public final class AvdManager {
    @NotNull
    private final File avdFolder;
    @NotNull
    private final Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader;
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final AndroidLocationsProvider androidLocationsProvider;
    @NotNull
    private final AvdSnapshotHandler snapshotHandler;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Lazy avdManager$delegate;
    @NotNull
    private final Lazy deviceManager$delegate;
    @NotNull
    private final Map<String, String> defaultEmulatorPropertiesMap;

    public AvdManager(@NotNull File avdFolder, @NotNull Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader2, @NotNull AndroidSdkHandler sdkHandler, @NotNull AndroidLocationsProvider androidLocationsProvider, @NotNull AvdSnapshotHandler snapshotHandler) {
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter(versionedSdkLoader2, (String)"versionedSdkLoader");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        this.avdFolder = avdFolder;
        this.versionedSdkLoader = versionedSdkLoader2;
        this.sdkHandler = sdkHandler;
        this.androidLocationsProvider = androidLocationsProvider;
        this.snapshotHandler = snapshotHandler;
        Pair[] pairArray = LoggerWrapper.getLogger(AvdManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"getLogger(AvdManager::class.java)");
        this.logger = (ILogger)pairArray;
        this.avdManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<com.android.sdklib.internal.avd.AvdManager>(this){
            final /* synthetic */ AvdManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final com.android.sdklib.internal.avd.AvdManager invoke() {
                com.android.sdklib.internal.avd.AvdManager avdManager2 = com.android.sdklib.internal.avd.AvdManager.getInstance((AndroidSdkHandler)AvdManager.access$getSdkHandler$p(this.this$0), (Path)AvdManager.access$getSdkHandler$p(this.this$0).toCompatiblePath(AvdManager.access$getAvdFolder$p(this.this$0)), (ILogger)AvdManager.access$getLogger$p(this.this$0));
                if (avdManager2 == null) {
                    throw new RuntimeException("Failed to initialize AvdManager.");
                }
                return avdManager2;
            }
        }));
        this.deviceManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceManager>(this){
            final /* synthetic */ AvdManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeviceManager invoke() {
                return DeviceManager.createInstance((AndroidLocationsProvider)AvdManager.access$getAndroidLocationsProvider$p(this.this$0), (Path)AvdManager.access$getSdkDirectory(this.this$0).toPath(), (ILogger)AvdManager.access$getLogger$p(this.this$0));
            }
        }));
        FileUtils.mkdirs((File)this.avdFolder);
        pairArray = new Pair[]{TuplesKt.to((Object)"hw.camera.back", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.cpu.ncore", (Object)String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES)), TuplesKt.to((Object)"skin.path", (Object)"_no_skin"), TuplesKt.to((Object)"showDeviceFrame", (Object)"yes"), TuplesKt.to((Object)"hw.camera.front", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.keyboard", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.mode", (Object)GpuMode.AUTO.getGpuSetting()), TuplesKt.to((Object)"hw.initialOrientation", (Object)"Portrait"), TuplesKt.to((Object)"disk.dataPartition.size", (Object)EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString()), TuplesKt.to((Object)"runtime.network.latency", (Object)"None"), TuplesKt.to((Object)"runtime.network.speed", (Object)"Full"), TuplesKt.to((Object)"sdcard.size", (Object)EmulatedProperties.DEFAULT_SDCARD_SIZE.toString()), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.enabled", (Object)"yes"), TuplesKt.to((Object)"vm.heapSize", (Object)EmulatedProperties.DEFAULT_HEAP.toString())};
        this.defaultEmulatorPropertiesMap = MapsKt.mapOf((Pair[])pairArray);
    }

    private final File getSdkDirectory() {
        File file = ((Directory)((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getSdkDirectoryProvider().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"versionedSdkLoader.get()\u2026toryProvider.get().asFile");
        return file;
    }

    private final com.android.sdklib.internal.avd.AvdManager getAvdManager() {
        Lazy lazy = this.avdManager$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (com.android.sdklib.internal.avd.AvdManager)lazy.getValue();
    }

    private final DeviceManager getDeviceManager() {
        Lazy lazy = this.deviceManager$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-deviceManager>(...)");
        return (DeviceManager)object;
    }

    @NotNull
    public final File createOrRetrieveAvd(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        return (File)this.runWithMultiProcessLocking(deviceName, (Function0)new Function0<File>(this, deviceName, imageProvider, imageHash, hardwareProfile){
            final /* synthetic */ AvdManager this$0;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ Provider<Directory> $imageProvider;
            final /* synthetic */ String $imageHash;
            final /* synthetic */ String $hardwareProfile;
            {
                this.this$0 = $receiver;
                this.$deviceName = $deviceName;
                this.$imageProvider = $imageProvider;
                this.$imageHash = $imageHash;
                this.$hardwareProfile = $hardwareProfile;
                super(0);
            }

            @NotNull
            public final File invoke() {
                Object object;
                Object object2;
                AvdInfo avdInfo;
                AvdInfo info2;
                AvdManager.access$getAvdManager(this.this$0).reloadAvds(AvdManager.access$getLogger$p(this.this$0));
                AvdInfo avdInfo2 = info2 = AvdManager.access$getAvdManager(this.this$0).getAvd(this.$deviceName, false);
                if (avdInfo2 != null) {
                    avdInfo = avdInfo2;
                    object2 = this.this$0;
                    object = this.$deviceName;
                    boolean bl = false;
                    boolean bl2 = false;
                    AvdInfo it = avdInfo;
                    boolean bl3 = false;
                    if (info2.getStatus() == AvdInfo.AvdStatus.OK) {
                        AvdManager.access$getLogger$p((AvdManager)object2).info("Device: " + (String)object + " already exists. AVD creation skipped.", new Object[0]);
                        File file = info2.getConfigFile().toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"info.configFile.toFile()");
                        return file;
                    }
                    AvdManager.access$getLogger$p((AvdManager)object2).warning((String)object + " needs to be recreated because it is invalid (AvdStatus = " + info2.getStatus() + ')', new Object[0]);
                    ((AvdManager)object2).deleteAvds(CollectionsKt.listOf((Object)object));
                }
                AvdInfo newInfo = this.this$0.createAvd$gradle_core(this.$imageProvider, this.$imageHash, this.$deviceName, this.$hardwareProfile);
                object2 = newInfo;
                File file = object2 == null ? null : (avdInfo = (object = object2.getConfigFile()) == null ? null : object.toFile());
                if (avdInfo == null) {
                    object2 = "AVD could not be created.";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object2.toString());
                }
                return avdInfo;
            }
        });
    }

    private final <V> V runWithMultiProcessLocking(String deviceName, Function0<? extends V> runnable) {
        return (V)SynchronizedFile.getInstanceWithMultiProcessLocking((File)FilesKt.resolve((File)this.avdFolder, (String)deviceName)).write(new ExceptionFunction(runnable){
            final /* synthetic */ Function0<V> $runnable;
            {
                this.$runnable = $runnable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final V accept(File it) {
                Object object;
                try {
                    object = this.$runnable.invoke();
                }
                finally {
                    SynchronizedFile.getLockFile((File)it).delete();
                }
                Object result2 = object;
                return (V)result2;
            }
        });
    }

    @Nullable
    public final AvdInfo createAvd$gradle_core(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Object v0;
        ISystemImage systemImage;
        block6: {
            Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
            Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            if (!imageProvider.isPresent()) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Failed to find system image for hash: ", (Object)imageHash));
            }
            Path imageLocation = this.sdkHandler.toCompatiblePath(((Directory)imageProvider.get()).getAsFile());
            Intrinsics.checkNotNullExpressionValue((Object)imageLocation, (String)"imageLocation");
            ISystemImage iSystemImage = systemImage = this.retrieveSystemImage(this.sdkHandler, imageLocation);
            if (iSystemImage == null) {
                String string = Intrinsics.stringPlus((String)"System image does not exist at ", (Object)imageLocation);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = this.getDeviceManager().getDevices(DeviceManager.ALL_DEVICES);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"deviceManager.getDevices\u2026eviceManager.ALL_DEVICES)");
            iterable = iterable;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                Device it = (Device)e;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)hardwareProfile)) continue;
                v0 = e;
                break block6;
            }
            v0 = null;
        }
        Device device = v0;
        if (device == null) {
            Collection collection;
            Collection collection2 = AvdManager.getHardwareProfiles$default(this, hardwareProfile, 0, 0, 6, null);
            boolean bl = false;
            if (collection2.isEmpty()) {
                boolean bl4 = false;
                collection = AvdManager.getHardwareProfiles$default(this, "Pixel 6", 0, 0, 6, null);
            } else {
                collection = collection2;
            }
            List availableDevices = (List)collection;
            String errMsg = StringsKt.trimIndent((String)("\n                Failed to find hardware profile for name: " + hardwareProfile + "\n                Try one of the following device profiles: " + CollectionsKt.joinToString$default((Iterable)availableDevices, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n                "));
            bl = false;
            throw (Throwable)new IllegalStateException(errMsg.toString());
        }
        Map<String, String> hardwareConfig = this.defaultHardwareConfig();
        Map errMsg = DeviceManager.getHardwareProperties((Device)device);
        Intrinsics.checkNotNullExpressionValue((Object)errMsg, (String)"getHardwareProperties(device)");
        hardwareConfig.putAll(errMsg);
        EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
        Path deviceFolder = AvdInfo.getDefaultAvdFolder((com.android.sdklib.internal.avd.AvdManager)this.getAvdManager(), (String)deviceName, (boolean)false);
        return this.getAvdManager().createAvd(deviceFolder, deviceName, systemImage, null, null, null, hardwareConfig, device.getBootProps(), device.hasPlayStore(), false, false, this.logger);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getHardwareProfiles(String hardwareProfile, int maxEditDistance, int maxSuggestions) {
        void $this$sortedBy$iv;
        Collection collection = this.getDeviceManager().getDevices(DeviceManager.ALL_DEVICES);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"deviceManager.getDevices\u2026eviceManager.ALL_DEVICES)");
        collection = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)getHardwareProfiles.1.INSTANCE), (Function1)getHardwareProfiles.2.INSTANCE)), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Integer>>(hardwareProfile){
            final /* synthetic */ String $hardwareProfile;
            {
                this.$hardwareProfile = $hardwareProfile;
                super(1);
            }

            @NotNull
            public final Pair<String, Integer> invoke(String it) {
                return TuplesKt.to((Object)it, (Object)EditDistance.editDistance((String)this.$hardwareProfile, (String)it));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends Integer>, Boolean>(maxEditDistance){
            final /* synthetic */ int $maxEditDistance;
            {
                this.$maxEditDistance = $maxEditDistance;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, Integer> $dstr$_u24__u24$distance) {
                Intrinsics.checkNotNullParameter($dstr$_u24__u24$distance, (String)"$dstr$_u24__u24$distance");
                int distance = ((Number)$dstr$_u24__u24$distance.component2()).intValue();
                return distance <= this.$maxEditDistance;
            }
        }));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$distance = (Pair)a;
                boolean bl2 = false;
                int distance = ((Number)$dstr$_u24__u24$distance.component2()).intValue();
                $dstr$_u24__u24$distance = (Pair)b;
                Comparable comparable = Integer.valueOf(distance);
                bl2 = false;
                distance = ((Number)$dstr$_u24__u24$distance.component2()).intValue();
                Integer n = distance;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        }), (Function1)getHardwareProfiles.6.INSTANCE), (int)maxSuggestions));
    }

    static /* synthetic */ List getHardwareProfiles$default(AvdManager avdManager2, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 3;
        }
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        return avdManager2.getHardwareProfiles(string, n, n2);
    }

    public final void loadSnapshotIfNeeded(@NotNull String deviceName, @NotNull String emulatorGpuFlag) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        this.runWithMultiProcessLocking(deviceName, (Function0)new Function0<Unit>(this, deviceName, emulatorGpuFlag){
            final /* synthetic */ AvdManager this$0;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ String $emulatorGpuFlag;
            {
                this.this$0 = $receiver;
                this.$deviceName = $deviceName;
                this.$emulatorGpuFlag = $emulatorGpuFlag;
                super(0);
            }

            public final void invoke() {
                Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)AvdManager.access$getVersionedSdkLoader$p(this.this$0).get()).getEmulatorDirectoryProvider();
                File emulatorExecutable = AvdManager.access$getSnapshotHandler$p(this.this$0).getEmulatorExecutable(emulatorProvider);
                if (AvdSnapshotHandler.checkSnapshotLoadable$default(AvdManager.access$getSnapshotHandler$p(this.this$0), this.$deviceName, emulatorExecutable, AvdManager.access$getAvdFolder$p(this.this$0), this.$emulatorGpuFlag, AvdManager.access$getLogger$p(this.this$0), null, 32, null)) {
                    AvdManager.access$getLogger$p(this.this$0).verbose(Intrinsics.stringPlus((String)"Snapshot already exists for device ", (Object)this.$deviceName), new Object[0]);
                    return;
                }
                File adbExecutable2 = ((RegularFile)((SdkComponentsBuildService.VersionedSdkLoader)AvdManager.access$getVersionedSdkLoader$p(this.this$0).get()).getAdbExecutableProvider().get()).getAsFile();
                AvdManager.access$getLogger$p(this.this$0).verbose(Intrinsics.stringPlus((String)"Creating snapshot for ", (Object)this.$deviceName), new Object[0]);
                AvdSnapshotHandler avdSnapshotHandler = AvdManager.access$getSnapshotHandler$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)adbExecutable2, (String)"adbExecutable");
                avdSnapshotHandler.generateSnapshot(this.$deviceName, emulatorExecutable, adbExecutable2, AvdManager.access$getAvdFolder$p(this.this$0), this.$emulatorGpuFlag, AvdManager.access$getLogger$p(this.this$0));
                if (!AvdSnapshotHandler.checkSnapshotLoadable$default(AvdManager.access$getSnapshotHandler$p(this.this$0), this.$deviceName, emulatorExecutable, AvdManager.access$getAvdFolder$p(this.this$0), this.$emulatorGpuFlag, AvdManager.access$getLogger$p(this.this$0), null, 32, null)) {
                    String string = "Snapshot setup ran successfully, but the snapshot failed to be created. This is\nlikely to a lack of disk space for the snapshot. Try the cleanManagedDevices\ntask with the --unused-only flag to remove any unused devices for this project.";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                AvdManager.access$getLogger$p(this.this$0).verbose("Verified snapshot created for: " + this.$deviceName + '.', new Object[0]);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allAvds() {
        void $this$mapTo$iv$iv;
        this.getAvdManager().reloadAvds(this.logger);
        AvdInfo[] avdInfoArray = this.getAvdManager().getAllAvds();
        Intrinsics.checkNotNullExpressionValue((Object)avdInfoArray, (String)"avdManager.allAvds");
        Object[] $this$map$iv = avdInfoArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvdInfo avdInfo = (AvdInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final void deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkNotNullParameter(avds, (String)"avds");
        this.getAvdManager().reloadAvds(this.logger);
        for (String avdName : avds) {
            AvdInfo avdInfo = this.getAvdManager().getAvd(avdName, false);
            if (avdInfo != null) {
                this.getAvdManager().deleteAvd(avdInfo, this.logger);
                continue;
            }
            this.logger.warning("Failed to delete avd: " + avdName + '.', new Object[0]);
        }
    }

    private final Map<String, String> defaultHardwareConfig() {
        Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getEmulatorDirectoryProvider();
        if (!emulatorProvider.isPresent()) {
            String string = "AVD Emulator package is not downloaded. Failed to retrieve hardware defaults for virtual device.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File emulatorLib = ((Directory)emulatorProvider.get()).getAsFile();
        File libDirectory = new File(emulatorLib, "lib");
        File hardwareDefs = new File(libDirectory, "hardware-properties.ini");
        Map map = HardwareProperties.parseHardwareDefinitions((IAbstractFile)((IAbstractFile)new PathFileWrapper(this.sdkHandler.toCompatiblePath(hardwareDefs))), (ILogger)this.logger);
        if (map == null) {
            String string = "Failed to find hardware definitions for emulator.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map hwMap = map;
        Map hwConfigMap = MapsKt.toMutableMap(this.defaultEmulatorPropertiesMap);
        Iterable $this$forEach$iv = hwMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HardwareProperties.HardwareProperty it = (HardwareProperties.HardwareProperty)element$iv;
            boolean bl = false;
            String string = it.getDefault();
            Object object = string;
            boolean bl2 = false;
            boolean bl3 = false;
            if (object == null || object.length() == 0) continue;
            object = hwConfigMap;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"default");
            String string3 = string;
            boolean bl4 = false;
            object.put(string2, string3);
        }
        return hwConfigMap;
    }

    private final ISystemImage retrieveSystemImage(AndroidSdkHandler sdkHandler, Path imageLocation) {
        long delay = 2L;
        int n = 0;
        do {
            int retry = n++;
            ISystemImage systemImage = sdkHandler.getSystemImageManager((ProgressIndicator)new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.VERBOSE))).getImageAt(imageLocation);
            if (systemImage != null) {
                return systemImage;
            }
            if (retry == 4) continue;
            this.logger.warning("Failed to to retrieve system image at: " + imageLocation + " Retrying in " + delay + " seconds", new Object[0]);
            Thread.sleep(delay * (long)1000);
            long l = delay * 2L;
            long l2 = 10L;
            boolean bl = false;
            delay = Math.min(l, l2);
        } while (n <= 4);
        return null;
    }

    public static final /* synthetic */ com.android.sdklib.internal.avd.AvdManager access$getAvdManager(AvdManager $this) {
        return $this.getAvdManager();
    }

    public static final /* synthetic */ ILogger access$getLogger$p(AvdManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Provider access$getVersionedSdkLoader$p(AvdManager $this) {
        return $this.versionedSdkLoader;
    }

    public static final /* synthetic */ AvdSnapshotHandler access$getSnapshotHandler$p(AvdManager $this) {
        return $this.snapshotHandler;
    }

    public static final /* synthetic */ File access$getAvdFolder$p(AvdManager $this) {
        return $this.avdFolder;
    }

    public static final /* synthetic */ AndroidSdkHandler access$getSdkHandler$p(AvdManager $this) {
        return $this.sdkHandler;
    }

    public static final /* synthetic */ AndroidLocationsProvider access$getAndroidLocationsProvider$p(AvdManager $this) {
        return $this.androidLocationsProvider;
    }

    public static final /* synthetic */ File access$getSdkDirectory(AvdManager $this) {
        return $this.getSdkDirectory();
    }
}

