/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.VariantOutput;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantOutputImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import com.google.common.base.MoreObjects;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;

public class ApkVariantOutputImpl
extends BaseVariantOutputImpl
implements ApkVariantOutput {
    private ComponentType componentType;

    @Inject
    public ApkVariantOutputImpl(TaskContainer taskContainer, BaseServices services, VariantOutputImpl variantOutput, ComponentType componentType) {
        super(taskContainer, services, variantOutput);
        this.componentType = componentType;
    }

    @Override
    public PackageAndroidArtifact getPackageApplication() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getPackageApplicationProvider()", "variantOutput.getPackageApplication()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (PackageAndroidArtifact)this.taskContainer.getPackageAndroidTask().getOrNull();
    }

    @Override
    public File getOutputFile() {
        PackageAndroidArtifact packageAndroidArtifact = (PackageAndroidArtifact)this.taskContainer.getPackageAndroidTask().getOrNull();
        if (packageAndroidArtifact != null) {
            return new File(((Directory)packageAndroidArtifact.getOutputDirectory().get()).getAsFile(), (String)this.variantOutput.getOutputFileName().get());
        }
        return super.getOutputFile();
    }

    @Override
    public Task getZipAlign() {
        return this.getPackageApplication();
    }

    @Override
    public void setVersionCodeOverride(int versionCodeOverride) {
        if (this.componentType.isBaseModule()) {
            this.variantOutput.getVersionCode().set((Object)versionCodeOverride);
        }
    }

    @Override
    public int getVersionCodeOverride() {
        this.services.getDeprecationReporter().reportDeprecatedApi("VariantOutput.versionCode()", "ApkVariantOutput.getVersionCodeOverride()", "https://d.android.com/r/tools/use-properties", DeprecationReporter.DeprecationTarget.USE_PROPERTIES);
        if (!this.services.getProjectOptions().get(BooleanOption.ENABLE_LEGACY_API)) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Access to deprecated legacy com.android.build.gradle.api.ApkVariantOutput.getVersionCodeOverride() requires compatibility mode for Property values in new com.android.build.api.variant.VariantOutput.versionCode\n" + ComponentImpl.Companion.getENABLE_LEGACY_API()));
            return -1;
        }
        return (Integer)this.variantOutput.getVersionCode().getOrElse((Object)-1);
    }

    @Override
    public void setVersionNameOverride(String versionNameOverride) {
        if (this.componentType.isBaseModule()) {
            this.variantOutput.getVersionName().set((Object)versionNameOverride);
        }
    }

    @Override
    public String getVersionNameOverride() {
        this.services.getDeprecationReporter().reportDeprecatedApi("VariantOutput.versionName()", "ApkVariantOutput.getVersionNameOverride()", "https://d.android.com/r/tools/use-properties", DeprecationReporter.DeprecationTarget.USE_PROPERTIES);
        if (!this.services.getProjectOptions().get(BooleanOption.ENABLE_LEGACY_API)) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Access to deprecated legacy com.android.build.gradle.api.ApkVariantOutput.getVersionNameOverride() requires compatibility mode for Property values in new com.android.build.api.variant.VariantOutput.versionName\n" + ComponentImpl.Companion.getENABLE_LEGACY_API()));
            return null;
        }
        return (String)this.variantOutput.getVersionName().getOrNull();
    }

    public int getVersionCode() {
        if (!this.services.getProjectOptions().get(BooleanOption.ENABLE_LEGACY_API)) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Access to deprecated legacy com.android.build.gradle.api.ApkVariantOutput.versionCode requires compatibility mode for Property values in new com.android.build.api.variant.VariantOutput.versionCode\n" + ComponentImpl.Companion.getENABLE_LEGACY_API()));
            return -1;
        }
        return (Integer)this.variantOutput.getVersionCode().getOrElse((Object)-1);
    }

    @Override
    public String getFilter(VariantOutput.FilterType filterType2) {
        FilterConfiguration filterConfiguration = this.variantOutput.getFilter(FilterConfiguration.FilterType.valueOf((String)filterType2.name()));
        return filterConfiguration != null ? filterConfiguration.getIdentifier() : null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variantOutput", (Object)this.variantOutput).toString();
    }
}

