/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceImageSuggestionGenerator;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.repository.Revision;
import com.android.utils.ComputerArchUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 $2\u00020\u0001:\u0004$%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "", "getAbi", "()Lorg/gradle/api/provider/Property;", "apiLevel", "", "getApiLevel", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "getCompileSdkVersion", "emulatorGpuFlag", "getEmulatorGpuFlag", "hardwareProfile", "getHardwareProfile", "managedDeviceName", "getManagedDeviceName", "require64Bit", "", "getRequire64Bit", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "systemImageVendor", "getSystemImageVendor", "assertNoWearTvOrAuto", "", "doTaskAction", "Companion", "CreationAction", "ManagedDeviceSetupParams", "ManagedDeviceSetupRunnable", "gradle-core"})
public abstract class ManagedDeviceSetupTask
extends NonIncrementalGlobalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkService();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdService();

    @Input
    @NotNull
    public abstract Property<String> getCompileSdkVersion();

    @Input
    @NotNull
    public abstract Property<Revision> getBuildToolsRevision();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Input
    @NotNull
    public abstract Property<Integer> getApiLevel();

    @Input
    @NotNull
    public abstract Property<String> getSystemImageVendor();

    @Input
    @NotNull
    public abstract Property<String> getHardwareProfile();

    @Input
    @NotNull
    public abstract Property<String> getEmulatorGpuFlag();

    @Internal
    @NotNull
    public abstract Property<String> getManagedDeviceName();

    @Internal
    @NotNull
    public abstract Property<Boolean> getRequire64Bit();

    @Override
    protected void doTaskAction() {
        this.assertNoWearTvOrAuto();
        this.getWorkerExecutor().noIsolation().submit(ManagedDeviceSetupRunnable.class, new Action(this){
            final /* synthetic */ ManagedDeviceSetupTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ManagedDeviceSetupParams it) {
                Provider provider2 = (Provider)this.this$0.getProjectPath();
                Object object = this.this$0.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"path");
                it.initializeWith((Provider<String>)provider2, (String)object, (Provider<AnalyticsService>)((Provider)this.this$0.getAnalyticsService()));
                it.getSdkService().set((Provider)this.this$0.getSdkService());
                it.getCompileSdkVersion().set((Provider)this.this$0.getCompileSdkVersion());
                it.getBuildToolsRevision().set((Provider)this.this$0.getBuildToolsRevision());
                it.getAvdService().set((Provider)this.this$0.getAvdService());
                Property<String> property = it.getDeviceName();
                object = this.this$0.getApiLevel().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiLevel.get()");
                int n = ((Number)object).intValue();
                object = this.this$0.getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"systemImageVendor.get()");
                String string = (String)object;
                object = this.this$0.getAbi().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abi.get()");
                String string2 = (String)object;
                object = this.this$0.getHardwareProfile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hardwareProfile.get()");
                property.set((Object)ManagedDeviceUtilsKt.computeAvdName(n, string, string2, (String)object));
                it.getHardwareProfile().set((Provider)this.this$0.getHardwareProfile());
                it.getEmulatorGpuFlag().set((Provider)this.this$0.getEmulatorGpuFlag());
                it.getManagedDeviceName().set((Provider)this.this$0.getManagedDeviceName());
                it.getSystemImageVendor().set((Provider)this.this$0.getSystemImageVendor());
                it.getApiLevel().set((Provider)this.this$0.getApiLevel());
                it.getRequire64Bit().set((Provider)this.this$0.getRequire64Bit());
                it.getAbi().set((Provider)this.this$0.getAbi());
            }
        });
    }

    private final void assertNoWearTvOrAuto() {
        Object object = this.getSystemImageVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"systemImageVendor.get()");
        if (com.android.testing.utils.ManagedDeviceUtilsKt.isWearTvOrAutoSource((String)((String)object))) {
            object = StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a systemImageSource of " + this.getSystemImageVendor().get() + ".\n                    Wear, TV and Auto devices are presently not supported with Gradle Managed Devices.\n                "));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        object = this.getHardwareProfile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hardwareProfile.get()");
        if (com.android.testing.utils.ManagedDeviceUtilsKt.isWearTvOrAutoDevice((String)((String)object))) {
            object = StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a device profile of " + this.getHardwareProfile().get() + ".\n                    Wear, TV and Auto devices are presently not supported with Gradle Managed Devices.\n                "));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupParams;", "()V", "computeImageHash", "", "run", "", "gradle-core"})
    public static abstract class ManagedDeviceSetupRunnable
    extends ProfileAwareWorkAction<ManagedDeviceSetupParams> {
        @Override
        public void run() {
            String imageHash;
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getSdkService().get()).sdkLoader((Provider<String>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getBuildToolsRevision()));
            Provider<Directory> sdkImageProvider = versionedSdkLoader2.sdkImageDirectoryProvider(imageHash = this.computeImageHash());
            if (!sdkImageProvider.isPresent()) {
                Object object = ((ManagedDeviceSetupParams)this.getParameters()).getManagedDeviceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.managedDeviceName.get()");
                String string = (String)object;
                object = ((ManagedDeviceSetupParams)this.getParameters()).getApiLevel().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.apiLevel.get()");
                int n = ((Number)object).intValue();
                object = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.systemImageVendor.get()");
                String string2 = (String)object;
                object = ((ManagedDeviceSetupParams)this.getParameters()).getRequire64Bit().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.require64Bit.get()");
                object = Companion.generateSystemImageErrorMessage(string, n, string2, (Boolean)object, versionedSdkLoader2);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.deviceName.get()");
            String string = (String)object;
            object = ((ManagedDeviceSetupParams)this.getParameters()).getHardwareProfile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.hardwareProfile.get()");
            avdComponentsBuildService.avdProvider(sdkImageProvider, imageHash, string, (String)object).get();
            AvdComponentsBuildService avdComponentsBuildService2 = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.deviceName.get()");
            String string3 = (String)object;
            object = ((ManagedDeviceSetupParams)this.getParameters()).getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.emulatorGpuFlag.get()");
            avdComponentsBuildService2.ensureLoadableSnapshot(string3, (String)object);
        }

        private final String computeImageHash() {
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getApiLevel().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.apiLevel.get()");
            int n = ((Number)object).intValue();
            object = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.systemImageVendor.get()");
            String string = (String)object;
            object = ((ManagedDeviceSetupParams)this.getParameters()).getAbi().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.abi.get()");
            return com.android.testing.utils.ManagedDeviceUtilsKt.computeSystemImageHashFromDsl((int)n, (String)string, (String)((String)object));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$ManagedDeviceSetupParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "", "getAbi", "()Lorg/gradle/api/provider/Property;", "apiLevel", "", "getApiLevel", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "getCompileSdkVersion", "deviceName", "getDeviceName", "emulatorGpuFlag", "getEmulatorGpuFlag", "hardwareProfile", "getHardwareProfile", "managedDeviceName", "getManagedDeviceName", "require64Bit", "", "getRequire64Bit", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "systemImageVendor", "getSystemImageVendor", "gradle-core"})
    public static abstract class ManagedDeviceSetupParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdService();

        @NotNull
        public abstract Property<String> getDeviceName();

        @NotNull
        public abstract Property<String> getHardwareProfile();

        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @NotNull
        public abstract Property<String> getManagedDeviceName();

        @NotNull
        public abstract Property<String> getSystemImageVendor();

        @NotNull
        public abstract Property<Integer> getApiLevel();

        @NotNull
        public abstract Property<Boolean> getRequire64Bit();

        @NotNull
        public abstract Property<String> getAbi();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tBE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask;", "name", "", "managedDevice", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "creationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "systemImageSource", "apiLevel", "", "abi", "hardwareProfile", "managedDeviceName", "require64Bit", "", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<ManagedDeviceSetupTask> {
        @NotNull
        private final String name;
        @NotNull
        private final String systemImageSource;
        private final int apiLevel;
        @NotNull
        private final String abi;
        @NotNull
        private final String hardwareProfile;
        @NotNull
        private final String managedDeviceName;
        private final boolean require64Bit;

        public CreationAction(@NotNull String name, @NotNull String systemImageSource, int apiLevel, @NotNull String abi, @NotNull String hardwareProfile, @NotNull String managedDeviceName, boolean require64Bit, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            Intrinsics.checkNotNullParameter((Object)managedDeviceName, (String)"managedDeviceName");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = name;
            this.systemImageSource = systemImageSource;
            this.apiLevel = apiLevel;
            this.abi = abi;
            this.hardwareProfile = hardwareProfile;
            this.managedDeviceName = managedDeviceName;
            this.require64Bit = require64Bit;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public CreationAction(@NotNull String name, @NotNull ManagedVirtualDevice managedDevice, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)managedDevice, (String)"managedDevice");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this(name, managedDevice.getSystemImageSource(), managedDevice.getApiLevel(), ManagedDeviceUtilsKt.computeAbiFromArchitecture(managedDevice), managedDevice.getDevice(), managedDevice.getName(), managedDevice.getRequire64Bit(), creationConfig);
        }

        @Override
        @NotNull
        public Class<ManagedDeviceSetupTask> getType() {
            return ManagedDeviceSetupTask.class;
        }

        @Override
        public void configure(@NotNull ManagedDeviceSetupTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((BaseTask)task);
            Property<SdkComponentsBuildService> property = task.getSdkService();
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            HasConfigurableValuesKt.setDisallowChanges(task.getCompileSdkVersion(), this.creationConfig.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildToolsRevision(), this.creationConfig.getBuildToolsRevision());
            Property<AvdComponentsBuildService> property2 = task.getAvdService();
            buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            $i$f$getBuildService = false;
            object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AvdComponentsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property2, provider2);
            HasConfigurableValuesKt.setDisallowChanges(task.getSystemImageVendor(), this.systemImageSource);
            HasConfigurableValuesKt.setDisallowChanges(task.getApiLevel(), this.apiLevel);
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), this.abi);
            HasConfigurableValuesKt.setDisallowChanges(task.getHardwareProfile(), this.hardwareProfile);
            HasConfigurableValuesKt.setDisallowChanges(task.getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(this.creationConfig.getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getManagedDeviceName(), this.managedDeviceName);
            HasConfigurableValuesKt.setDisallowChanges(task.getRequire64Bit(), this.require64Bit);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceSetupTask$Companion;", "", "()V", "generateSystemImageErrorMessage", "", "deviceName", "apiLevel", "", "systemImageSource", "require64Bit", "", "versionedSdkLoader", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final String generateSystemImageErrorMessage(@NotNull String deviceName, int apiLevel, @NotNull String systemImageSource, boolean require64Bit, @NotNull SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2) {
            List list;
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)versionedSdkLoader2, (String)"versionedSdkLoader");
            if (versionedSdkLoader2.getOfflineMode()) {
                return StringsKt.trimIndent((String)("\n                    The system image for " + deviceName + " is not available and Gradle is in offline mode.\n                    Could not download the image or find other compatible images.\n                "));
            }
            List list2 = versionedSdkLoader2.allSystemImageHashes();
            if (list2 == null) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            } else {
                list = list2;
            }
            List allImages = list;
            return new ManagedDeviceImageSuggestionGenerator(ComputerArchUtilsKt.getOsArchitecture(), deviceName, apiLevel, systemImageSource, require64Bit, allImages).getMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

