/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.prefab.PrefabModuleTaskData;
import com.android.build.gradle.internal.cxx.prefab.PrefabPublishingKt;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.tasks.PrefabPackageTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020#H\u0014J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H%J\u0018\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00178G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u0004\u0018\u00010\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u00178G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lcom/android/build/gradle/tasks/PrefabPackageTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "configurationModel", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "configurationOnlyDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getConfigurationOnlyDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "jsonFiles", "", "Ljava/io/File;", "getJsonFiles", "()Ljava/util/List;", "<set-?>", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabModuleTaskData;", "modules", "getModules", "ndkAbiFilters", "Lcom/android/build/gradle/internal/core/Abi;", "getNdkAbiFilters", "outputDirectory", "getOutputDirectory", "", "packageName", "getPackageName", "()Ljava/lang/String;", "packageVersion", "getPackageVersion", "sdkComponents", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkComponents", "()Lorg/gradle/api/provider/Property;", "createModule", "", "module", "packageDir", "doTaskAction", "findLibraryForAbi", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "moduleName", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getFileOperations", "Lorg/gradle/api/internal/file/FileOperations;", "installLibs", "installDir", "CreationAction", "gradle-core"})
public abstract class PrefabPackageTask
extends NonIncrementalTask {
    private CxxConfigurationModel configurationModel;
    private String packageName;
    @Nullable
    private String packageVersion;
    private List<PrefabModuleTaskData> modules;

    @Inject
    @NotNull
    protected abstract FileOperations getFileOperations();

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkComponents();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        return null;
    }

    @Input
    @Optional
    @Nullable
    public final String getPackageVersion() {
        return this.packageVersion;
    }

    @Nested
    @NotNull
    public final List<PrefabModuleTaskData> getModules() {
        List<PrefabModuleTaskData> list = this.modules;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final List<File> getJsonFiles() {
        void $this$mapTo$iv$iv;
        CxxConfigurationModel cxxConfigurationModel;
        CxxConfigurationModel cxxConfigurationModel2 = this.configurationModel;
        if (cxxConfigurationModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
            cxxConfigurationModel = null;
        } else {
            cxxConfigurationModel = cxxConfigurationModel2;
        }
        Iterable $this$map$iv = cxxConfigurationModel.getActiveAbis();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CxxAbiModel cxxAbiModel = (CxxAbiModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = CxxAbiModelKt.getJsonFile((CxxAbiModel)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    @Input
    @NotNull
    public final List<Abi> getNdkAbiFilters() {
        CxxConfigurationModel cxxConfigurationModel;
        CxxConfigurationModel cxxConfigurationModel2 = this.configurationModel;
        if (cxxConfigurationModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
            cxxConfigurationModel = null;
        } else {
            cxxConfigurationModel = cxxConfigurationModel2;
        }
        return cxxConfigurationModel.getVariant().getValidAbiList();
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getConfigurationOnlyDirectory();

    @Override
    protected void doTaskAction() {
        this.getFileOperations().sync(new Action(this){
            final /* synthetic */ PrefabPackageTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CopySpec spec) {
                Object[] objectArray = new Object[]{this.this$0.getConfigurationOnlyDirectory()};
                spec.from(objectArray);
                spec.into((Object)this.this$0.getOutputDirectory());
            }
        });
        for (PrefabModuleTaskData module2 : this.getModules()) {
            File file = ((Directory)this.getOutputDirectory().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
            this.createModule(module2, file);
        }
    }

    private final void createModule(PrefabModuleTaskData module2, File packageDir) {
        File file = FilesKt.resolve((File)packageDir, (String)Intrinsics.stringPlus((String)"modules/", (Object)module2.getName()));
        boolean bl = false;
        boolean bl2 = false;
        File $this$createModule_u24lambda_u2d1 = file;
        boolean bl3 = false;
        $this$createModule_u24lambda_u2d1.mkdirs();
        File installDir = file;
        this.installLibs(module2, installDir);
    }

    private final NativeLibraryValueMini findLibraryForAbi(String moduleName, CxxAbiModel abi) {
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, null);
        Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(abi, null)");
        NativeBuildConfigValueMini config2 = nativeBuildConfigValueMini;
        Map<String, NativeLibraryValueMini> map = config2.libraries;
        Intrinsics.checkNotNullExpressionValue(map, (String)"config.libraries");
        Map<String, NativeLibraryValueMini> $this$filterValues$iv = map;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, NativeLibraryValueMini> result$iv = new LinkedHashMap<String, NativeLibraryValueMini>();
        Map<String, NativeLibraryValueMini> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<String, NativeLibraryValueMini> entry$iv : map2.entrySet()) {
            NativeLibraryValueMini it = entry$iv.getValue();
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.artifactName, (Object)moduleName)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Collection matchingLibs = ((Map)result$iv).values();
        return (NativeLibraryValueMini)CollectionsKt.singleOrNull((Iterable)matchingLibs);
    }

    private final void installLibs(PrefabModuleTaskData module2, File installDir) {
        CxxConfigurationModel cxxConfigurationModel;
        File libsDir = FilesKt.resolve((File)installDir, (String)"libs");
        CxxConfigurationModel cxxConfigurationModel2 = this.configurationModel;
        if (cxxConfigurationModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationModel");
            cxxConfigurationModel = null;
        } else {
            cxxConfigurationModel = cxxConfigurationModel2;
        }
        for (CxxAbiModel abiData : cxxConfigurationModel.getActiveAbis()) {
            NativeLibraryValueMini nativeLibraryValueMini = this.findLibraryForAbi(module2.getName(), abiData);
            File srcLibrary = nativeLibraryValueMini == null ? null : nativeLibraryValueMini.output;
            if (srcLibrary == null) continue;
            File libDir = FilesKt.resolve((File)libsDir, (String)Intrinsics.stringPlus((String)"android.", (Object)abiData.getAbi().getTag()));
            String string = srcLibrary.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcLibrary.name");
            File dest = FilesKt.resolve((File)libDir, (String)string);
            LoggingEnvironmentKt.infoln("Installing " + srcLibrary + " to " + dest, new Object[0]);
            IoUtilsKt.synchronizeFile$default(srcLibrary, dest, null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/tasks/PrefabPackageTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/PrefabPackageTask;", "Lcom/android/build/api/variant/impl/LibraryVariantImpl;", "taskName", "", "location", "modules", "", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabModuleTaskData;", "config", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "componentProperties", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;Lcom/android/build/api/variant/impl/LibraryVariantImpl;)V", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PrefabPackageTask, LibraryVariantImpl> {
        @NotNull
        private final String taskName;
        @NotNull
        private final String location;
        @NotNull
        private final List<PrefabModuleTaskData> modules;
        @NotNull
        private final CxxConfigurationModel config;

        public CreationAction(@NotNull String taskName, @NotNull String location, @NotNull List<PrefabModuleTaskData> modules, @NotNull CxxConfigurationModel config2, @NotNull LibraryVariantImpl componentProperties) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)componentProperties, (String)"componentProperties");
            super((ComponentCreationConfig)componentProperties);
            this.taskName = taskName;
            this.location = location;
            this.modules = modules;
            this.config = config2;
        }

        @Override
        @NotNull
        public String getName() {
            return this.taskName;
        }

        @Override
        @NotNull
        public Class<PrefabPackageTask> getType() {
            return PrefabPackageTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PrefabPackageTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((LibraryVariantImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("prefab").atLocation(this.location).on(InternalArtifactType.PREFAB_PACKAGE.INSTANCE);
        }

        @Override
        public void configure(@NotNull PrefabPackageTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ProjectInfo projectInfo = ((LibraryVariantImpl)this.creationConfig).getServices().getProjectInfo();
            task.setDescription("Creates a Prefab package for inclusion in an AAR");
            task.packageName = projectInfo.getName();
            task.packageVersion = PrefabPublishingKt.versionOrError(projectInfo.getVersion());
            task.modules = this.modules;
            task.configurationModel = this.config;
            Property<SdkComponentsBuildService> property = task.getSdkComponents();
            BuildServiceRegistry buildServiceRegistry$iv = ((LibraryVariantImpl)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getConfigurationOnlyDirectory(), ((LibraryVariantImpl)this.creationConfig).getArtifacts().get(InternalArtifactType.PREFAB_PACKAGE_CONFIGURATION.INSTANCE));
        }
    }
}

