/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.VariantKey;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a2\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00130\u0011\"\u0004\b\u0000\u0010\u0013*\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\u0016H\u0002\u001a\u0018\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0019*\u00020\u0014H\u0002\u001a\n\u0010\u001a\u001a\u00020\u0012*\u00020\u001b\u00a8\u0006\u001c"}, d2={"getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "componentImpl", "Lcom/android/build/api/component/impl/ComponentImpl;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "collections", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollections;", "projectPath", "variantName", "asMap", "", "Lcom/android/build/gradle/internal/ide/dependencies/VariantKey;", "T", "Lorg/gradle/api/artifacts/ArtifactCollection;", "action", "Lkotlin/Function1;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "asMultiMap", "Lcom/google/common/collect/ImmutableMultimap;", "toKey", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "gradle-core"})
@JvmName(name="ArtifactUtils")
public final class ArtifactUtils {
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ComponentImpl componentImpl, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)componentImpl, (String)"componentImpl");
        Intrinsics.checkNotNullParameter((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        ArtifactCollections collections = new ArtifactCollections(componentImpl, consumedConfigType);
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, buildMapping, componentImpl.getServices().getProjectInfo().getPath(), componentImpl.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<ResolvedArtifact> getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, ImmutableMap<String, String> buildMapping, String projectPath, String variantName) {
        void $this$filterTo$iv$iv;
        ArtifactCollection incomingArtifacts = collections.getAll();
        Map manifests2 = ArtifactUtils.asMap(collections.getManifests(), getAllArtifacts.manifests.1.INSTANCE);
        Map explodedAars2 = ArtifactUtils.asMap(collections.getExplodedAars(), getAllArtifacts.explodedAars.1.INSTANCE);
        Map lintJars2 = ArtifactUtils.asMap(collections.getLintJar(), getAllArtifacts.lintJars.1.INSTANCE);
        ArtifactCollection projectList = collections.getProjectJars();
        ImmutableMultimap<VariantKey, ResolvedArtifactResult> projectJars = ArtifactUtils.asMultiMap(projectList);
        if (dependencyFailureHandler != null) {
            Collection failures = incomingArtifacts.getFailures();
            String string = projectPath + '@' + variantName + '/' + collections.getConsumedConfigType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)failures, (String)"failures");
            dependencyFailureHandler.addErrors(string, failures);
        }
        Iterable $this$filter$iv = explodedAars2.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariantKey it = (VariantKey)element$iv$iv;
            boolean bl = false;
            if (!(it.getOwner() instanceof ProjectComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aarWrappedAsProjects = (List)destination$iv$iv;
        Set resolvedArtifactResults = incomingArtifacts.getArtifacts();
        LinkedHashSet artifacts = Sets.newLinkedHashSetWithExpectedSize((int)resolvedArtifactResults.size());
        for (ResolvedArtifactResult resolvedComponentResult : resolvedArtifactResults) {
            ResolvedVariantResult resolvedVariantResult = resolvedComponentResult.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"resolvedComponentResult.variant");
            VariantKey variantKey = ArtifactUtils.toKey(resolvedVariantResult);
            boolean isAarWrappedAsProject = aarWrappedAsProjects.contains(variantKey);
            ResolvedArtifact.DependencyType dependencyType = null;
            File extractedAar = (File)explodedAars2.get(variantKey);
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)manifests2.get(variantKey);
            Collection mainArtifacts = null;
            File publishedLintJar = null;
            String artifactType = (String)resolvedComponentResult.getVariant().getAttributes().getAttribute(AndroidArtifacts.ARTIFACT_TYPE);
            Iterator iterator2 = artifactType;
            if (Intrinsics.areEqual((Object)iterator2, (Object)AndroidArtifacts.ArtifactType.AAR.getType())) {
                dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                mainArtifacts = CollectionsKt.listOf((Object)resolvedComponentResult);
                publishedLintJar = (File)lintJars2.get(variantKey);
            } else if (Intrinsics.areEqual((Object)iterator2, (Object)AndroidArtifacts.ArtifactType.JAR.getType())) {
                if (manifest != null) {
                    dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                    mainArtifacts = CollectionsKt.listOf((Object)manifest);
                    publishedLintJar = (File)lintJars2.get(variantKey);
                } else {
                    Collection collection;
                    dependencyType = ResolvedArtifact.DependencyType.JAVA;
                    ImmutableCollection projectJar = projectJars.get((Object)variantKey);
                    Collection collection2 = (Collection)projectJar;
                    boolean bl = false;
                    if (collection2.isEmpty()) {
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"resolvedComponentResult");
                        collection = CollectionsKt.listOf((Object)resolvedComponentResult);
                    } else {
                        collection = collection2;
                    }
                    Collection collection3 = collection;
                    Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"projectJar.ifEmpty {\n   \u2026lt)\n                    }");
                    mainArtifacts = collection3;
                    publishedLintJar = null;
                }
            } else {
                throw new IllegalStateException("Internal error: Artifact type " + artifactType + " not expected, only jar or aar are handled.");
            }
            iterator2 = mainArtifacts;
            boolean projectJar = false;
            boolean bl = !iterator2.isEmpty();
            projectJar = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = StringsKt.trimMargin$default((String)("Internal Error: No artifact found for artifactType '" + variantKey + "'\n            | context: " + projectPath + ' ' + variantName + "\n            | manifests = " + manifests2 + "\n            | explodedAars = " + explodedAars2 + "\n            | projectJars = " + projectJars + "\n        "), null, (int)1, null);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (ResolvedArtifactResult mainArtifact : mainArtifacts) {
                artifacts.add(new ResolvedArtifact(mainArtifact, extractedAar, publishedLintJar, dependencyType, isAarWrappedAsProject, buildMapping));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)artifacts, (String)"artifacts");
        return artifacts;
    }

    private static final ImmutableMultimap<VariantKey, ResolvedArtifactResult> asMultiMap(ArtifactCollection $this$asMultiMap) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableMultimap.Builder builder2 = builder;
        boolean bl3 = false;
        for (ResolvedArtifactResult artifact : $this$asMultiMap.getArtifacts()) {
            ResolvedVariantResult resolvedVariantResult = artifact.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"artifact.variant");
            builder2.put((Object)ArtifactUtils.toKey(resolvedVariantResult), (Object)artifact);
        }
        ImmutableMultimap immutableMultimap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"builder<VariantKey, Reso\u2026      }\n        }.build()");
        return immutableMultimap;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Map<VariantKey, T> asMap(ArtifactCollection $this$asMap, Function1<? super ResolvedArtifactResult, ? extends T> action) {
        void $this$associateTo$iv$iv;
        Set set = $this$asMap.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"artifacts");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            ResolvedVariantResult resolvedVariantResult = it.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"it.variant");
            VariantKey variantKey = ArtifactUtils.toKey(resolvedVariantResult);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Pair pair = TuplesKt.to((Object)variantKey, (Object)action.invoke((Object)it));
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final VariantKey toKey(@NotNull ResolvedVariantResult $this$toKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"<this>");
        Object object = $this$toKey.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"owner");
        ComponentIdentifier componentIdentifier = object;
        object = $this$toKey.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"capabilities");
        Object object2 = object;
        object = $this$toKey.getExternalVariant().orElse(null);
        return new VariantKey(componentIdentifier, (List<? extends Capability>)object2, object == null ? null : ArtifactUtils.toKey((ResolvedVariantResult)object));
    }

    public static final /* synthetic */ Set access$getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, ImmutableMap buildMapping, String projectPath, String variantName) {
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, (ImmutableMap<String, String>)buildMapping, projectPath, variantName);
    }
}

