/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.Version;
import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.internal.attribution.BuildAttributionService;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.plugins.AndroidPluginBaseServices;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.NoOpAnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.NoOpAnalyticsService;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.base.CharMatcher;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H$J\n\u0010#\u001a\u0004\u0018\u00010$H$J>\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020(2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H&0*H\u0004\u00a2\u0006\u0002\u0010-R\u001b\u0010\u0005\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\n\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/plugins/AndroidPluginBaseServices;", "", "listenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "(Lorg/gradle/build/event/BuildEventsListenerRegistry;)V", "configuratorService", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "getConfiguratorService", "()Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "configuratorService$delegate", "Lkotlin/Lazy;", "optionService", "Lcom/android/build/gradle/options/ProjectOptionService;", "getOptionService", "()Lcom/android/build/gradle/options/ProjectOptionService;", "optionService$delegate", "project", "Lorg/gradle/api/Project;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "getProjectServices", "()Lcom/android/build/gradle/internal/services/ProjectServices;", "projectServices$delegate", "syncIssueReporter", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "getSyncIssueReporter", "()Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "syncIssueReporter$delegate", "basePluginApply", "", "checkMinJvmVersion", "checkPathForErrors", "configureExtension", "configureProject", "createTasks", "getAnalyticsPluginType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$PluginType;", "withProject", "T", "context", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "gradle-core"})
public abstract class AndroidPluginBaseServices {
    @NotNull
    private final BuildEventsListenerRegistry listenerRegistry;
    @NotNull
    private final Lazy optionService$delegate;
    @NotNull
    private final Lazy syncIssueReporter$delegate;
    @JvmField
    @Nullable
    protected Project project;
    @NotNull
    private final Lazy projectServices$delegate;
    @NotNull
    private final Lazy configuratorService$delegate;

    public AndroidPluginBaseServices(@NotNull BuildEventsListenerRegistry listenerRegistry) {
        Intrinsics.checkNotNullParameter((Object)listenerRegistry, (String)"listenerRegistry");
        this.listenerRegistry = listenerRegistry;
        this.optionService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectOptionService>(this){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ProjectOptionService invoke() {
                return (ProjectOptionService)this.this$0.withProject("optionService", optionService.1.INSTANCE);
            }
        }));
        this.syncIssueReporter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SyncIssueReporterImpl>(this){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SyncIssueReporterImpl invoke() {
                return (SyncIssueReporterImpl)((Object)this.this$0.withProject("syncIssueReporter", (Function1)new Function1<Project, SyncIssueReporterImpl>(this.this$0){
                    final /* synthetic */ AndroidPluginBaseServices this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final SyncIssueReporterImpl invoke(@NotNull Project it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Enum enum_ = SyncOptions.getModelQueryMode(AndroidPluginBaseServices.access$getOptionService(this.this$0).getProjectOptions());
                        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getModelQueryMode(optionService.projectOptions)");
                        SyncOptions.EvaluationMode evaluationMode = enum_;
                        enum_ = SyncOptions.getErrorFormatMode(AndroidPluginBaseServices.access$getOptionService(this.this$0).getProjectOptions());
                        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getErrorFormatMode(optionService.projectOptions)");
                        Enum enum_2 = enum_;
                        enum_ = it.getLogger();
                        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"it.logger");
                        return new SyncIssueReporterImpl(evaluationMode, (SyncOptions.ErrorFormatMode)enum_2, (Logger)enum_);
                    }
                }));
            }
        }));
        this.projectServices$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectServices>(this){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectServices invoke() {
                return (ProjectServices)this.this$0.withProject("projectServices", (Function1)new Function1<Project, ProjectServices>(this.this$0){
                    final /* synthetic */ AndroidPluginBaseServices this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final ProjectServices invoke(@NotNull Project project2) {
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        ProjectOptions projectOptions = AndroidPluginBaseServices.access$getOptionService(this.this$0).getProjectOptions();
                        SyncIssueReporter syncIssueReporter2 = this.this$0.getSyncIssueReporter();
                        IssueReporter issueReporter2 = this.this$0.getSyncIssueReporter();
                        String string = project2.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
                        DeprecationReporter deprecationReporter = new DeprecationReporterImpl(issueReporter2, projectOptions, string);
                        string = project2.getObjects();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.objects");
                        String string2 = string;
                        string = project2.getLogger();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.logger");
                        String string3 = string;
                        string = project2.getProviders();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.providers");
                        String string4 = string;
                        string = project2.getLayout();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.layout");
                        String string5 = string;
                        string = project2.getGradle().getSharedServices();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.gradle.sharedServices");
                        return new ProjectServices(syncIssueReporter2, deprecationReporter, (ObjectFactory)string2, (Logger)string3, (ProviderFactory)string4, (ProjectLayout)string5, projectOptions, (BuildServiceRegistry)string, LintFromMaven.Companion.from(project2, projectOptions, this.this$0.getSyncIssueReporter()), Aapt2FromMaven.Companion.create(project2, projectOptions), project2.getGradle().getStartParameter().getMaxWorkerCount(), new ProjectInfo(project2), (Function1<Object, ? extends File>)((Function1)new Function1<Object, File>(project2){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            @NotNull
                            public final File invoke(@NotNull Object o) {
                                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                                File file = this.$project.file(o);
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(o)");
                                return file;
                            }
                        }));
                    }
                });
            }
        }));
        this.configuratorService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AnalyticsConfiguratorService>(this){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AnalyticsConfiguratorService invoke() {
                return (AnalyticsConfiguratorService)this.this$0.withProject("configuratorService", (Function1)new Function1<Project, AnalyticsConfiguratorService>(this.this$0){
                    final /* synthetic */ AndroidPluginBaseServices this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final AnalyticsConfiguratorService invoke(@NotNull Project project2) {
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        ProjectOptions projectOptions = this.this$0.getProjectServices().getProjectOptions();
                        return projectOptions.isAnalyticsEnabled() ? (AnalyticsConfiguratorService)new AnalyticsConfiguratorService.RegistrationAction(project2).execute().get() : (AnalyticsConfiguratorService)project2.getGradle().getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(AnalyticsConfiguratorService.class), NoOpAnalyticsConfiguratorService.class, (Action)configuratorService.1.INSTANCE).get();
                    }
                });
            }
        }));
    }

    private final ProjectOptionService getOptionService() {
        Lazy lazy = this.optionService$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-optionService>(...)");
        return (ProjectOptionService)object;
    }

    @NotNull
    protected final SyncIssueReporterImpl getSyncIssueReporter() {
        Lazy lazy = this.syncIssueReporter$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (SyncIssueReporterImpl)((Object)lazy.getValue());
    }

    @NotNull
    protected final ProjectServices getProjectServices() {
        Lazy lazy = this.projectServices$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (ProjectServices)lazy.getValue();
    }

    @NotNull
    protected final AnalyticsConfiguratorService getConfiguratorService() {
        Lazy lazy = this.configuratorService$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-configuratorService>(...)");
        return (AnalyticsConfiguratorService)object;
    }

    protected void basePluginApply(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        System.setProperty("java.awt.headless", "true");
        this.project = project2;
        new AndroidLocationsBuildService.RegistrationAction(project2).execute();
        this.checkMinJvmVersion();
        ProjectOptions projectOptions = this.getProjectServices().getProjectOptions();
        if (projectOptions.isAnalyticsEnabled()) {
            new AnalyticsService.RegistrationAction(project2).execute();
        } else {
            project2.getGradle().getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(AnalyticsService.class), NoOpAnalyticsService.class, (Action)basePluginApply.1.INSTANCE);
        }
        DependencyResolutionChecks.registerDependencyCheck(project2, projectOptions);
        this.checkPathForErrors();
        String attributionFileLocation = projectOptions.get(StringOption.IDE_ATTRIBUTION_FILE_LOCATION);
        if (attributionFileLocation != null) {
            new BuildAttributionService.RegistrationAction(project2).execute();
            BuildAttributionService.Companion.init(project2, attributionFileLocation, this.listenerRegistry);
        }
        this.getConfiguratorService().createAnalyticsService(project2, this.listenerRegistry);
        AnalyticsConfiguratorService analyticsConfiguratorService = this.getConfiguratorService();
        String string = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        Object object = analyticsConfiguratorService.getProjectBuilder(string);
        if (object != null) {
            string = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            it.setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto(projectOptions));
        }
        AnalyticsConfiguratorService analyticsConfiguratorService2 = this.getConfiguratorService();
        object = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.path");
        analyticsConfiguratorService2.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, (String)object, null, new Recorder.VoidBlock(this, project2){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void call() {
                this.this$0.configureProject(this.$project);
            }
        });
        AnalyticsConfiguratorService analyticsConfiguratorService3 = this.getConfiguratorService();
        object = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.path");
        analyticsConfiguratorService3.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, (String)object, null, new Recorder.VoidBlock(this, project2){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void call() {
                this.this$0.configureExtension(this.$project);
            }
        });
        AnalyticsConfiguratorService analyticsConfiguratorService4 = this.getConfiguratorService();
        object = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.path");
        analyticsConfiguratorService4.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, (String)object, null, new Recorder.VoidBlock(this, project2){
            final /* synthetic */ AndroidPluginBaseServices this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void call() {
                this.this$0.createTasks(this.$project);
            }
        });
    }

    private final void checkPathForErrors() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        boolean bl = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            return;
        }
        if (this.getProjectServices().getProjectOptions().get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY)) {
            return;
        }
        CharMatcher charMatcher = CharMatcher.ascii();
        Project project2 = this.project;
        Intrinsics.checkNotNull((Object)project2);
        if (charMatcher.matchesAllOf((CharSequence)project2.getRootDir().getAbsolutePath())) {
            return;
        }
        String message2 = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message2);
    }

    protected void checkMinJvmVersion() {
        JavaVersion javaVersion = JavaVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"current()");
        JavaVersion current = javaVersion;
        JavaVersion minRequired = JavaVersion.VERSION_11;
        if (!current.isCompatibleWith(minRequired)) {
            IssueReporter.reportError$default((IssueReporter)this.getSyncIssueReporter(), (IssueReporter.Type)IssueReporter.Type.AGP_USED_JAVA_VERSION_TOO_LOW, (String)("Android Gradle plugin requires Java " + minRequired + " to run. You are currently using Java " + current + ".\n Your current JDK is located in " + System.getProperty("java.home") + "\n You can try some of the following options:\n  - changing the IDE settings.\n  - changing the JAVA_HOME environment variable.\n  - changing `org.gradle.java.home` in `gradle.properties`."), null, null, (int)12, null);
        }
    }

    protected abstract void configureProject(@NotNull Project var1);

    protected abstract void configureExtension(@NotNull Project var1);

    protected abstract void createTasks(@NotNull Project var1);

    @Nullable
    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected final <T> T withProject(@NotNull String context, @NotNull Function1<? super Project, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Project project2 = this.project;
        if (project2 == null) {
            object = null;
        } else {
            Project project3 = project2;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project3;
            boolean bl3 = false;
            object = action.invoke((Object)it);
        }
        Object object2 = object;
        if (object2 == null) {
            throw new IllegalStateException("Cannot obtain " + context + " until Project is known");
        }
        return (T)object2;
    }

    public static final /* synthetic */ ProjectOptionService access$getOptionService(AndroidPluginBaseServices $this) {
        return $this.getOptionService();
    }
}

