/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.api.component.impl

import com.android.build.gradle.internal.component.legacy.ModelV1LegacySupport
import com.android.build.gradle.internal.core.MergedFlavor
import com.android.build.gradle.internal.core.VariantDslInfoImpl
import org.gradle.api.provider.Provider

class ModelV1LegacySupportImpl(
    private val variantDslInfo: VariantDslInfoImpl
): ModelV1LegacySupport {

    override val mergedFlavor: MergedFlavor
        get() = variantDslInfo.mergedFlavor

    override val dslApplicationId: Provider<String>
        get() = variantDslInfo.applicationId
}
