/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.component.features

import com.android.build.api.variant.BuildConfigField
import com.android.builder.compiling.BuildConfigType
import org.gradle.api.file.FileCollection
import org.gradle.api.provider.MapProperty
import java.io.Serializable

/**
 * Creation config for components that support build config.
 *
 * To use this in a task that requires assets support, use
 * [com.android.build.gradle.internal.tasks.factory.features.BuildConfigTaskCreationAction].
 * Otherwise, access the nullable property on the component
 * [com.android.build.gradle.internal.component.ComponentCreationConfig.buildConfigCreationConfig].
 */
interface BuildConfigCreationConfig {
    val buildConfigFields: MapProperty<String, BuildConfigField<out Serializable>>
    @Deprecated("DO NOT USE, use buildConfigFields map property")
    val dslBuildConfigFields: Map<String, BuildConfigField<out Serializable>>
    val compiledBuildConfig: FileCollection
    val buildConfigType: BuildConfigType
}
