/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core.dsl.impl;

import com.android.build.gradle.internal.core.dsl.impl.DslInfoUtilsKt;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.builder.core.ComponentType;
import com.android.utils.StringHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a0\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"DEFAULT_FUNCTIONAL_TEST", "", "DEFAULT_HANDLE_PROFILING", "DEFAULT_TEST_RUNNER", "", "MULTIDEX_TEST_RUNNER", "computeName", "dimensionCombination", "Lcom/android/build/gradle/internal/variant/DimensionCombination;", "componentType", "Lcom/android/builder/core/ComponentType;", "flavorNameCallback", "Lkotlin/Function1;", "", "computeSourceSetName", "baseName", "gradle-core"})
public final class DslInfoUtilsKt {
    @NotNull
    public static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";
    @NotNull
    public static final String MULTIDEX_TEST_RUNNER = "com.android.test.runner.MultiDexTestRunner";
    public static final boolean DEFAULT_HANDLE_PROFILING = false;
    public static final boolean DEFAULT_FUNCTIONAL_TEST = false;

    @JvmOverloads
    @NotNull
    public static final String computeName(@NotNull DimensionCombination dimensionCombination, @NotNull ComponentType componentType, @Nullable Function1<? super String, Unit> flavorNameCallback) {
        Intrinsics.checkNotNullParameter((Object)dimensionCombination, (String)"dimensionCombination");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        String flavorName2 = dimensionCombination.getProductFlavors().isEmpty() ? "" : StringHelper.combineAsCamelCase((Collection)dimensionCombination.getProductFlavors(), (Function1)((Function1)computeName.flavorName.1.INSTANCE));
        Function1<? super String, Unit> function1 = flavorNameCallback;
        if (function1 != null) {
            Function1<? super String, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)flavorName2);
        }
        StringBuilder sb = new StringBuilder();
        String buildType = dimensionCombination.getBuildType();
        if (buildType == null) {
            if (((CharSequence)flavorName2).length() > 0) {
                sb.append(flavorName2);
            } else if (!componentType.isTestComponent() && !componentType.isTestFixturesComponent()) {
                sb.append("main");
            }
        } else if (((CharSequence)flavorName2).length() > 0) {
            sb.append(flavorName2);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)buildType);
        } else {
            sb.append(buildType);
        }
        if (componentType.isNestedComponent()) {
            if (((CharSequence)sb).length() == 0) {
                sb.append(componentType.getPrefix());
            } else {
                sb.append(componentType.getSuffix());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String computeName$default(DimensionCombination dimensionCombination, ComponentType componentType, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return DslInfoUtilsKt.computeName(dimensionCombination, componentType, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public static final String computeSourceSetName(@NotNull String baseName2, @NotNull ComponentType componentType) {
        Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        String name = baseName2;
        if (StringsKt.endsWith$default((String)name, (String)componentType.getSuffix(), (boolean)false, (int)2, null)) {
            String string = name.substring(0, name.length() - componentType.getSuffix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            name = string;
        }
        if (((CharSequence)componentType.getPrefix()).length() > 0) {
            name = StringHelper.appendCapitalized((String)componentType.getPrefix(), (String)name);
        }
        return name;
    }

    @JvmOverloads
    @NotNull
    public static final String computeName(@NotNull DimensionCombination dimensionCombination, @NotNull ComponentType componentType) {
        Intrinsics.checkNotNullParameter((Object)dimensionCombination, (String)"dimensionCombination");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return DslInfoUtilsKt.computeName$default(dimensionCombination, componentType, null, 4, null);
    }
}

