/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.testing.api.TestServer;
import com.android.ide.common.attribution.TaskCategoryLabel;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(taskCategoryLabels={TaskCategoryLabel.TEST, TaskCategoryLabel.DEPLOYMENT})
public abstract class TestServerTask
extends NonIncrementalTask {
    TestServer testServer;

    @Override
    protected void doTaskAction() {
        ImmutableList testedApkFiles;
        Object object = testedApkFiles = this.getTestedApks().isPresent() ? new BuiltArtifactsLoaderImpl().load((Directory)this.getTestedApks().get()).getElements().stream().map(BuiltArtifact::getOutputFile).map(File::new).collect(Collectors.toList()) : ImmutableList.of();
        if (testedApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs");
        }
        File testedApkFile = testedApkFiles.isEmpty() ? null : (File)testedApkFiles.get(0);
        List testApkFiles = new BuiltArtifactsLoaderImpl().load((Directory)this.getTestApks().get()).getElements().stream().map(BuiltArtifact::getOutputFile).map(File::new).collect(Collectors.toList());
        if (testApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs in test APKs");
        }
        this.testServer.uploadApks(this.getVariantName(), (File)testApkFiles.get(0), testedApkFile);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getTestApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getTestedApks();

    @Override
    @Input
    public String getVariantName() {
        return super.getVariantName();
    }

    public void setTestServer(TestServer testServer) {
        this.testServer = testServer;
    }

    public static class TestServerTaskCreationAction
    extends VariantTaskCreationAction<TestServerTask, AndroidTestCreationConfig> {
        private final TestServer testServer;
        private final boolean hasFlavors;

        public TestServerTaskCreationAction(AndroidTestCreationConfig androidTestProperties, TestServer testServer) {
            super(androidTestProperties);
            this.testServer = testServer;
            this.hasFlavors = !androidTestProperties.getProductFlavors().isEmpty();
        }

        @Override
        public String getName() {
            return this.hasFlavors ? this.computeTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
        }

        @Override
        public Class<TestServerTask> getType() {
            return TestServerTask.class;
        }

        @Override
        public void configure(TestServerTask task) {
            super.configure(task);
            VariantCreationConfig testedVariant = ((AndroidTestCreationConfig)this.creationConfig).getMainVariant();
            String variantName = ((AndroidTestCreationConfig)this.creationConfig).getName();
            task.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.usLocaleCapitalize((String)this.testServer.getName()) + "'.");
            task.setGroup("verification");
            task.setTestServer(this.testServer);
            testedVariant.getArtifacts().setTaskInputToFinalProduct(SingleArtifact.APK.INSTANCE, task.getTestedApks());
            ((AndroidTestCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(SingleArtifact.APK.INSTANCE, task.getTestApks());
            if (!this.testServer.isConfigured()) {
                task.setEnabled(false);
            }
        }
    }
}

