/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.res.shrinker.LoggerAndFileDebugReporter;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerImpl;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.DexUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ResourceUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.build.gradle.internal.transforms.ResourceShrinkerParams;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR#\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/transforms/ResourceShrinkerParams;", "()V", "originalBundleFile", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getOriginalBundleFile", "()Ljava/io/File;", "originalBundleFile$delegate", "Lkotlin/Lazy;", "reportFile", "getReportFile", "reportFile$delegate", "shrunkBundleFile", "getShrunkBundleFile", "shrunkBundleFile$delegate", "execute", "", "Companion", "gradle-core"})
abstract class ShrinkAppBundleResourcesAction
implements WorkAction<ResourceShrinkerParams> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy originalBundleFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final File invoke() {
            return ((RegularFile)((ResourceShrinkerParams)this.this$0.getParameters()).getOriginalBundle().get()).getAsFile();
        }
    }));
    @NotNull
    private final Lazy shrunkBundleFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final File invoke() {
            return ((RegularFile)((ResourceShrinkerParams)this.this$0.getParameters()).getShrunkBundle().get()).getAsFile();
        }
    }));
    @NotNull
    private final Lazy reportFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final File invoke() {
            RegularFile regularFile = (RegularFile)((ResourceShrinkerParams)this.this$0.getParameters()).getReport().getOrNull();
            return regularFile != null ? regularFile.getAsFile() : null;
        }
    }));

    @Inject
    public ShrinkAppBundleResourcesAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() {
        Logger logger = Logging.getLogger(ShrinkAppBundleResourcesTask.class);
        Map allModules = (Map)((ResourceShrinkerParams)this.getParameters()).getModules().get();
        Closeable closeable = FileUtils.createZipFilesystem((Path)this.getOriginalBundleFile().toPath());
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            String[] dexPath;
            void $this$flatMapTo$iv$iv;
            ProguardMappingsRecorder proguardMappingsRecorder;
            Iterator it;
            Collection collection;
            Path $this$mapTo$iv$iv2;
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            String[] stringArray = new String[]{"com.android.tools.build.obfuscation", "proguard.map"};
            Path proguardMappings = fs.getPath("BUNDLE-METADATA", stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)allModules, (String)"allModules");
            Map $this$map$iv = allModules;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Unit unit = $this$mapTo$iv$iv2.entrySet().iterator();
            while (unit.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = unit.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String[] stringArray2 = new String[]{"resources.pb"};
                Path path = fs.getPath((String)it.getKey(), stringArray2);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fs.getPath(it.key, \"resources.pb\")");
                collection.add(new ProtoResourceTableGatherer(path));
            }
            List resourcesGatherers = (List)destination$iv$iv;
            Path it2 = $this$mapTo$iv$iv2 = proguardMappings;
            boolean bl3 = false;
            Path path = $i$f$map = Files.isRegularFile(it2, new LinkOption[0]) ? $this$mapTo$iv$iv2 : null;
            if ($i$f$map != null) {
                it2 = $i$f$map;
                boolean bl4 = false;
                proguardMappingsRecorder = new ProguardMappingsRecorder(it2);
            } else {
                proguardMappingsRecorder = null;
            }
            ProguardMappingsRecorder obfuscationMappingsRecorder = proguardMappingsRecorder;
            Map $this$flatMap$iv = allModules;
            boolean $i$f$flatMap = false;
            Map bl4 = $this$flatMap$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            it = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (it.hasNext()) {
                ResourceUsageRecorder resourceUsageRecorder;
                Map.Entry element$iv$iv;
                Map.Entry it3 = element$iv$iv = it.next();
                boolean bl5 = false;
                String[] stringArray3 = new String[]{"dex"};
                dexPath = fs.getPath((String)it3.getKey(), stringArray3);
                String[] stringArray4 = new String[]{"res", "raw"};
                Path rawResourcesPath = fs.getPath((String)it3.getKey(), stringArray4);
                Object[] objectArray = new String[]{"manifest", "AndroidManifest.xml"};
                Path manifest = fs.getPath((String)it3.getKey(), (String[])objectArray);
                objectArray = new ResourceUsageRecorder[3];
                Intrinsics.checkNotNullExpressionValue((Object)dexPath, (String)"dexPath");
                DexUsageRecorder dexUsageRecorder = resourceUsageRecorder = new DexUsageRecorder((Path)dexPath);
                int n = 0;
                Object[] objectArray2 = objectArray;
                boolean bl6 = false;
                boolean bl7 = Files.isDirectory((Path)dexPath, new LinkOption[0]);
                objectArray2[n] = bl7 ? resourceUsageRecorder : null;
                Object it4 = new String[]{"res", "raw"};
                Path path2 = fs.getPath((String)it3.getKey(), (String)it4);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fs.getPath(it.key, \"res\", \"raw\")");
                resourceUsageRecorder = new ToolsAttributeUsageRecorder(path2);
                it4 = resourceUsageRecorder;
                n = 1;
                objectArray2 = objectArray;
                boolean bl8 = false;
                bl7 = Files.isDirectory(rawResourcesPath, new LinkOption[0]);
                objectArray2[n] = bl7 ? resourceUsageRecorder : null;
                Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
                objectArray[2] = new ProtoAndroidManifestUsageRecorder(manifest);
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List usageRecorders = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2));
            Map $this$map$iv2 = allModules;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it5;
                Map.Entry item$iv$iv;
                Map.Entry bl5 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv3;
                boolean bl9 = false;
                dexPath = new String[]{"res"};
                Path path3 = fs.getPath((String)it5.getKey(), dexPath);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"fs.getPath(it.key, \"res\")");
                dexPath = new String[]{"resources.pb"};
                Path path4 = fs.getPath((String)it5.getKey(), dexPath);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"fs.getPath(it.key, \"resources.pb\")");
                collection.add(new ProtoResourcesGraphBuilder(path3, path4));
            }
            List graphBuilders = (List)destination$iv$iv3;
            ObfuscationMappingsRecorder obfuscationMappingsRecorder2 = obfuscationMappingsRecorder;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            ShrinkerDebugReporter shrinkerDebugReporter = new LoggerAndFileDebugReporter(logger, this.getReportFile());
            Object object = ((ResourceShrinkerParams)this.getParameters()).getUsePreciseShrinking().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.usePreciseShrinking.get()");
            AutoCloseable autoCloseable = new ResourceShrinkerImpl(resourcesGatherers, obfuscationMappingsRecorder2, usageRecorders, graphBuilders, shrinkerDebugReporter, true, (Boolean)object);
            Throwable throwable2 = null;
            try {
                ResourceShrinkerImpl shrinker = (ResourceShrinkerImpl)autoCloseable;
                boolean bl10 = false;
                shrinker.analyze();
                File file = this.getOriginalBundleFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"originalBundleFile");
                File file2 = this.getShrunkBundleFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"shrunkBundleFile");
                shrinker.rewriteResourcesInBundleFormat(file, file2, allModules);
                if (shrinker.getUnusedResourceCount() > 0) {
                    long before = this.getOriginalBundleFile().length();
                    long after = this.getShrunkBundleFile().length();
                    int percent = (int)((before - after) * (long)100 / before);
                    String stat = "Removed unused resources: Binary bundle size reduced from " + ShrinkAppBundleResourcesAction.Companion.toKbString(before) + "KB to " + ShrinkAppBundleResourcesAction.Companion.toKbString(after) + "KB. Removed " + percent + "%";
                    logger.info(stat);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File getOriginalBundleFile() {
        Lazy lazy = this.originalBundleFile$delegate;
        return (File)lazy.getValue();
    }

    private final File getShrunkBundleFile() {
        Lazy lazy = this.shrunkBundleFile$delegate;
        return (File)lazy.getValue();
    }

    private final File getReportFile() {
        Lazy lazy = this.reportFile$delegate;
        return (File)lazy.getValue();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesAction$Companion;", "", "()V", "toKbString", "", "size", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String toKbString(long size) {
            return String.valueOf((int)size / 1024);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

