/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import com.android.build.gradle.internal.test.report.TextReportRenderer;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.reporting.ReportRenderer;

public class HtmlReportRenderer {
    private final Set<URL> resources = new HashSet<URL>();

    public void requireResource(URL resource) {
        this.resources.add(resource);
    }

    public <T> TextReportRenderer<T> renderer(ReportRenderer<T, SimpleHtmlWriter> renderer) {
        return this.renderer(new TextReportRendererImpl<T>(renderer));
    }

    public <T> TextReportRenderer<T> renderer(final TextReportRendererImpl<T> renderer) {
        return new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T model, Writer out) throws Exception {
                renderer.writeTo(model, out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(T model, File file) {
                super.writeTo(model, file);
                for (URL resource : HtmlReportRenderer.this.resources) {
                    String name = HtmlReportRenderer.substringAfterLast(resource.getPath(), "/");
                    String type = HtmlReportRenderer.substringAfterLast(resource.getPath(), ".");
                    File destFile = new File(file.getParentFile(), String.format("%s/%s", type, name));
                    if (destFile.exists()) continue;
                    destFile.getParentFile().mkdirs();
                    try {
                        URLConnection urlConnection = resource.openConnection();
                        urlConnection.setUseCaches(false);
                        InputStream inputStream = null;
                        try {
                            inputStream = urlConnection.getInputStream();
                            OutputStream outputStream = null;
                            try {
                                outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
                                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                            }
                            finally {
                                if (outputStream == null) continue;
                                outputStream.close();
                            }
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static String substringAfterLast(String string, String separator) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)separator);
        int pos = string.lastIndexOf(separator);
        if (pos == -1 || pos == string.length() - separator.length()) {
            return "";
        }
        return string.substring(pos + separator.length());
    }

    private static class TextReportRendererImpl<T>
    extends TextReportRenderer<T> {
        private final ReportRenderer<T, SimpleHtmlWriter> delegate;

        private TextReportRendererImpl(ReportRenderer<T, SimpleHtmlWriter> delegate2) {
            this.delegate = delegate2;
        }

        @Override
        protected void writeTo(T model, Writer writer) throws Exception {
            SimpleHtmlWriter htmlWriter = new SimpleHtmlWriter(writer, "");
            htmlWriter.startElement("html");
            this.delegate.render(model, (Object)htmlWriter);
            htmlWriter.endElement();
        }
    }
}

