/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.Version;
import com.android.build.api.attributes.AgpVersionAttr;
import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.core.dsl.ComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.PublishableComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.VariantDslInfo;
import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.dsl.ModulePropertyKeys;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.services.StringCachingBuildService;
import com.android.build.gradle.internal.testFixtures.TestFixturesUtil;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public class VariantDependenciesBuilder {
    private final Project project;
    private final ProjectOptions projectOptions;
    private final IssueReporter issueReporter;
    private final ComponentDslInfo dslInfo;
    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection;
    private final Set<Configuration> compileClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> apiClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> implementationConfigurations = Sets.newLinkedHashSet();
    private final Set<Configuration> runtimeClasspaths = Sets.newLinkedHashSet();
    private final Set<Configuration> annotationConfigs = Sets.newLinkedHashSet();
    private final Set<Configuration> wearAppConfigs = Sets.newLinkedHashSet();
    private VariantCreationConfig mainVariant;
    private VariantCreationConfig testedVariant;
    private String overrideVariantNameAttribute = null;
    private boolean testFixturesEnabled;
    private Set<String> featureList;

    public static VariantDependenciesBuilder builder(Project project2, ProjectOptions projectOptions, IssueReporter errorReporter, ComponentDslInfo dslInfo) {
        return new VariantDependenciesBuilder(project2, projectOptions, errorReporter, dslInfo);
    }

    protected VariantDependenciesBuilder(Project project2, ProjectOptions projectOptions, IssueReporter issueReporter2, ComponentDslInfo dslInfo) {
        this.project = project2;
        this.projectOptions = projectOptions;
        this.issueReporter = issueReporter2;
        this.dslInfo = dslInfo;
    }

    public VariantDependenciesBuilder addSourceSets(DefaultAndroidSourceSet ... sourceSets) {
        for (DefaultAndroidSourceSet sourceSet : sourceSets) {
            this.addSourceSet(sourceSet);
        }
        return this;
    }

    public VariantDependenciesBuilder addSourceSets(Collection<DefaultAndroidSourceSet> sourceSets) {
        for (DefaultAndroidSourceSet sourceSet : sourceSets) {
            this.addSourceSet(sourceSet);
        }
        return this;
    }

    public VariantDependenciesBuilder setTestFixturesEnabled(boolean testFixturesEnabled) {
        this.testFixturesEnabled = testFixturesEnabled;
        return this;
    }

    public VariantDependenciesBuilder overrideVariantNameAttribute(String name) {
        this.overrideVariantNameAttribute = name;
        return this;
    }

    public VariantDependenciesBuilder setTestedVariant(VariantCreationConfig testedVariant) {
        this.testedVariant = testedVariant;
        return this;
    }

    public VariantDependenciesBuilder setMainVariant(VariantCreationConfig mainVariant) {
        this.mainVariant = mainVariant;
        return this;
    }

    public VariantDependenciesBuilder setFeatureList(Set<String> featureList) {
        this.featureList = featureList;
        return this;
    }

    public VariantDependenciesBuilder addSourceSet(DefaultAndroidSourceSet sourceSet) {
        if (sourceSet != null) {
            ConfigurationContainer configs = this.project.getConfigurations();
            this.compileClasspaths.add(configs.getByName(sourceSet.getCompileOnlyConfigurationName()));
            this.runtimeClasspaths.add(configs.getByName(sourceSet.getRuntimeOnlyConfigurationName()));
            Configuration implementationConfig = configs.getByName(sourceSet.getImplementationConfigurationName());
            this.compileClasspaths.add(implementationConfig);
            this.runtimeClasspaths.add(implementationConfig);
            this.implementationConfigurations.add(implementationConfig);
            Configuration apiConfig = (Configuration)configs.findByName(sourceSet.getApiConfigurationName());
            if (apiConfig != null) {
                this.apiClasspaths.add(apiConfig);
            }
            this.annotationConfigs.add(configs.getByName(sourceSet.getAnnotationProcessorConfigurationName()));
            this.wearAppConfigs.add(configs.getByName(sourceSet.getWearAppConfigurationName()));
        }
        return this;
    }

    public VariantDependenciesBuilder setFlavorSelection(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
        this.flavorSelection = flavorSelection;
        return this;
    }

    public VariantDependencies build() {
        Configuration providedClasspath;
        ObjectFactory factory2 = this.project.getObjects();
        Usage apiUsage = (Usage)factory2.named(Usage.class, "java-api");
        Usage runtimeUsage = (Usage)factory2.named(Usage.class, "java-runtime");
        Usage reverseMetadataUsage = (Usage)factory2.named(Usage.class, "android-reverse-meta-data");
        TargetJvmEnvironment jvmEnvironment = (TargetJvmEnvironment)factory2.named(TargetJvmEnvironment.class, "android");
        AgpVersionAttr agpVersion = (AgpVersionAttr)factory2.named(AgpVersionAttr.class, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        String variantName = this.dslInfo.getComponentIdentity().getName();
        ComponentType componentType = this.dslInfo.getComponentType();
        String buildType = this.dslInfo.getComponentIdentity().getBuildType();
        Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> consumptionFlavorMap = this.getConsumptionFlavorAttributes(this.flavorSelection);
        ConfigurationContainer configurations = this.project.getConfigurations();
        DependencyHandler dependencies2 = this.project.getDependencies();
        String compileClasspathName = variantName + "CompileClasspath";
        Configuration compileClasspath2 = (Configuration)configurations.maybeCreate(compileClasspathName);
        compileClasspath2.setVisible(false);
        compileClasspath2.setDescription("Resolved configuration for compilation for variant: " + variantName);
        compileClasspath2.setExtendsFrom(this.compileClasspaths);
        if (this.testedVariant != null) {
            for (Configuration configuration2 : this.testedVariant.getVariantDependencies().getSourceSetImplementationConfigurations()) {
                compileClasspath2.extendsFrom(new Configuration[]{configuration2});
            }
            if (this.testFixturesEnabled) {
                dependencies2.add(compileClasspath2.getName(), (Object)dependencies2.testFixtures((Object)this.project));
            }
            compileClasspath2.getDependencies().add((Object)dependencies2.create((Object)this.project));
        }
        if (componentType.isTestFixturesComponent()) {
            if (this.mainVariant.getComponentType().isAar()) {
                this.apiClasspaths.forEach(apiConfiguration -> apiConfiguration.getDependencies().add((Object)dependencies2.create((Object)this.project)));
            } else {
                compileClasspath2.getDependencies().add((Object)dependencies2.create((Object)this.project));
            }
        }
        compileClasspath2.setCanBeConsumed(false);
        compileClasspath2.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
        AttributeContainer compileAttributes = compileClasspath2.getAttributes();
        this.applyVariantAttributes(compileAttributes, buildType, consumptionFlavorMap);
        compileAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        compileAttributes.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)jvmEnvironment);
        compileAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
        Configuration annotationProcessor2 = (Configuration)configurations.maybeCreate(variantName + "AnnotationProcessorClasspath");
        annotationProcessor2.setVisible(false);
        annotationProcessor2.setDescription("Resolved configuration for annotation-processor for variant: " + variantName);
        annotationProcessor2.setExtendsFrom(this.annotationConfigs);
        annotationProcessor2.setCanBeConsumed(false);
        AttributeContainer annotationAttributes = annotationProcessor2.getAttributes();
        annotationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        annotationAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
        this.applyVariantAttributes(annotationAttributes, buildType, consumptionFlavorMap);
        String runtimeClasspathName = variantName + "RuntimeClasspath";
        Configuration runtimeClasspath = (Configuration)configurations.maybeCreate(runtimeClasspathName);
        runtimeClasspath.setVisible(false);
        runtimeClasspath.setDescription("Resolved configuration for runtime for variant: " + variantName);
        runtimeClasspath.setExtendsFrom(this.runtimeClasspaths);
        if (this.testedVariant != null) {
            if (this.testFixturesEnabled) {
                dependencies2.add(runtimeClasspath.getName(), (Object)dependencies2.testFixtures((Object)this.project));
            }
            if (this.testedVariant.getComponentType().isAar() || !this.dslInfo.getComponentType().isApk()) {
                runtimeClasspath.getDependencies().add((Object)dependencies2.create((Object)this.project));
            }
        }
        runtimeClasspath.setCanBeConsumed(false);
        runtimeClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
        AttributeContainer runtimeAttributes = runtimeClasspath.getAttributes();
        this.applyVariantAttributes(runtimeAttributes, buildType, consumptionFlavorMap);
        runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        runtimeAttributes.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)jvmEnvironment);
        runtimeAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
        if (this.projectOptions.get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS)) {
            Provider stringCachingService = new StringCachingBuildService.RegistrationAction(this.project).execute();
            ConstraintHandler.alignWith(compileClasspath2, runtimeClasspath, dependencies2, false, stringCachingService);
            if (componentType.isApk() && this.testedVariant != null) {
                Configuration testedRuntimeClasspath = this.testedVariant.getVariantDependencies().getRuntimeClasspath();
                ConstraintHandler.alignWith(runtimeClasspath, testedRuntimeClasspath, dependencies2, true, stringCachingService);
            }
        }
        Configuration globalTestedApks = (Configuration)configurations.findByName("testedApks");
        if (componentType.isApk() && globalTestedApks != null) {
            Configuration testedApks = (Configuration)configurations.maybeCreate(StringHelper.appendCapitalized((String)variantName, (String)"testedApks"));
            testedApks.setVisible(false);
            testedApks.setDescription("Resolved configuration for tested apks for variant: " + variantName);
            testedApks.extendsFrom(new Configuration[]{globalTestedApks});
            AttributeContainer testedApksAttributes = testedApks.getAttributes();
            this.applyVariantAttributes(testedApksAttributes, buildType, consumptionFlavorMap);
            testedApksAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            testedApksAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
            providedClasspath = testedApks;
        } else {
            providedClasspath = runtimeClasspath;
        }
        Configuration reverseMetadataValues = null;
        Configuration wearApp = null;
        HashMap elements = Maps.newHashMap();
        if (componentType.isBaseModule()) {
            wearApp = (Configuration)configurations.maybeCreate(variantName + "WearBundling");
            wearApp.setDescription("Resolved Configuration for wear app bundling for variant: " + variantName);
            wearApp.setExtendsFrom(this.wearAppConfigs);
            wearApp.setCanBeConsumed(false);
            AttributeContainer wearAttributes = wearApp.getAttributes();
            this.applyVariantAttributes(wearAttributes, buildType, consumptionFlavorMap);
            wearAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            wearAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
        }
        VariantAttr variantNameAttr = (VariantAttr)factory2.named(VariantAttr.class, this.overrideVariantNameAttribute != null ? this.overrideVariantNameAttribute : variantName);
        Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap = this.getElementsPublicationFlavorAttributes();
        if (componentType.getPublishToOtherModules()) {
            Configuration runtimeElements = this.createPublishingConfig(configurations, variantName + "RuntimeElements", "Runtime elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, runtimeUsage, null, agpVersion);
            runtimeElements.extendsFrom(new Configuration[]{runtimeClasspath});
            elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS), runtimeElements);
            Configuration apiElements = this.createPublishingConfig(configurations, variantName + "ApiElements", "API elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, apiUsage, null, agpVersion);
            apiElements.setExtendsFrom(this.apiClasspaths);
            elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.API_ELEMENTS), apiElements);
        }
        if (componentType.getPublishToRepository()) {
            VariantPublishingInfo variantPublish = ((PublishableComponentDslInfo)((Object)this.dslInfo)).getPublishInfo();
            if (componentType.isAar()) {
                LibraryElements aar = (LibraryElements)factory2.named(LibraryElements.class, AndroidArtifacts.ArtifactType.AAR.getType());
                LibraryElements jar = (LibraryElements)factory2.named(LibraryElements.class, "jar");
                Bundling bundling = (Bundling)factory2.named(Bundling.class, "external");
                Category library = (Category)factory2.named(Category.class, "library");
                Category documentation = (Category)factory2.named(Category.class, "documentation");
                DocsType sources2 = (DocsType)factory2.named(DocsType.class, "sources");
                DocsType javaDoc = (DocsType)factory2.named(DocsType.class, "javadoc");
                for (ComponentPublishingInfo component2 : variantPublish.getComponents()) {
                    String buildTypeAttribute = null;
                    HashMap flavorAttributes = Maps.newHashMap();
                    if (component2.getAttributesConfig() != null) {
                        buildTypeAttribute = component2.getAttributesConfig().getBuildType();
                        for (String dimensionName : component2.getAttributesConfig().getFlavorDimensions()) {
                            Attribute attribute = ProductFlavorAttr.of((String)dimensionName);
                            flavorAttributes.put(attribute, Objects.requireNonNull(publicationFlavorMap.get(attribute)));
                        }
                    }
                    String capitalizedComponentName = StringHelper.usLocaleCapitalize((String)component2.getComponentName());
                    Configuration apiPublication2 = this.createLibraryPublishingConfiguration(configurations, variantName + "Variant" + capitalizedComponentName + "ApiPublication", capitalizedComponentName + "component API publication for " + variantName, apiUsage, aar, bundling, library, null, buildTypeAttribute, flavorAttributes);
                    apiPublication2.setExtendsFrom(this.apiClasspaths);
                    elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.API_PUBLICATION, component2), apiPublication2);
                    Configuration runtimePublication2 = this.createLibraryPublishingConfiguration(configurations, variantName + "Variant" + capitalizedComponentName + "RuntimePublication", capitalizedComponentName + "Runtime publication for " + variantName, runtimeUsage, aar, bundling, library, null, buildTypeAttribute, flavorAttributes);
                    runtimePublication2.extendsFrom(new Configuration[]{runtimeClasspath});
                    elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION, component2), runtimePublication2);
                    if (component2.getWithSourcesJar()) {
                        Configuration sourcePublication = this.createLibraryPublishingConfiguration(configurations, variantName + "Variant" + capitalizedComponentName + "SourcePublication", capitalizedComponentName + "Source publication for" + variantName, runtimeUsage, jar, bundling, documentation, sources2, buildTypeAttribute, flavorAttributes);
                        elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.SOURCE_PUBLICATION, component2), sourcePublication);
                    }
                    if (!component2.getWithJavadocJar()) continue;
                    Configuration javaDocPublication = this.createLibraryPublishingConfiguration(configurations, variantName + "Variant" + capitalizedComponentName + "JavaDocPublication", capitalizedComponentName + "JavaDoc publication for" + variantName, runtimeUsage, jar, bundling, documentation, javaDoc, buildTypeAttribute, flavorAttributes);
                    elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.JAVA_DOC_PUBLICATION, component2), javaDocPublication);
                }
            } else {
                for (ComponentPublishingInfo component3 : variantPublish.getComponents()) {
                    if (component3.getType() == AbstractPublishing.Type.APK) {
                        Configuration apkPublication = this.createPublishingConfig(configurations, variantName + "ApkPublication", "APK publication for " + variantName, buildType, publicationFlavorMap, null, null, (LibraryElements)factory2.named(LibraryElements.class, AndroidArtifacts.ArtifactType.APK.getType()), null);
                        elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.APK_PUBLICATION, component3.getComponentName(), false), apkPublication);
                        apkPublication.setVisible(false);
                        apkPublication.setCanBeConsumed(false);
                        continue;
                    }
                    assert (component3.getType() == AbstractPublishing.Type.AAB) : "Publication artifact type for this application project is not APK or AAB.";
                    Configuration aabPublication = this.createPublishingConfig(configurations, variantName + "AabPublication", "Bundle Publication for " + variantName, buildType, publicationFlavorMap, null, null, (LibraryElements)factory2.named(LibraryElements.class, AndroidArtifacts.ArtifactType.BUNDLE.getType()), null);
                    elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION, component3.getComponentName(), false), aabPublication);
                    aabPublication.setVisible(false);
                    aabPublication.setCanBeConsumed(false);
                }
            }
        }
        if (componentType.getPublishToMetadata()) {
            Configuration reverseMetadataElements = this.createPublishingConfig(configurations, variantName + "ReverseMetadataElements", "Reverse Meta-data elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, reverseMetadataUsage, null, null);
            elements.put(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.REVERSE_METADATA_ELEMENTS), reverseMetadataElements);
        }
        if (componentType.isBaseModule()) {
            String reverseMetadataValuesName = variantName + "ReverseMetadataValues";
            reverseMetadataValues = (Configuration)configurations.maybeCreate(reverseMetadataValuesName);
            if (this.featureList != null) {
                ArrayList<String> notFound = new ArrayList<String>();
                for (String feature : this.featureList) {
                    Project p = this.project.findProject(feature);
                    if (p != null) {
                        dependencies2.add(reverseMetadataValuesName, (Object)p);
                        continue;
                    }
                    notFound.add(feature);
                }
                if (!notFound.isEmpty()) {
                    this.issueReporter.reportError(IssueReporter.Type.GENERIC, "Unable to find matching projects for Dynamic Features: " + notFound);
                }
            } else {
                reverseMetadataValues.extendsFrom(new Configuration[]{configurations.getByName("feature")});
            }
            reverseMetadataValues.setDescription("Metadata Values dependencies for the base Split");
            reverseMetadataValues.setCanBeConsumed(false);
            AttributeContainer reverseMetadataValuesAttributes = reverseMetadataValues.getAttributes();
            reverseMetadataValuesAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)reverseMetadataUsage);
            reverseMetadataValuesAttributes.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
            this.applyVariantAttributes(reverseMetadataValuesAttributes, buildType, consumptionFlavorMap);
        }
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Compile", compileClasspathName);
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Apk", runtimeClasspathName);
        VariantDependenciesBuilder.checkOldConfigurations(configurations, "_" + variantName + "Publish", runtimeClasspathName);
        if (componentType.isTestFixturesComponent()) {
            Capability capability = TestFixturesUtil.getTestFixturesCapabilityForProject(this.project);
            elements.forEach((publishedConfigType, configuration) -> configuration.getOutgoing().capability((Object)capability));
        }
        Map<Object, Object> experimentalProperties = this.dslInfo instanceof VariantDslInfo ? ((VariantDslInfo)this.dslInfo).getExperimentalProperties() : Collections.emptyMap();
        boolean isSelfInstrumenting = ModulePropertyKeys.SELF_INSTRUMENTING.getValueAsBoolean(experimentalProperties);
        return new VariantDependencies(variantName, this.dslInfo.getComponentType(), compileClasspath2, runtimeClasspath, this.runtimeClasspaths, this.implementationConfigurations, elements, providedClasspath, annotationProcessor2, reverseMetadataValues, wearApp, this.testedVariant, this.project, this.projectOptions, isSelfInstrumenting);
    }

    private Configuration createPublishingConfig(ConfigurationContainer configurations, String configName, String configDesc, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap, VariantAttr variantNameAttr, Usage usage, LibraryElements libraryElements, AgpVersionAttr agpVersion) {
        Configuration config2 = (Configuration)configurations.maybeCreate(configName);
        config2.setDescription(configDesc);
        config2.setCanBeResolved(false);
        AttributeContainer attrContainer = config2.getAttributes();
        this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
        if (variantNameAttr != null) {
            attrContainer.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
        }
        if (usage != null) {
            attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
        }
        if (libraryElements != null) {
            attrContainer.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)libraryElements);
        }
        if (agpVersion != null) {
            attrContainer.attribute(AgpVersionAttr.ATTRIBUTE, (Object)agpVersion);
        }
        return config2;
    }

    private Configuration createLibraryPublishingConfiguration(ConfigurationContainer configurations, String configName, String configDesc, Usage usage, LibraryElements libraryElements, Bundling bundling, Category category, DocsType docsType, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap) {
        Configuration config2 = (Configuration)configurations.maybeCreate(configName);
        config2.setDescription(configDesc);
        config2.setCanBeResolved(false);
        config2.setVisible(false);
        config2.setCanBeConsumed(false);
        AttributeContainer attrContainer = config2.getAttributes();
        attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
        attrContainer.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)bundling);
        attrContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)category);
        if (docsType != null) {
            attrContainer.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)docsType);
        } else {
            attrContainer.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)libraryElements);
        }
        Preconditions.checkNotNull(publicationFlavorMap);
        this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
        return config2;
    }

    private static void checkOldConfigurations(ConfigurationContainer configurations, String oldConfigName, String newConfigName) {
        if (configurations.findByName(oldConfigName) != null) {
            throw new RuntimeException(String.format("Configuration with old name %s found. Use new name %s instead.", oldConfigName, newConfigName));
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getConsumptionFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
        return this.getFlavorAttributes(flavorSelection, false);
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getElementsPublicationFlavorAttributes() {
        return this.getFlavorAttributes(null, true);
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection, boolean addCompatibilityUnprefixedFlavorDimensionAttributes) {
        List<ProductFlavor> productFlavors = this.dslInfo.getProductFlavorList();
        HashMap map = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
        if (this.issueReporter.hasIssue(IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            return map;
        }
        ObjectFactory objectFactory = this.project.getObjects();
        for (ProductFlavor f : productFlavors) {
            assert (f.getDimension() != null);
            map.put(ProductFlavorAttr.of((String)f.getDimension()), (ProductFlavorAttr)objectFactory.named(ProductFlavorAttr.class, f.getName()));
            if (!addCompatibilityUnprefixedFlavorDimensionAttributes) continue;
            map.put(Attribute.of((String)f.getDimension(), ProductFlavorAttr.class), (ProductFlavorAttr)objectFactory.named(ProductFlavorAttr.class, f.getName()));
        }
        if (flavorSelection != null) {
            map.putAll(flavorSelection);
        }
        return map;
    }

    private void applyVariantAttributes(AttributeContainer attributeContainer, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorMap2) {
        if (buildType != null) {
            attributeContainer.attribute(BuildTypeAttr.ATTRIBUTE, (Object)((BuildTypeAttr)this.project.getObjects().named(BuildTypeAttr.class, buildType)));
        }
        for (Map.Entry<Attribute<ProductFlavorAttr>, ProductFlavorAttr> entry : flavorMap2.entrySet()) {
            attributeContainer.attribute(entry.getKey(), (Object)entry.getValue());
        }
    }
}

