/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardRunnable;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.utils.IgnoreLibraryKeepRulesUtilsKt;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/tasks/ExportConsumerProguardFilesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "consumerProguardFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConsumerProguardFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "ignoreAllKeepRules", "Lorg/gradle/api/provider/Property;", "", "getIgnoreAllKeepRules", "()Lorg/gradle/api/provider/Property;", "ignoredKeepRules", "Lorg/gradle/api/provider/SetProperty;", "", "getIgnoredKeepRules", "()Lorg/gradle/api/provider/SetProperty;", "inputFiles", "getInputFiles", "<set-?>", "isBaseModule", "()Z", "isDynamicFeature", "Lorg/gradle/api/artifacts/ArtifactCollection;", "libraryKeepRules", "getLibraryKeepRules", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "outputDir", "getOutputDir", "doTaskAction", "", "Companion", "CreationAction", "gradle-core"})
public abstract class ExportConsumerProguardFilesTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isBaseModule;
    private boolean isDynamicFeature;
    private ArtifactCollection libraryKeepRules;

    @Input
    public final boolean isBaseModule() {
        return this.isBaseModule;
    }

    @Input
    public final boolean isDynamicFeature() {
        return this.isDynamicFeature;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getInputFiles();

    @Input
    @Optional
    @NotNull
    public abstract SetProperty<String> getIgnoredKeepRules();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getIgnoreAllKeepRules();

    @Internal
    @NotNull
    public final ArtifactCollection getLibraryKeepRules() {
        ArtifactCollection artifactCollection = this.libraryKeepRules;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryKeepRules");
        return null;
    }

    @Internal(value="only for task execution")
    @NotNull
    public abstract DirectoryProperty getBuildDirectory();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Override
    public void doTaskAction() {
        FileCollection fileCollection2;
        if (!this.isBaseModule) {
            DirectoryProperty directoryProperty = this.getBuildDirectory();
            Set set = this.getConsumerProguardFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"consumerProguardFiles.files");
            Companion.checkProguardFiles(directoryProperty, this.isDynamicFeature, set, doTaskAction.1.INSTANCE);
        }
        if (this.isDynamicFeature) {
            Object object = this.getIgnoredKeepRules().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoredKeepRules.get()");
            Set set = (Set)object;
            Object object2 = this.getIgnoreAllKeepRules().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ignoreAllKeepRules.get()");
            boolean bl = (Boolean)object2;
            ArtifactCollection artifactCollection = this.getLibraryKeepRules();
            ConfigurableFileCollection configurableFileCollection = this.getInputFiles();
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(ExportConsumerProguardFilesTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(ExportConsumer\u2026ardFilesTask::class.java)");
            fileCollection2 = IgnoreLibraryKeepRulesUtilsKt.getFilteredConfigurationFiles(set, bl, artifactCollection, configurableFileCollection, loggerWrapper);
        } else {
            fileCollection2 = (FileCollection)this.getInputFiles();
        }
        FileCollection filteredProguardFiles = fileCollection2;
        this.getWorkerExecutor().noIsolation().submit(ExportConsumerProguardRunnable.class, new Action(this, filteredProguardFiles){
            final /* synthetic */ ExportConsumerProguardFilesTask this$0;
            final /* synthetic */ FileCollection $filteredProguardFiles;
            {
                this.this$0 = $receiver;
                this.$filteredProguardFiles = $filteredProguardFiles;
            }

            public final void execute(ExportConsumerProguardRunnable.Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{this.$filteredProguardFiles};
                it.getInput().from(objectArray);
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
            }
        });
    }

    @JvmStatic
    public static final void checkProguardFiles(@NotNull DirectoryProperty buildDirectory, boolean isDynamicFeature, @NotNull Collection<? extends File> consumerProguardFiles2, @NotNull Consumer<String> exceptionHandler) {
        Companion.checkProguardFiles(buildDirectory, isDynamicFeature, consumerProguardFiles2, exceptionHandler);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ExportConsumerProguardFilesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExportConsumerProguardFilesTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExportConsumerProguardFilesTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("export", "ConsumerProguardFiles");
        }

        @Override
        @NotNull
        public Class<ExportConsumerProguardFilesTask> getType() {
            return ExportConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExportConsumerProguardFilesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.CONSUMER_PROGUARD_DIR.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExportConsumerProguardFilesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{((VariantCreationConfig)this.creationConfig).getConsumerProguardFiles()};
            task.getConsumerProguardFiles().from(objectArray);
            task.isBaseModule = ((VariantCreationConfig)this.creationConfig).getComponentType().isBaseModule();
            task.isDynamicFeature = ((VariantCreationConfig)this.creationConfig).getComponentType().isDynamicFeature();
            objectArray = new Object[]{task.getConsumerProguardFiles(), ((VariantCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE)};
            task.getInputFiles().from(objectArray);
            if (((VariantCreationConfig)this.creationConfig).getComponentType().isDynamicFeature()) {
                task.libraryKeepRules = VariantDependencies.getArtifactCollection$default(((VariantCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES, null, 8, null);
                objectArray = new Object[]{task.getLibraryKeepRules().getArtifactFiles()};
                task.getInputFiles().from(objectArray);
                HasConfigurableValuesKt.setDisallowChanges(task.getIgnoredKeepRules(), ((VariantCreationConfig)this.creationConfig).getIgnoredLibraryKeepRules());
                HasConfigurableValuesKt.setDisallowChanges(task.getIgnoreAllKeepRules(), ((VariantCreationConfig)this.creationConfig).getIgnoreAllLibraryKeepRules());
            }
            Property property = (Property)task.getBuildDirectory();
            DirectoryProperty directoryProperty = task.getProject().getLayout().getBuildDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"task.project.layout.buildDirectory");
            HasConfigurableValuesKt.setDisallowChanges(property, (Provider)directoryProperty);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ExportConsumerProguardFilesTask$Companion;", "", "()V", "checkProguardFiles", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "isDynamicFeature", "", "consumerProguardFiles", "", "Ljava/io/File;", "exceptionHandler", "Ljava/util/function/Consumer;", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void checkProguardFiles(@NotNull DirectoryProperty buildDirectory, boolean isDynamicFeature, @NotNull Collection<? extends File> consumerProguardFiles2, @NotNull Consumer<String> exceptionHandler) {
            ImmutableMap.Builder builder;
            Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
            Intrinsics.checkNotNullParameter(consumerProguardFiles2, (String)"consumerProguardFiles");
            Intrinsics.checkNotNullParameter(exceptionHandler, (String)"exceptionHandler");
            boolean $i$f$immutableMapBuilder = false;
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder()");
            ImmutableMap.Builder $this$checkProguardFiles_u24lambda_u2d0 = builder = builder2;
            boolean bl = false;
            for (String knownFileName : ProguardFiles.KNOWN_FILE_NAMES) {
                $this$checkProguardFiles_u24lambda_u2d0.put((Object)ProguardFiles.getDefaultProguardFile(knownFileName, buildDirectory), (Object)knownFileName);
            }
            ImmutableMap immutableMap = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"builder.build()");
            ImmutableMap defaultFiles = immutableMap;
            for (File file : consumerProguardFiles2) {
                if (!defaultFiles.containsKey((Object)file)) continue;
                String errorMessage = isDynamicFeature ? "Default file " + defaultFiles.get((Object)file) + " should not be specified in this module. It can be specified in the base module instead." : "Default file " + defaultFiles.get((Object)file) + " should not be used as a consumer configuration file.";
                exceptionHandler.accept(errorMessage);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

