/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\n\u001a\u00020\u000b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\t\u001a\u0004\u0018\u00010\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "namespace", "Lorg/gradle/api/provider/Provider;", "", "creationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/file/Directory;", "moduleName", "apkBundle", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "getApkBundle", "()Lorg/gradle/api/file/FileCollection;", "libraryType", "", "getLibraryType", "()Lorg/gradle/api/provider/Provider;", "getModuleName", "()Ljava/lang/String;", "findTestedApks", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class BundleTestDataImpl
extends AbstractTestDataImpl {
    @Nullable
    private final String moduleName;
    @NotNull
    private final FileCollection apkBundle;
    @NotNull
    private final Provider<Boolean> libraryType;

    public BundleTestDataImpl(@NotNull Provider<String> namespace2, @NotNull AndroidTestCreationConfig creationConfig, @NotNull Provider<Directory> testApkDir, @Nullable String moduleName, @NotNull FileCollection apkBundle) {
        Intrinsics.checkNotNullParameter(namespace2, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter(testApkDir, (String)"testApkDir");
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        super(namespace2, creationConfig, testApkDir, null);
        this.moduleName = moduleName;
        this.apkBundle = apkBundle;
        this.libraryType = creationConfig.getServices().provider(libraryType.1.INSTANCE);
    }

    @Input
    @Optional
    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public final FileCollection getApkBundle() {
        return this.apkBundle;
    }

    @Override
    @NotNull
    public Provider<Boolean> getLibraryType() {
        return this.libraryType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> findTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (this.moduleName != null && deviceConfigProvider.getApiLevel() < 21) {
            logger.warning("Testing dynamic features on devices API < 21 is not currently supported.", new Object[0]);
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of<File>()");
            return (List)immutableList;
        }
        Path path = this.apkBundle.getSingleFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"apkBundle.singleFile.toPath()");
        Iterable $this$map$iv = BundleInstallUtils.getApkFiles(path, deviceConfigProvider, this.moduleName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toFile());
        }
        return (List)GuavaKtxKt.toImmutableList((List)destination$iv$iv);
    }
}

