/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.ApplicationVariantBuilder;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AnchorTaskNames;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.ApplicationTaskManager;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.BundleIdeModelProducerTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.CompileArtProfileTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.GeneratePrivacySandboxSdkRuntimeConfigFile;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.ListingFileRedirectTask;
import com.android.build.gradle.internal.tasks.MergeArtProfileTask;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureNamespacesTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BuildPrivacySandboxSdkApks;
import com.android.build.gradle.tasks.sync.AppIdListTask;
import com.android.build.gradle.tasks.sync.ApplicationVariantModelTask;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B[\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001c\u0010\u0017\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0002J\u001c\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0014J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/tasks/ApplicationTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/ApplicationVariantBuilder;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "project", "Lorg/gradle/api/Project;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "localConfig", "Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;", "extension", "Lcom/android/build/gradle/BaseExtension;", "(Lorg/gradle/api/Project;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;Lcom/android/build/gradle/BaseExtension;)V", "createAssetPackTasks", "", "appVariant", "createDynamicBundleTask", "variantInfo", "createGenerateMicroApkDataTask", "config", "Lorg/gradle/api/file/FileCollection;", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "createSoftwareComponent", "componentName", "", "publication", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$PublishedConfigType;", "createTopLevelTasks", "componentType", "Lcom/android/builder/core/ComponentType;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "doCreateTasksForVariant", "handleMicroApp", "gradle-core"})
public final class ApplicationTaskManager
extends AbstractAppTaskManager<ApplicationVariantBuilder, ApplicationCreationConfig> {
    @NotNull
    private final Collection<ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig>> variants;

    public ApplicationTaskManager(@NotNull Project project2, @NotNull Collection<? extends ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents, @NotNull GlobalTaskCreationConfig globalConfig2, @NotNull TaskManagerConfig localConfig, @NotNull BaseExtension extension2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        Intrinsics.checkNotNullParameter((Object)localConfig, (String)"localConfig");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        super(project2, variants, testComponents, testFixturesComponents, globalConfig2, localConfig, extension2);
        this.variants = variants;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createTopLevelTasks(@NotNull ComponentType componentType, @NotNull VariantModel variantModel) {
        Map map;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
        super.createTopLevelTasks(componentType, variantModel);
        Iterable iterable = this.variants;
        GlobalTaskCreationConfig globalTaskCreationConfig = this.globalConfig;
        TaskFactory taskFactory = this.taskFactory;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ComponentInfo it = (ComponentInfo)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((ApplicationCreationConfig)it.getVariant()).getName(), ((ApplicationCreationConfig)it.getVariant()).getApplicationId());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = map = destination$iv$iv;
        GlobalTaskCreationConfig globalTaskCreationConfig2 = globalTaskCreationConfig;
        taskFactory.register(new AppIdListTask.CreationAction(globalTaskCreationConfig2, map3));
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig> variantInfo) {
        Intrinsics.checkNotNullParameter(variantInfo, (String)"variantInfo");
        this.createCommonTasks(variantInfo);
        ApplicationCreationConfig variant2 = variantInfo.getVariant();
        this.taskFactory.register(new ApplicationVariantModelTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variant2));
        this.createValidateSigningTask(variant2);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variant2));
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(variant2));
        TaskProvider[] taskProviderArray = new TaskProvider[]{variant2.getTaskContainer().getPreBuildTask()};
        TaskFactoryUtils.dependsOn(this.taskFactory.register(new AppMetadataTask.CreationAction(variant2)), taskProviderArray);
        if (!((Collection)this.globalConfig.getAssetPacks()).isEmpty()) {
            this.createAssetPackTasks(variant2);
        }
        this.taskFactory.register(new MergeArtProfileTask.CreationAction(variant2));
        this.taskFactory.register(new CompileArtProfileTask.CreationAction(variant2));
        if (variant2.getBuildFeatures().getDataBinding() && this.globalConfig.getHasDynamicFeatures()) {
            this.taskFactory.register(new DataBindingExportFeatureNamespacesTask.CreationAction(variant2));
        }
        this.createDynamicBundleTask(variantInfo);
        this.handleMicroApp(variant2);
        VariantPublishingInfo variantPublishingInfo = variant2.getPublishInfo();
        Intrinsics.checkNotNull((Object)variantPublishingInfo);
        VariantPublishingInfo publishInfo = variantPublishingInfo;
        for (ComponentPublishingInfo component2 : publishInfo.getComponents()) {
            AndroidArtifacts.PublishedConfigType configType = component2.getType() == AbstractPublishing.Type.APK ? AndroidArtifacts.PublishedConfigType.APK_PUBLICATION : AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION;
            this.createSoftwareComponent(variant2, component2.getComponentName(), configType);
        }
    }

    private final void handleMicroApp(ApplicationCreationConfig appVariant) {
        ComponentType componentType = appVariant.getComponentType();
        if (componentType.isBaseModule()) {
            Boolean unbundledWearApp = appVariant.isWearAppUnbundled();
            if (!Intrinsics.areEqual((Object)unbundledWearApp, (Object)true) && appVariant.getEmbedsMicroApp()) {
                Configuration configuration = appVariant.getVariantDependencies().getWearAppConfiguration();
                if (configuration == null) {
                    throw new IllegalStateException("Wear app with no wearApp configuration".toString());
                }
                Configuration wearApp = configuration;
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact2 = handleMicroApp.setApkArtifact.1.INSTANCE;
                    FileCollection files2 = wearApp.getIncoming().artifactView(new Action((Action<AttributeContainer>)setApkArtifact2){
                        final /* synthetic */ Action<AttributeContainer> $setApkArtifact;
                        {
                            this.$setApkArtifact = $setApkArtifact;
                        }

                        public final void execute(@NotNull ArtifactView.ViewConfiguration config2) {
                            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                            config2.attributes(this.$setApkArtifact);
                        }
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(appVariant, files2);
                }
            } else if (Intrinsics.areEqual((Object)unbundledWearApp, (Object)true)) {
                ApplicationTaskManager.createGenerateMicroApkDataTask$default(this, appVariant, null, 2, null);
            }
        }
    }

    private final void createGenerateMicroApkDataTask(ApplicationCreationConfig appVariant, FileCollection config2) {
        TaskProvider generateMicroApkTask = this.taskFactory.register(new GenerateApkDataTask.CreationAction(appVariant, config2));
        TaskProvider[] taskProviderArray = new TaskProvider[]{generateMicroApkTask};
        TaskFactoryUtils.dependsOn(appVariant.getTaskContainer().getResourceGenTask(), taskProviderArray);
    }

    static /* synthetic */ void createGenerateMicroApkDataTask$default(ApplicationTaskManager applicationTaskManager, ApplicationCreationConfig applicationCreationConfig, FileCollection fileCollection2, int n, Object object) {
        if ((n & 2) != 0) {
            fileCollection2 = null;
        }
        applicationTaskManager.createGenerateMicroApkDataTask(applicationCreationConfig, fileCollection2);
    }

    private final void createAssetPackTasks(ApplicationCreationConfig appVariant) {
        Configuration assetPackFilesConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackManifest");
        Set<String> assetPacks = this.globalConfig.getAssetPacks();
        IssueReporter issueReporter2 = appVariant.getServices().getIssueReporter();
        Intrinsics.checkNotNullExpressionValue((Object)assetPackFilesConfiguration, (String)"assetPackFilesConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)assetPackManifestConfiguration, (String)"assetPackManifestConfiguration");
        AssetPackUtilKt.populateAssetPacksConfigurations(this.project, issueReporter2, assetPacks, assetPackFilesConfiguration, assetPackManifestConfiguration);
        if (!((Collection)assetPacks).isEmpty()) {
            ArtifactCollection assetPackManifest = assetPackManifestConfiguration.getIncoming().getArtifacts();
            FileCollection assetFiles = assetPackFilesConfiguration.getIncoming().getFiles();
            ApkCreationConfig apkCreationConfig = appVariant;
            Intrinsics.checkNotNullExpressionValue((Object)assetPackManifest, (String)"assetPackManifest");
            this.taskFactory.register(new ProcessAssetPackManifestTask.CreationAction(apkCreationConfig, assetPackManifest));
            this.taskFactory.register(new LinkManifestForAssetPackTask.CreationAction(appVariant));
            VariantCreationConfig variantCreationConfig = appVariant;
            Intrinsics.checkNotNullExpressionValue((Object)assetFiles, (String)"assetFiles");
            this.taskFactory.register(new AssetPackPreBundleTask.CreationAction(variantCreationConfig, assetFiles));
        }
    }

    private final void createDynamicBundleTask(ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig> variantInfo) {
        ApplicationCreationConfig variant2 = variantInfo.getVariant();
        if (this.globalConfig.getNamespacedAndroidResources()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variant2));
        boolean debuggable = variantInfo.getVariantBuilder().getDebuggable();
        boolean includeSdkInfoInApk = variantInfo.getVariantBuilder().getDependenciesInfo().getIncludedInApk();
        boolean includeSdkInfoInBundle = variantInfo.getVariantBuilder().getDependenciesInfo().getIncludedInBundle();
        if (!debuggable) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variant2));
        }
        if (variant2.getComponentType().isBaseModule()) {
            this.taskFactory.register(new ParseIntegrityConfigTask.CreationAction(variant2));
            this.taskFactory.register(new PackageBundleTask.CreationAction(variant2));
            if (!debuggable) {
                if (includeSdkInfoInBundle) {
                    this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(variant2));
                }
                if (includeSdkInfoInApk && variant2.getServices().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                    this.taskFactory.register(new SdkDependencyDataGeneratorTask.CreationAction(variant2));
                }
            }
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(variant2));
            if (variant2.getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT)) {
                this.taskFactory.register(new GeneratePrivacySandboxSdkRuntimeConfigFile.CreationAction(variant2));
            }
            this.taskFactory.register(new BundleIdeModelProducerTask.CreationAction(variant2));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant2, "Bundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            this.taskFactory.register(new BundleToApkTask.CreationAction(variant2));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(variant2));
            this.taskFactory.register(new ExtractApksTask.CreationAction(variant2));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant2, "ApksFromBundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            this.taskFactory.register(AnchorTaskNames.INSTANCE.getExtractApksAnchorTaskName(variant2), (Action<? super Task>)new Action(variant2){
                final /* synthetic */ ApplicationCreationConfig $variant;
                {
                    this.$variant = $variant;
                }

                public final void execute(Task it) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.EXTRACTED_APKS.INSTANCE)};
                    it.dependsOn(objectArray);
                }
            });
            this.taskFactory.register(new MergeNativeDebugMetadataTask.CreationAction(variant2));
            variant2.getTaskContainer().getAssembleTask().configure(new Action(variant2){
                final /* synthetic */ ApplicationCreationConfig $variant;
                {
                    this.$variant = $variant;
                }

                public final void execute(Task task) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.MERGED_NATIVE_DEBUG_METADATA.INSTANCE)};
                    task.dependsOn(objectArray);
                }
            });
        }
    }

    private final void createSoftwareComponent(ApplicationCreationConfig appVariant, String componentName, AndroidArtifacts.PublishedConfigType publication) {
        AdhocComponentWithVariants component2 = this.localConfig.getComponentFactory().adhoc(componentName);
        Configuration configuration = appVariant.getVariantDependencies().getElements(new PublishedConfigSpec(publication, componentName, false));
        Intrinsics.checkNotNull((Object)configuration);
        Configuration config2 = configuration;
        component2.addVariantsFromConfiguration(config2, (Action)createSoftwareComponent.1.INSTANCE);
        this.project.getComponents().add((Object)component2);
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (this.globalConfig.getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT) && !creationConfig.getComponentType().isForTesting()) {
            this.taskFactory.register(new BuildPrivacySandboxSdkApks.CreationAction(creationConfig));
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(creationConfig));
            return;
        }
        if (!this.globalConfig.getHasDynamicFeatures() || creationConfig instanceof AndroidTestCreationConfig) {
            super.createInstallTask(creationConfig);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(creationConfig));
        }
    }
}

