/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.dsl.ProductFlavor;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.gradle.internal.core.dsl.ApkProducingComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.ComponentDslInfo;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ComponentType;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u000e\u0018\u0000 G2\u00020\u0001:\u0001GB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016J\u000e\u00107\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016J%\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160:\"\u00020\u0016\u00a2\u0006\u0002\u0010;J+\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010=\u001a\u00020\u00162\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160:H\u0002\u00a2\u0006\u0002\u0010>J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010@\u001a\u00020\u0016J\u000e\u0010A\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\u0016J\u0016\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160:\"\u00020\u0016\u00a2\u0006\u0002\u0010;J%\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160:\"\u00020\u0016\u00a2\u0006\u0002\u0010;J%\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160:\"\u00020\u0016\u00a2\u0006\u0002\u0010;R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000f\u001a\u0004\b \u0010\rR!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b#\u0010\rR!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000f\u001a\u0004\b&\u0010\rR\u001b\u0010(\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u000f\u001a\u0004\b)\u0010\u0018R#\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000f\u001a\u0004\b-\u0010.R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR!\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b3\u0010\r\u00a8\u0006H"}, d2={"Lcom/android/build/gradle/internal/variant/VariantPathHelper;", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "dslInfo", "Lcom/android/build/gradle/internal/core/dsl/ComponentDslInfo;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Lorg/gradle/api/file/DirectoryProperty;Lcom/android/build/gradle/internal/core/dsl/ComponentDslInfo;Lcom/android/build/gradle/internal/services/DslServices;)V", "aarLocation", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAarLocation", "()Lorg/gradle/api/provider/Provider;", "aarLocation$delegate", "Lkotlin/Lazy;", "apkLocation", "Ljava/io/File;", "getApkLocation", "()Ljava/io/File;", "apkLocation$delegate", "baseName", "", "getBaseName", "()Ljava/lang/String;", "baseName$delegate", "buildConfigSourceOutputDir", "getBuildConfigSourceOutputDir", "buildConfigSourceOutputDir$delegate", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "coverageReportDir", "getCoverageReportDir", "coverageReportDir$delegate", "defaultApkLocation", "getDefaultApkLocation", "defaultApkLocation$delegate", "deploymentApkLocation", "getDeploymentApkLocation", "deploymentApkLocation$delegate", "dirName", "getDirName", "dirName$delegate", "directorySegments", "", "getDirectorySegments", "()Ljava/util/Collection;", "directorySegments$delegate", "manifestOutputDirectory", "getManifestOutputDirectory", "renderscriptObjOutputDir", "getRenderscriptObjOutputDir", "renderscriptObjOutputDir$delegate", "computeBaseNameWithSplits", "splitName", "computeFullNameWithSplits", "generatedDir", "subDirs", "", "([Ljava/lang/String;)Lorg/gradle/api/provider/Provider;", "getBuildSubDir", "childDir", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/gradle/api/provider/Provider;", "getGeneratedResourcesDir", "name", "getIncrementalDir", "getOutputFileName", "archivesBaseName", "intermediatesDir", "outputDir", "reportsDir", "Companion", "gradle-core"})
public final class VariantPathHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final ComponentDslInfo dslInfo;
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final Lazy dirName$delegate;
    @NotNull
    private final Lazy directorySegments$delegate;
    @NotNull
    private final Lazy baseName$delegate;
    @NotNull
    private final Lazy buildConfigSourceOutputDir$delegate;
    @NotNull
    private final Lazy renderscriptObjOutputDir$delegate;
    @NotNull
    private final Lazy coverageReportDir$delegate;
    @NotNull
    private final Lazy apkLocation$delegate;
    @NotNull
    private final Lazy defaultApkLocation$delegate;
    @NotNull
    private final Lazy deploymentApkLocation$delegate;
    @NotNull
    private final Lazy aarLocation$delegate;

    public VariantPathHelper(@NotNull DirectoryProperty buildDirectory, @NotNull ComponentDslInfo dslInfo, @NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkNotNullParameter((Object)dslInfo, (String)"dslInfo");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        this.buildDirectory = buildDirectory;
        this.dslInfo = dslInfo;
        this.dslServices = dslServices2;
        this.dirName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return Joiner.on((char)'/').join((Iterable)this.this$0.getDirectorySegments());
            }
        }));
        this.directorySegments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImmutableList<String>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ImmutableList<String> invoke() {
                ImmutableList.Builder builder = ImmutableList.builder();
                if (VariantPathHelper.access$getDslInfo$p(this.this$0).getComponentType().isNestedComponent()) {
                    builder.add((Object)VariantPathHelper.access$getDslInfo$p(this.this$0).getComponentType().getPrefix());
                }
                if (!((Collection)VariantPathHelper.access$getDslInfo$p(this.this$0).getProductFlavorList()).isEmpty()) {
                    builder.add((Object)StringHelper.combineAsCamelCase((Collection)VariantPathHelper.access$getDslInfo$p(this.this$0).getProductFlavorList(), (Function1)directorySegments.1.INSTANCE));
                }
                String string = VariantPathHelper.access$getDslInfo$p(this.this$0).getBuildType();
                Intrinsics.checkNotNull((Object)string);
                builder.add((Object)string);
                return builder.build();
            }
        }));
        this.baseName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return VariantPathHelper.Companion.computeBaseName(VariantPathHelper.access$getDslInfo$p(this.this$0), VariantPathHelper.access$getDslInfo$p(this.this$0).getComponentType());
            }
        }));
        this.buildConfigSourceOutputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"source", "buildConfig", this.this$0.getDirName()};
                return this.this$0.generatedDir(stringArray);
            }
        }));
        this.renderscriptObjOutputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                Object[] objectArray = new Object[]{"rs", this.this$0.getDirectorySegments(), "obj"};
                Collection $this$toTypedArray$iv = StringHelper.toStrings((Object[])objectArray);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                return VariantPathHelper.access$getBuildSubDir(this.this$0, "intermediates", stringArray);
            }
        }));
        this.coverageReportDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"coverage", this.this$0.getDirName()};
                return this.this$0.reportsDir(stringArray);
            }
        }));
        this.apkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                String override = VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_APK_LOCATION);
                boolean customBuild = VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_BUILD_TARGET_DENSITY) != null || VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_BUILD_TARGET_ABI) != null || VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(IntegerOption.IDE_TARGET_DEVICE_API) != null;
                File baseDirectory = override != null ? VariantPathHelper.access$getDslServices$p(this.this$0).file(override) : (customBuild ? ((Directory)VariantPathHelper.access$getDeploymentApkLocation(this.this$0).get()).getAsFile() : ((Directory)VariantPathHelper.access$getDefaultApkLocation(this.this$0).get()).getAsFile());
                return new File(baseDirectory, this.this$0.getDirName());
            }
        }));
        this.defaultApkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"apk"};
                return this.this$0.outputDir(stringArray);
            }
        }));
        this.deploymentApkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"apk"};
                return this.this$0.intermediatesDir(stringArray);
            }
        }));
        this.aarLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"aar"};
                return this.this$0.outputDir(stringArray);
            }
        }));
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final String getDirName() {
        Lazy lazy = this.dirName$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-dirName>(...)");
        return (String)object;
    }

    @NotNull
    public final Collection<String> getDirectorySegments() {
        Lazy lazy = this.directorySegments$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-directorySegments>(...)");
        return (Collection)object;
    }

    @NotNull
    public final String getOutputFileName(@NotNull String archivesBaseName, @NotNull String baseName2) {
        Intrinsics.checkNotNullParameter((Object)archivesBaseName, (String)"archivesBaseName");
        Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
        ComponentDslInfo componentDslInfo = this.dslInfo;
        ApkProducingComponentDslInfo apkProducingComponentDslInfo = componentDslInfo instanceof ApkProducingComponentDslInfo ? (ApkProducingComponentDslInfo)componentDslInfo : null;
        String suffix = (apkProducingComponentDslInfo != null ? apkProducingComponentDslInfo.isSigningReady() : false) || !this.dslInfo.getComponentType().isBaseModule() ? ".apk" : "-unsigned.apk";
        return archivesBaseName + "-" + baseName2 + suffix;
    }

    @NotNull
    public final String computeFullNameWithSplits(@NotNull String splitName) {
        Intrinsics.checkNotNullParameter((Object)splitName, (String)"splitName");
        return Companion.computeFullNameWithSplits(this.dslInfo.getComponentIdentity(), this.dslInfo.getComponentType(), splitName);
    }

    @NotNull
    public final String getBaseName() {
        Lazy lazy = this.baseName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String computeBaseNameWithSplits(@NotNull String splitName) {
        Intrinsics.checkNotNullParameter((Object)splitName, (String)"splitName");
        StringBuilder sb = new StringBuilder();
        if (!((Collection)this.dslInfo.getProductFlavorList()).isEmpty()) {
            for (ProductFlavor pf : this.dslInfo.getProductFlavorList()) {
                sb.append(pf.getName()).append('-');
            }
        }
        sb.append(splitName).append('-');
        String string = this.dslInfo.getBuildType();
        Intrinsics.checkNotNull((Object)string);
        sb.append(string);
        if (this.dslInfo.getComponentType().isNestedComponent()) {
            sb.append('-').append(this.dslInfo.getComponentType().getPrefix());
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    @NotNull
    public final Provider<Directory> intermediatesDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("intermediates", subDirs);
    }

    @NotNull
    public final Provider<Directory> outputDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("outputs", subDirs);
    }

    @NotNull
    public final Provider<Directory> generatedDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("generated", subDirs);
    }

    @NotNull
    public final Provider<Directory> reportsDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("reports", subDirs);
    }

    @NotNull
    public final Provider<Directory> getBuildConfigSourceOutputDir() {
        Lazy lazy = this.buildConfigSourceOutputDir$delegate;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getRenderscriptObjOutputDir() {
        Lazy lazy = this.renderscriptObjOutputDir$delegate;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getCoverageReportDir() {
        Lazy lazy = this.coverageReportDir$delegate;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final File getApkLocation() {
        Lazy lazy = this.apkLocation$delegate;
        return (File)lazy.getValue();
    }

    private final Provider<Directory> getDefaultApkLocation() {
        Lazy lazy = this.defaultApkLocation$delegate;
        return (Provider)lazy.getValue();
    }

    private final Provider<Directory> getDeploymentApkLocation() {
        Lazy lazy = this.deploymentApkLocation$delegate;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getAarLocation() {
        Lazy lazy = this.aarLocation$delegate;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getManifestOutputDirectory() {
        ComponentType componentType = this.dslInfo.getComponentType();
        if (componentType.isTestComponent()) {
            if (componentType.isApk()) {
                String[] stringArray = new String[]{"manifest", this.getDirName()};
                return this.intermediatesDir(stringArray);
            }
        } else {
            String[] stringArray = new String[]{"manifests", "full", this.getDirName()};
            return this.intermediatesDir(stringArray);
        }
        throw new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @NotNull
    public final File getIncrementalDir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{"incremental", name};
        File file = ((Directory)this.intermediatesDir(stringArray).get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"intermediatesDir(\"incremental\", name).get().asFile");
        return file;
    }

    @NotNull
    public final Provider<Directory> getGeneratedResourcesDir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new String[]{"res", name};
        List dirs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.filterNotNull((Iterable)this.getDirectorySegments()));
        Collection $this$toTypedArray$iv = dirs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        objectArray = stringArray;
        return this.generatedDir((String[])Arrays.copyOf(objectArray, objectArray.length));
    }

    private final Provider<Directory> getBuildSubDir(String childDir, String[] subDirs) {
        if (ArraysKt.any((Object[])subDirs) && StringsKt.contains$default((CharSequence)((CharSequence)ArraysKt.last((Object[])subDirs)), (char)'.', (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Directory should not contain '.'.");
        }
        Provider provider2 = this.buildDirectory.dir(childDir + ArraysKt.joinToString$default((Object[])subDirs, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildDirectory.dir(\"$chi\u2026r = \"/\", prefix = \"/\")}\")");
        return provider2;
    }

    @JvmStatic
    @NotNull
    public static final String computeBaseName(@NotNull DimensionCombination dimensionCombination, @NotNull ComponentType componentType) {
        return Companion.computeBaseName(dimensionCombination, componentType);
    }

    @JvmStatic
    @NotNull
    public static final String computeFullNameWithSplits(@NotNull ComponentIdentity variantConfiguration, @NotNull ComponentType componentType, @NotNull String splitName) {
        return Companion.computeFullNameWithSplits(variantConfiguration, componentType, splitName);
    }

    public static final /* synthetic */ ComponentDslInfo access$getDslInfo$p(VariantPathHelper $this) {
        return $this.dslInfo;
    }

    public static final /* synthetic */ Provider access$getBuildSubDir(VariantPathHelper $this, String childDir, String[] subDirs) {
        return $this.getBuildSubDir(childDir, subDirs);
    }

    public static final /* synthetic */ DslServices access$getDslServices$p(VariantPathHelper $this) {
        return $this.dslServices;
    }

    public static final /* synthetic */ Provider access$getDeploymentApkLocation(VariantPathHelper $this) {
        return $this.getDeploymentApkLocation();
    }

    public static final /* synthetic */ Provider access$getDefaultApkLocation(VariantPathHelper $this) {
        return $this.getDefaultApkLocation();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/variant/VariantPathHelper$Companion;", "", "()V", "computeBaseName", "", "dimensionCombination", "Lcom/android/build/gradle/internal/variant/DimensionCombination;", "componentType", "Lcom/android/builder/core/ComponentType;", "computeFullNameWithSplits", "variantConfiguration", "Lcom/android/build/api/variant/ComponentIdentity;", "splitName", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String computeBaseName(@NotNull DimensionCombination dimensionCombination, @NotNull ComponentType componentType) {
            Intrinsics.checkNotNullParameter((Object)dimensionCombination, (String)"dimensionCombination");
            Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
            StringBuilder sb = new StringBuilder();
            if (!((Collection)dimensionCombination.getProductFlavors()).isEmpty()) {
                Iterator<Pair<String, String>> iterator2 = dimensionCombination.getProductFlavors().iterator();
                while (iterator2.hasNext()) {
                    String name = (String)iterator2.next().component2();
                    if (((CharSequence)sb).length() > 0) {
                        sb.append('-');
                    }
                    sb.append(name);
                }
            }
            String string = dimensionCombination.getBuildType();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (((CharSequence)sb).length() > 0) {
                    sb.append('-');
                }
                sb.append(it);
            }
            if (componentType.isNestedComponent()) {
                if (((CharSequence)sb).length() > 0) {
                    sb.append('-');
                }
                sb.append(componentType.getPrefix());
            }
            if (((CharSequence)sb).length() == 0) {
                sb.append("main");
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String computeFullNameWithSplits(@NotNull ComponentIdentity variantConfiguration, @NotNull ComponentType componentType, @NotNull String splitName) {
            Intrinsics.checkNotNullParameter((Object)variantConfiguration, (String)"variantConfiguration");
            Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
            Intrinsics.checkNotNullParameter((Object)splitName, (String)"splitName");
            StringBuilder sb = new StringBuilder();
            String flavorName2 = variantConfiguration.getFlavorName();
            CharSequence charSequence = flavorName2;
            if (!(charSequence == null || charSequence.length() == 0)) {
                sb.append(flavorName2);
                StringHelper.appendCapitalized((StringBuilder)sb, (String)splitName);
            } else {
                sb.append(splitName);
            }
            String string = variantConfiguration.getBuildType();
            if (string != null) {
                String it = string;
                boolean bl = false;
                StringHelper.appendCapitalized((StringBuilder)sb, (String)it);
            }
            if (componentType.isNestedComponent()) {
                sb.append(componentType.getSuffix());
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

