/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.gradle.internal.instrumentation.ClassesHierarchyResolver;
import com.android.build.gradle.internal.instrumentation.InstrumentationIssueHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J4\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/instrumentation/FixFramesClassWriter;", "Lorg/objectweb/asm/ClassWriter;", "flags", "", "classesHierarchyResolver", "Lcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;", "(ILcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;)V", "classReader", "Lorg/objectweb/asm/ClassReader;", "issueHandler", "Lcom/android/build/gradle/internal/instrumentation/InstrumentationIssueHandler;", "(Lorg/objectweb/asm/ClassReader;ILcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;Lcom/android/build/gradle/internal/instrumentation/InstrumentationIssueHandler;)V", "getClassesHierarchyResolver", "()Lcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;", "objectClassInternalName", "", "getCommonSuperClass", "firstType", "secondType", "getCommonSuperClassForArrayTypes", "getNumberOfCharInPrefix", "string", "char", "", "isAssignableFrom", "", "type", "otherType", "otherTypeInterfaces", "", "otherTypeSuperClasses", "gradle-core"})
public class FixFramesClassWriter
extends ClassWriter {
    @NotNull
    private final String objectClassInternalName;
    @Nullable
    private final InstrumentationIssueHandler issueHandler;
    @NotNull
    private final ClassesHierarchyResolver classesHierarchyResolver;

    @NotNull
    public final ClassesHierarchyResolver getClassesHierarchyResolver() {
        return this.classesHierarchyResolver;
    }

    public FixFramesClassWriter(int flags, @NotNull ClassesHierarchyResolver classesHierarchyResolver) {
        Intrinsics.checkNotNullParameter((Object)classesHierarchyResolver, (String)"classesHierarchyResolver");
        super(flags);
        this.objectClassInternalName = "java/lang/Object";
        this.classesHierarchyResolver = classesHierarchyResolver;
        this.issueHandler = null;
    }

    public FixFramesClassWriter(@NotNull ClassReader classReader, int flags, @NotNull ClassesHierarchyResolver classesHierarchyResolver, @Nullable InstrumentationIssueHandler issueHandler) {
        Intrinsics.checkNotNullParameter((Object)classReader, (String)"classReader");
        Intrinsics.checkNotNullParameter((Object)classesHierarchyResolver, (String)"classesHierarchyResolver");
        super(classReader, flags);
        this.objectClassInternalName = "java/lang/Object";
        this.classesHierarchyResolver = classesHierarchyResolver;
        this.issueHandler = issueHandler;
    }

    private final boolean isAssignableFrom(String type, String otherType, List<String> otherTypeInterfaces, List<String> otherTypeSuperClasses) {
        return Intrinsics.areEqual((Object)type, (Object)otherType) || otherTypeInterfaces.contains(type) || otherTypeSuperClasses.contains(type);
    }

    private final int getNumberOfCharInPrefix(String string, char c) {
        int count = 0;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 != c) {
                return count;
            }
            ++count;
        }
        return count;
    }

    private final String getCommonSuperClassForArrayTypes(String firstType, String secondType) {
        int secondTypeArrayNestingDepth;
        int firstTypeArrayNestingDepth = this.getNumberOfCharInPrefix(firstType, '[');
        if (firstTypeArrayNestingDepth != (secondTypeArrayNestingDepth = this.getNumberOfCharInPrefix(secondType, '['))) {
            return this.objectClassInternalName;
        }
        String string = firstType.substring(firstTypeArrayNestingDepth + 1, firstType.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String firstComponentType = string;
        String string2 = secondType.substring(firstTypeArrayNestingDepth + 1, secondType.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String secondComponentType = string2;
        List<String> firstTypeInterfaces = this.classesHierarchyResolver.getAllInterfacesInInternalForm(firstComponentType);
        List<String> firstTypeSuperClasses = this.classesHierarchyResolver.getAllSuperClassesInInternalForm(firstComponentType);
        List<String> secondTypeInterfaces = this.classesHierarchyResolver.getAllInterfacesInInternalForm(secondComponentType);
        List<String> secondTypeSuperClasses = this.classesHierarchyResolver.getAllSuperClassesInInternalForm(secondComponentType);
        if (this.isAssignableFrom(firstComponentType, secondComponentType, secondTypeInterfaces, secondTypeSuperClasses)) {
            return firstType;
        }
        if (this.isAssignableFrom(secondComponentType, firstComponentType, firstTypeInterfaces, firstTypeSuperClasses)) {
            return secondType;
        }
        return this.objectClassInternalName;
    }

    @NotNull
    protected String getCommonSuperClass(@NotNull String firstType, @NotNull String secondType) {
        block6: {
            List<String> secondTypeSuperClasses;
            Intrinsics.checkNotNullParameter((Object)firstType, (String)"firstType");
            Intrinsics.checkNotNullParameter((Object)secondType, (String)"secondType");
            if (StringsKt.startsWith$default((CharSequence)firstType, (char)'[', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)secondType, (char)'[', (boolean)false, (int)2, null)) {
                return this.getCommonSuperClassForArrayTypes(firstType, secondType);
            }
            List<String> firstTypeInterfaces = this.classesHierarchyResolver.getAllInterfacesInInternalForm(firstType);
            List<String> firstTypeSuperClasses = this.classesHierarchyResolver.getAllSuperClassesInInternalForm(firstType);
            List<String> secondTypeInterfaces = this.classesHierarchyResolver.getAllInterfacesInInternalForm(secondType);
            if (this.isAssignableFrom(firstType, secondType, secondTypeInterfaces, secondTypeSuperClasses = this.classesHierarchyResolver.getAllSuperClassesInInternalForm(secondType))) {
                return firstType;
            }
            if (this.isAssignableFrom(secondType, firstType, firstTypeInterfaces, firstTypeSuperClasses)) {
                return secondType;
            }
            Iterable $this$forEach$iv = firstTypeSuperClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String firstTypeSuperClass = (String)element$iv;
                boolean bl = false;
                if (!this.isAssignableFrom(firstTypeSuperClass, secondType, secondTypeInterfaces, secondTypeSuperClasses)) continue;
                return firstTypeSuperClass;
            }
            InstrumentationIssueHandler instrumentationIssueHandler = this.issueHandler;
            if (instrumentationIssueHandler == null) break block6;
            InstrumentationIssueHandler it = instrumentationIssueHandler;
            boolean bl = false;
            if (firstTypeSuperClasses.isEmpty() && !Intrinsics.areEqual((Object)firstType, (Object)this.objectClassInternalName)) {
                this.issueHandler.warnAboutClassNotOnTheClasspath(firstType);
            }
            if (secondTypeSuperClasses.isEmpty() && !Intrinsics.areEqual((Object)secondType, (Object)this.objectClassInternalName)) {
                this.issueHandler.warnAboutClassNotOnTheClasspath(secondType);
            }
        }
        return this.objectClassInternalName;
    }
}

